/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.intersect.IntersectPointRay;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectRayRay {
    private IntersectRayRay() {
    }

    public static IntersectionResultEx intersectRayRayEx(Point2D ao, Point2D ad, Point2D bo, Point2D bd) {
        return IntersectRayRay.intersectRayRayEx(ao.getX(), ao.getY(), ad.getX(), ad.getY(), bo.getX(), bo.getY(), bd.getX(), bd.getY());
    }

    public static IntersectionResultEx intersectRayRayEx(double aox, double aoy, double adx, double ady, double box, double boy, double bdx, double bdy) {
        return IntersectRayRay.intersectRayRayEx(aox, aoy, adx, ady, Double.MAX_VALUE, box, boy, bdx, bdy, Double.MAX_VALUE, 1.0E-8);
    }

    public static IntersectionResultEx intersectRayRayEx(double aox, double aoy, double adx, double ady, double amax, double box, double boy, double bdx, double bdy, double bmax, double epsilon) {
        IntersectionStatus status;
        Point2D.Double derivativeA = new Point2D.Double(adx, ady);
        Point2D.Double derivativeB = new Point2D.Double(bdx, bdy);
        ArrayList<IntersectionPointEx> result = new ArrayList<IntersectionPointEx>();
        double doy = aoy - boy;
        double dox = aox - box;
        double ua_t = bdx * doy - bdy * dox;
        double ub_t = adx * doy - ady * dox;
        double u_b = bdy * adx - bdx * ady;
        if (!Points.almostZero(u_b, epsilon)) {
            double ua = ua_t / u_b;
            double ub = ub_t / u_b;
            if (-epsilon <= ua && ua <= amax && -epsilon <= ub && ub <= bmax) {
                status = IntersectionStatus.INTERSECTION;
                result.add(new IntersectionPointEx(new Point2D.Double(aox + ua * adx, aoy + ua * ady), ua, derivativeA, ub, derivativeB));
            } else {
                status = IntersectionStatus.NO_INTERSECTION;
                result.add(new IntersectionPointEx(new Point2D.Double(aox + ua * adx, aoy + ua * ady), ua, derivativeA, ub, derivativeB));
            }
        } else if (Points.almostZero(ua_t) || Points.almostZero(ub_t)) {
            boolean bIsPoint;
            boolean aIsPoint = Points.almostZero(amax * adx, epsilon) && Points.almostZero(amax * ady, epsilon);
            boolean bl = bIsPoint = Points.almostZero(bmax * bdx, epsilon) && Points.almostZero(bmax * bdy, epsilon);
            if (aIsPoint && bIsPoint) {
                if (Points.almostEqual(aox, box) && Points.almostEqual(aoy, boy)) {
                    status = IntersectionStatus.INTERSECTION;
                    result.add(new IntersectionPointEx(new Point2D.Double(aox, aoy), 0.0, derivativeA, 0.0, derivativeB));
                } else {
                    status = IntersectionStatus.NO_INTERSECTION_PARALLEL;
                }
            } else if (aIsPoint) {
                Double argB = IntersectPointRay.argumentOnRay(box, boy, bdx, bdy, bmax, aox, aoy, epsilon);
                if (argB != null) {
                    status = IntersectionStatus.INTERSECTION;
                    result.add(new IntersectionPointEx(new Point2D.Double(aox, aoy), 0.0, derivativeA, MathUtil.clamp((double)argB, (double)0.0, (double)bmax), derivativeB));
                } else {
                    status = IntersectionStatus.NO_INTERSECTION_PARALLEL;
                }
            } else if (bIsPoint) {
                Double argA = IntersectPointRay.argumentOnRay(aox, aoy, adx, ady, bmax, box, boy, epsilon);
                if (argA != null) {
                    status = IntersectionStatus.INTERSECTION;
                    result.add(new IntersectionPointEx(new Point2D.Double(box, boy), MathUtil.clamp((double)argA, (double)0.0, (double)amax), derivativeA, 0.0, derivativeB));
                } else {
                    status = IntersectionStatus.NO_INTERSECTION_PARALLEL;
                }
            } else {
                double at1;
                double at0;
                if (Points.almostZero(adx)) {
                    at0 = (boy - aoy) / ady;
                    at1 = (bdy + boy - aoy) / ady;
                } else {
                    at0 = (box - aox) / adx;
                    at1 = (bdx + box - aox) / adx;
                }
                if (at0 > at1) {
                    double swap = at0;
                    at0 = at1;
                    at1 = swap;
                }
                if (at0 < 1.0 + epsilon && at1 > -epsilon) {
                    double bt1;
                    double bt0;
                    at0 = MathUtil.clamp((double)at0, (double)0.0, (double)amax);
                    at1 = MathUtil.clamp((double)at1, (double)0.0, (double)bmax);
                    if (Points.almostZero(bdx)) {
                        bt0 = (aoy + at0 * ady - boy) / bdy;
                        bt1 = (aoy + at1 * ady - boy) / bdy;
                    } else {
                        bt0 = (aox + at0 * adx - box) / bdx;
                        bt1 = (aox + at1 * adx - box) / bdx;
                    }
                    status = IntersectionStatus.NO_INTERSECTION_COINCIDENT;
                    result.add(new IntersectionPointEx(new Point2D.Double(aox + at0 * adx, aoy + at0 * ady), at0, derivativeA, bt0, derivativeB));
                    result.add(new IntersectionPointEx(new Point2D.Double(aox + at1 * adx, aoy + at1 * ady), at1, derivativeA, bt1, derivativeB));
                } else {
                    status = IntersectionStatus.NO_INTERSECTION_PARALLEL;
                }
            }
        } else {
            status = IntersectionStatus.NO_INTERSECTION_PARALLEL;
        }
        return new IntersectionResultEx(status, result);
    }
}

