/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import org.jhotdraw8.geom.intersect.IntersectionPoint;

public class IntersectionPointEx
extends IntersectionPoint {
    private static final long serialVersionUID = 0L;
    private final double argumentB;
    private final Point2D.Double derivativeA;
    private final Point2D.Double derivativeB;
    private final int segmentB;

    public IntersectionPointEx(Point2D.Double point, double argumentA, Point2D.Double derivativeA, double argumentB, Point2D.Double derivativeB) {
        this(point, argumentA, derivativeA, 0, argumentB, derivativeB, 0);
    }

    public IntersectionPointEx(double px, double py, double argumentA, double derivativeAX, double derivativeAY, double argumentB, double derivativeBX, double derivativeBY) {
        this(px, py, argumentA, derivativeAX, derivativeAY, 0, argumentB, derivativeBX, derivativeBY, 0);
    }

    public IntersectionPointEx(Point2D.Double point, double argumentA, Point2D.Double derivativeA, int segmentA, double argumentB, Point2D.Double derivativeB, int segmentB) {
        super(point.getX(), point.getY(), argumentA, segmentA);
        this.derivativeA = derivativeA;
        this.argumentB = argumentB;
        this.derivativeB = derivativeB;
        this.segmentB = segmentB;
    }

    public IntersectionPointEx(double px, double py, double argumentA, double tx1, double ty1, int segmentA, double t2, double tx2, double ty2, int segmentB) {
        super(px, py, argumentA, segmentA);
        this.derivativeA = new Point2D.Double(tx1, ty1);
        this.argumentB = t2;
        this.derivativeB = new Point2D.Double(tx2, ty2);
        this.segmentB = segmentB;
    }

    public int getSegmentB() {
        return this.segmentB;
    }

    public Point2D.Double getDerivativeA() {
        return this.derivativeA;
    }

    public double getArgumentB() {
        return this.argumentB;
    }

    public Point2D.Double getDerivativeB() {
        return this.derivativeB;
    }

    public IntersectionPointEx withSegmentA(int segmentIndex) {
        return new IntersectionPointEx(this, this.argumentA, this.derivativeA, segmentIndex, this.argumentB, this.derivativeB, this.segmentB);
    }

    public IntersectionPointEx withSegmentB(int segmentIndex) {
        return new IntersectionPointEx(this, this.argumentA, this.derivativeA, this.segmentA, this.argumentB, this.derivativeB, segmentIndex);
    }

    @Override
    public String toString() {
        return "IntersectionPoint{t1=" + this.argumentA + ", t2=" + this.argumentB + ", point=" + this.getX() + ", " + this.getY() + ", tangent1=" + String.valueOf(this.derivativeA) + ", tangent2=" + String.valueOf(this.derivativeB) + ", segment1=" + this.segmentA + ", segment2=" + this.segmentB + "}";
    }
}

