/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.util.AbstractCollection;
import java.util.Collection;
import org.jhotdraw8.collection.primitive.DoubleArrayList;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionStatus;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableCollection;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class IntersectionResult {
    private final IntersectionStatus status;
    private final ImmutableList<IntersectionPoint> intersections;

    public IntersectionResult(IntersectionStatus status, Collection<? extends IntersectionPoint> copyItems) {
        this.intersections = VectorList.copyOf(copyItems);
        this.status = status;
    }

    public IntersectionResult(IntersectionStatus status, ImmutableCollection<? extends IntersectionPoint> copyItems) {
        this.intersections = VectorList.copyOf(copyItems);
        this.status = status;
    }

    public IntersectionResult(Collection<? extends IntersectionPoint> copyItems) {
        this(copyItems.isEmpty() ? IntersectionStatus.NO_INTERSECTION : IntersectionStatus.INTERSECTION, copyItems);
    }

    public IntersectionStatus getStatus() {
        return this.status;
    }

    public DoubleArrayList getAllArgumentsA() {
        return this.intersections.stream().mapToDouble(IntersectionPoint::argumentA).collect(DoubleArrayList::new, DoubleArrayList::add, AbstractCollection::addAll);
    }

    public ImmutableList<IntersectionPoint> intersections() {
        return this.intersections;
    }
}

