/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.shape;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.function.BiFunction;
import javafx.scene.transform.Transform;
import org.jhotdraw8.geom.Points2D;
import org.jspecify.annotations.Nullable;

public class BezierNode {
    public static final int POINT_MASK = 1;
    public static final int IN_MASK = 2;
    public static final int POINT_OUT_MASK = 3;
    public static final int OUT_MASK = 4;
    public static final int IN_OUT_MASK = 6;
    public static final int POINT_IN_OUT_MASK = 7;
    public static final int C0C2_MASK = 5;
    public static final int MOVE_MASK = 8;
    public static final int CLOSE_MASK = 16;
    private final boolean collinear;
    private final boolean equidistant;
    private final int mask;
    private final double pointX;
    private final double inX;
    private final double outX;
    private final double pointY;
    private final double inY;
    private final double outY;

    public BezierNode(double pointX, double pointY) {
        this.mask = 1;
        this.collinear = false;
        this.equidistant = false;
        this.pointX = pointX;
        this.inX = pointX;
        this.outX = pointX;
        this.pointY = pointY;
        this.inY = pointY;
        this.outY = pointY;
    }

    public BezierNode(Point2D p) {
        this.mask = 1;
        this.collinear = false;
        this.equidistant = false;
        this.pointX = p.getX();
        this.inX = p.getX();
        this.outX = p.getX();
        this.pointY = p.getY();
        this.inY = p.getY();
        this.outY = p.getY();
    }

    public BezierNode(javafx.geometry.Point2D p) {
        this.mask = 1;
        this.collinear = false;
        this.equidistant = false;
        this.pointX = p.getX();
        this.inX = p.getX();
        this.outX = p.getX();
        this.pointY = p.getY();
        this.inY = p.getY();
        this.outY = p.getY();
    }

    public BezierNode(int mask, boolean equidistant, boolean collinear, Point2D p, Point2D i, Point2D o) {
        this.mask = mask;
        this.collinear = collinear;
        this.equidistant = equidistant;
        this.pointX = p.getX();
        this.inX = i.getX();
        this.outX = o.getX();
        this.pointY = p.getY();
        this.inY = i.getY();
        this.outY = o.getY();
    }

    public BezierNode(int mask, boolean equidistant, boolean collinear, double pointX, double pointY, double inX, double inY, double outX, double outY) {
        this.mask = mask;
        this.collinear = collinear;
        this.equidistant = equidistant;
        this.pointX = pointX;
        this.inX = inX;
        this.outX = outX;
        this.pointY = pointY;
        this.inY = inY;
        this.outY = outY;
    }

    public boolean computeIsCollinear() {
        if ((this.mask & 8) != 0 || (this.mask & 6) != 6) {
            return false;
        }
        Point2D c0 = this.getPoint();
        Point2D c2 = this.getOut();
        Point2D c1 = this.getIn();
        Point2D.Double t1 = Points2D.subtract(c1, c0);
        Point2D.Double t2 = Points2D.subtract(c2, c0);
        return 1.0 - Math.abs(Points2D.dotProduct(Points2D.normalize(t1), Points2D.normalize(t2))) < 1.0E-4;
    }

    public boolean computeIsEquidistant() {
        if ((this.mask & 8) != 0 || (this.mask & 6) != 6) {
            return false;
        }
        Point2D c0 = this.getPoint();
        Point2D c2 = this.getOut();
        Point2D c1 = this.getIn();
        Point2D.Double t1 = Points2D.subtract(c1, c0);
        Point2D.Double t2 = Points2D.subtract(c2, c0);
        return Math.abs(Points2D.magnitude(t1) - Points2D.magnitude(t2)) < 1.0E-4;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BezierNode other = (BezierNode)obj;
        if (this.mask != other.mask) {
            return false;
        }
        if (this.collinear != other.collinear) {
            return false;
        }
        if (this.equidistant != other.equidistant) {
            return false;
        }
        if (Double.doubleToLongBits(this.pointX) != Double.doubleToLongBits(other.pointX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.inX) != Double.doubleToLongBits(other.inX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.outX) != Double.doubleToLongBits(other.outX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.pointY) != Double.doubleToLongBits(other.pointY)) {
            return false;
        }
        if (Double.doubleToLongBits(this.inY) != Double.doubleToLongBits(other.inY)) {
            return false;
        }
        return Double.doubleToLongBits(this.outY) == Double.doubleToLongBits(other.outY);
    }

    public Point2D getC(int mask) {
        return switch (mask) {
            case 1 -> this.getPoint();
            case 2 -> this.getIn();
            case 4 -> this.getOut();
            default -> throw new IllegalArgumentException("illegal mask:" + mask);
        };
    }

    public <T> T getC(int mask, BiFunction<Double, Double, T> f) {
        return switch (mask) {
            case 1 -> this.getPoint(f);
            case 2 -> this.getIn(f);
            case 4 -> this.getOut(f);
            default -> throw new IllegalArgumentException("illegal mask:" + mask);
        };
    }

    public Point2D getPoint() {
        return new Point2D.Double(this.pointX, this.pointY);
    }

    public Point2D getIn() {
        return new Point2D.Double(this.inX, this.inY);
    }

    public <T> T getOut(BiFunction<Double, Double, T> f) {
        return f.apply(this.outX, this.outY);
    }

    public <T> T getPoint(BiFunction<Double, Double, T> f) {
        return f.apply(this.pointX, this.pointY);
    }

    public <T> T getIn(BiFunction<Double, Double, T> f) {
        return f.apply(this.inX, this.inY);
    }

    public Point2D getOut() {
        return new Point2D.Double(this.outX, this.outY);
    }

    public int getMask() {
        return this.mask;
    }

    public boolean hasMask(int probe) {
        return (this.mask & probe) == probe;
    }

    public double getMaxX() {
        double maxX = this.pointX;
        if ((this.mask & 8) == 0) {
            if ((this.mask & 2) != 0 && this.inX > maxX) {
                maxX = this.inX;
            }
            if ((this.mask & 4) != 0 && this.outX > maxX) {
                maxX = this.outX;
            }
        }
        return maxX;
    }

    public double getMaxY() {
        double maxY = this.pointY;
        if ((this.mask & 8) == 0) {
            if ((this.mask & 2) != 0 && this.inY > maxY) {
                maxY = this.inY;
            }
            if ((this.mask & 4) != 0 && this.outY > maxY) {
                maxY = this.outY;
            }
        }
        return maxY;
    }

    public double getMinX() {
        double minX = this.pointX;
        if ((this.mask & 8) == 0) {
            if ((this.mask & 2) != 0 && this.inX < minX) {
                minX = this.inX;
            }
            if ((this.mask & 4) != 0 && this.outX < minX) {
                minX = this.outX;
            }
        }
        return minX;
    }

    public double getMinY() {
        double minY = this.pointY;
        if ((this.mask & 8) == 0) {
            if ((this.mask & 2) != 0 && this.inY < minY) {
                minY = this.inY;
            }
            if ((this.mask & 4) != 0 && this.outY < minY) {
                minY = this.outY;
            }
        }
        return minY;
    }

    public double getX(int mask) {
        return switch (mask) {
            case 1 -> this.pointX();
            case 2 -> this.inX();
            case 4 -> this.outX();
            default -> throw new IllegalArgumentException("illegal mask:" + mask);
        };
    }

    public double pointX() {
        return this.pointX;
    }

    public BezierNode withPx(double px) {
        return new BezierNode(this.mask, this.equidistant, this.collinear, px, this.pointY, this.inX, this.inY, this.outX, this.outY);
    }

    public double inX() {
        return this.inX;
    }

    public BezierNode withIx(double ix) {
        return new BezierNode(this.mask, this.equidistant, this.collinear, this.pointX, this.pointY, ix, this.inY, this.outX, this.outY);
    }

    public double outX() {
        return this.outX;
    }

    public BezierNode withOx(double ox) {
        return new BezierNode(this.mask, this.equidistant, this.collinear, this.pointX, this.pointY, this.inX, this.inY, ox, this.outY);
    }

    public double getY(int mask) {
        return switch (mask) {
            case 1 -> this.pointY();
            case 2 -> this.inY();
            case 4 -> this.outY();
            default -> throw new IllegalArgumentException("illegal mask:" + mask);
        };
    }

    public double pointY() {
        return this.pointY;
    }

    public BezierNode withPointY(double py) {
        return new BezierNode(this.mask, this.equidistant, this.collinear, this.pointX, py, this.inX, this.inY, this.outX, this.outY);
    }

    public double inY() {
        return this.inY;
    }

    public BezierNode withIy(double iy) {
        return new BezierNode(this.mask, this.equidistant, this.collinear, this.pointX, this.pointY, this.inX, iy, this.outX, this.outY);
    }

    public double outY() {
        return this.outY;
    }

    public BezierNode withOy(double oy) {
        return new BezierNode(this.mask, this.equidistant, this.collinear, this.pointX, this.pointY, this.inX, this.inY, this.outX, oy);
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + this.mask;
        hash = 59 * hash + (this.collinear ? 1 : 0);
        hash = 59 * hash + (this.equidistant ? 1 : 0);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.pointX) ^ Double.doubleToLongBits(this.pointX) >>> 32);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.inX) ^ Double.doubleToLongBits(this.inX) >>> 32);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.outX) ^ Double.doubleToLongBits(this.outX) >>> 32);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.pointY) ^ Double.doubleToLongBits(this.pointY) >>> 32);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.inY) ^ Double.doubleToLongBits(this.inY) >>> 32);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.outY) ^ Double.doubleToLongBits(this.outY) >>> 32);
        return hash;
    }

    public boolean hasMaskBits(int mask) {
        return (this.mask & mask) == mask;
    }

    public boolean hasIn() {
        return (this.mask & 2) == 2;
    }

    public boolean hasOut() {
        return (this.mask & 4) == 4;
    }

    public boolean isCollinear() {
        return this.collinear;
    }

    public boolean isEquidistant() {
        return this.equidistant;
    }

    public boolean isMoveTo() {
        return (this.mask & 8) == 8;
    }

    public boolean isClosePath() {
        return !this.isMoveTo() && (this.mask & 0x10) == 16;
    }

    public BezierNode withC(int mask, Point2D c) {
        return this.withC(mask, c.getX(), c.getY());
    }

    public BezierNode withC(int mask, double x, double y) {
        double ny2;
        double nx2;
        double ny1;
        double nx1;
        double ny0;
        double nx0;
        if ((mask & 1) != 0) {
            nx0 = x;
            ny0 = y;
        } else {
            nx0 = this.pointX;
            ny0 = this.pointY;
        }
        if ((mask & 2) != 0) {
            nx1 = x;
            ny1 = y;
        } else {
            nx1 = this.inX;
            ny1 = this.inY;
        }
        if ((mask & 4) != 0) {
            nx2 = x;
            ny2 = y;
        } else {
            nx2 = this.outX;
            ny2 = this.outY;
        }
        return new BezierNode(this.mask, this.equidistant, this.collinear, nx0, ny0, nx1, ny1, nx2, ny2);
    }

    public BezierNode withPoint(Point2D c0) {
        return new BezierNode(this.mask, this.equidistant, this.collinear, c0.getX(), c0.getY(), this.inX, this.inY, this.outX, this.outY);
    }

    public BezierNode withPoint(double x0, double y0) {
        return new BezierNode(this.mask, this.equidistant, this.collinear, x0, y0, this.inX, this.inY, this.outX, this.outY);
    }

    public BezierNode withPointAndTranslatedInOut(Point2D c0) {
        double x = c0.getX();
        double y = c0.getY();
        return new BezierNode(this.mask, this.equidistant, this.collinear, x, y, this.inX + x - this.pointX, this.inY + y - this.pointY, this.outX + x - this.pointX, this.outY + y - this.pointY);
    }

    public BezierNode withPointAndTranslatedInOut(javafx.geometry.Point2D c0) {
        double x = c0.getX();
        double y = c0.getY();
        return new BezierNode(this.mask, this.equidistant, this.collinear, x, y, this.inX + x - this.pointX, this.inY + y - this.pointY, this.outX + x - this.pointX, this.outY + y - this.pointY);
    }

    public BezierNode withIn(Point2D c1) {
        return new BezierNode(this.mask, this.equidistant, this.collinear, this.pointX, this.pointY, c1.getX(), c1.getY(), this.outX, this.outY);
    }

    public BezierNode withIn(double inX, double inY) {
        return new BezierNode(this.mask, this.equidistant, this.collinear, this.pointX, this.pointY, inX, inY, this.outX, this.outY);
    }

    public BezierNode withOut(Point2D c2) {
        return new BezierNode(this.mask, this.equidistant, this.collinear, this.pointX, this.pointY, this.inX, this.inY, c2.getX(), c2.getY());
    }

    public BezierNode withOut(double outX, double outY) {
        return new BezierNode(this.mask, this.equidistant, this.collinear, this.pointX, this.pointY, this.inX, this.inY, outX, outY);
    }

    public BezierNode withCollinear(boolean collinear) {
        return new BezierNode(this.mask, this.equidistant, collinear, this.pointX, this.pointY, this.inX, this.inY, this.outX, this.outY);
    }

    public BezierNode withEquidistant(boolean equidistant) {
        return new BezierNode(this.mask, equidistant, this.collinear, this.pointX, this.pointY, this.inX, this.inY, this.outX, this.outY);
    }

    public BezierNode withMask(int mask) {
        return mask == this.mask ? this : new BezierNode(mask, this.equidistant, this.collinear, this.pointX, this.pointY, this.inX, this.inY, this.outX, this.outY);
    }

    public BezierNode withMaskBitsSet(int mask) {
        int newMask = this.mask | mask;
        return newMask == this.mask ? this : new BezierNode(newMask, this.equidistant, this.collinear, this.pointX, this.pointY, this.inX, this.inY, this.outX, this.outY);
    }

    public BezierNode withMaskBitsClears(int mask) {
        int newMask = this.mask & ~mask;
        return newMask == this.mask ? this : new BezierNode(newMask, this.equidistant, this.collinear, this.pointX, this.pointY, this.inX, this.inY, this.outX, this.outY);
    }

    public String toString() {
        return "BezierNode{" + (this.collinear ? "isCollinear " : "") + (this.equidistant ? "isEquidistant " : "") + "mask=" + this.mask + ", " + this.pointX + "," + this.pointY + " " + this.inX + "," + this.inY + " " + this.outX + "," + this.outY + "}";
    }

    public BezierNode transform(AffineTransform transform) {
        Point2D p0 = transform.transform(new Point2D.Double(this.pointX, this.pointY), null);
        Point2D p1 = transform.transform(new Point2D.Double(this.inX, this.inY), null);
        Point2D p2 = transform.transform(new Point2D.Double(this.outX, this.outY), null);
        return new BezierNode(this.mask, this.equidistant, this.collinear, p0.getX(), p0.getY(), p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public BezierNode transform(Transform transform) {
        javafx.geometry.Point2D p0 = transform.transform(this.pointX, this.pointY);
        javafx.geometry.Point2D p1 = transform.transform(this.inX, this.inY);
        javafx.geometry.Point2D p2 = transform.transform(this.outX, this.outY);
        return new BezierNode(this.mask, this.equidistant, this.collinear, p0.getX(), p0.getY(), p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }
}

