/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.shape;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javafx.scene.shape.FillRule;
import org.jhotdraw8.geom.AwtShapes;
import org.jhotdraw8.geom.BoundingBoxBuilder;
import org.jhotdraw8.geom.CubicCurves;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.QuadCurves;
import org.jhotdraw8.geom.ReversePathIterator;
import org.jhotdraw8.geom.intersect.IntersectPathIteratorPoint;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionStatus;
import org.jhotdraw8.geom.shape.BezierNode;
import org.jhotdraw8.geom.shape.BezierPathBuilder;
import org.jhotdraw8.geom.shape.BezierPathIterator;
import org.jhotdraw8.geom.shape.PathMetrics;
import org.jhotdraw8.geom.shape.SimplePathMetrics;
import org.jhotdraw8.icollection.PrivateData;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jspecify.annotations.Nullable;

public class BezierPath
extends VectorList<BezierNode>
implements Shape {
    private transient @Nullable PathMetrics pathMetrics;
    private transient @Nullable Rectangle2D.Double bounds;
    private final int windingRule;
    private static final BezierPath EMPTY = new BezierPath(0);

    private BezierPath(int windingRule) {
        this.windingRule = windingRule;
    }

    public BezierPath(PrivateData privateData, int windingRule) {
        super(privateData);
        this.windingRule = windingRule;
    }

    public BezierPath(@Nullable Iterable<BezierNode> nodes) {
        this(nodes, 0);
    }

    public BezierPath(@Nullable Iterable<BezierNode> nodes, FillRule windingRule) {
        this(nodes, windingRule == FillRule.EVEN_ODD ? 0 : 1);
    }

    public BezierPath(@Nullable Iterable<BezierNode> nodes, int windingRule) {
        super(nodes);
        this.windingRule = windingRule;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(x, y, 0.0);
    }

    public boolean contains(double x, double y, double tolerance) {
        IntersectionResult isect = IntersectPathIteratorPoint.intersectPathIteratorPoint(this.getPathIterator(null), x, y, tolerance);
        IntersectionStatus status = isect.getStatus();
        return status == IntersectionStatus.NO_INTERSECTION_INSIDE || status == IntersectionStatus.INTERSECTION;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        if (this.bounds == null) {
            this.bounds = AwtShapes.buildPathIterator(new BoundingBoxBuilder(), this.getPathIterator(null)).buildRectangle2D();
        }
        return new Rectangle2D.Double(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new BezierPathIterator(this, at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean pathIntersects(double x, double y, double tolerance) {
        IntersectionResult isect = IntersectPathIteratorPoint.intersectPathIteratorPoint(this.getPathIterator(null), x, y, tolerance);
        return !isect.intersections().isEmpty();
    }

    public IntersectionResult pathIntersection(double x, double y, double tolerance) {
        return IntersectPathIteratorPoint.intersectPathIteratorPoint(this.getPathIterator(null), x, y, tolerance);
    }

    public BezierPath split(double x, double y, double tolerance) {
        IntersectionResult isect = IntersectPathIteratorPoint.intersectPathIteratorPoint(this.getPathIterator(null), x, y, tolerance);
        ImmutableList<IntersectionPoint> intersections = isect.intersections();
        VectorList[] result = new VectorList[]{this};
        if (intersections.size() == 1) {
            int segment = (int)((IntersectionPoint)intersections.getFirst()).argumentA();
            Point2D.Double p = (Point2D.Double)intersections.get(0);
            int prevSegment = (segment - 1 + this.size()) % this.size();
            BezierNode prev = this.get(prevSegment);
            BezierNode next = this.get(segment);
            double t = ((IntersectionPoint)intersections.getFirst()).argumentA() - (double)segment;
            boolean pc2 = prev.hasOut();
            boolean nc1 = next.hasIn();
            if (pc2) {
                if (nc1) {
                    BezierNode middle = new BezierNode(6, true, true, p.getX(), p.getY(), p.getX(), p.getY(), p.getX(), p.getY());
                    result[0] = result[0].add(segment, (Object)middle);
                    CubicCurves.splitCubicCurveTo(prev.pointX(), prev.pointY(), prev.outX(), prev.outY(), next.inX(), next.inY(), next.pointX(), next.pointY(), t, (x1, y1, x2, y2, x3, y3) -> {
                        result[0] = result[0].set(prevSegment, (Object)prev.withOx(x1).withOy(y1));
                        result[0] = result[0].set(segment, (Object)((BezierNode)result[0].get(segment)).withIx(x2).withIy(y2));
                    }, (x1, y1, x2, y2, x3, y3) -> {
                        result[0] = result[0].set(segment, (Object)((BezierNode)result[0].get(segment)).withOx(x1).withOy(y1));
                        result[0] = result[0].set(segment + 1, (Object)next.withIx(x2).withIy(y2));
                    });
                } else {
                    BezierNode middle = new BezierNode(4, true, true, p.getX(), p.getY(), p.getX(), p.getY(), p.getX(), p.getY());
                    prev.withCollinear(true);
                    result[0] = result[0].add(segment, (Object)middle);
                    QuadCurves.split(prev.pointX(), prev.pointY(), next.inX(), next.inY(), next.pointX(), next.pointY(), t, (x1, y1, x2, y2) -> {
                        result[0] = result[0].set(prevSegment, (Object)middle.withOx(x1).withOy(y1));
                        result[0] = result[0].set(segment, (Object)((BezierNode)result[0].get(segment)).withPx(x2).withPointY(y2));
                    }, (x1, y1, x2, y2) -> {
                        result[0] = result[0].set(segment, (Object)((BezierNode)result[0].get(segment)).withOx(x1).withOy(y1));
                    });
                }
            } else if (nc1) {
                BezierNode middle = new BezierNode(2, true, true, p.getX(), p.getY(), p.getX(), p.getY(), p.getX(), p.getY());
                result[0] = result[0].add(segment, (Object)middle);
                QuadCurves.split(prev.pointX(), prev.pointY(), next.inX(), next.inY(), next.pointX(), next.pointY(), t, (x1, y1, x2, y2) -> {
                    result[0] = result[0].set(segment, (Object)middle.withIx(x1).withIy(y1).withPx(x2).withPointY(y2));
                }, (x1, y1, x2, y2) -> {
                    result[0] = result[0].set(segment + 1, (Object)next.withIx(x1).withIy(y1).withCollinear(true));
                });
            } else {
                BezierNode middle = new BezierNode(1, true, true, p.getX(), p.getY(), p.getX(), p.getY(), p.getX(), p.getY());
                result[0] = result[0].add(segment, (Object)middle);
            }
        }
        return (BezierPath)result[0];
    }

    public BezierPath join(int segment, double tolerance) {
        double[] p;
        VectorList[] result = new VectorList[]{this};
        int prevSegment = (segment - 1 + this.size()) % this.size();
        int nextSegment = (segment + 1) % this.size();
        BezierNode prev = this.get(prevSegment);
        BezierNode middle = this.get(segment);
        BezierNode next = this.get(nextSegment);
        boolean pc2 = prev.hasOut();
        boolean mc2 = middle.hasOut();
        boolean mc1 = middle.hasIn();
        boolean nc1 = next.hasIn();
        if (!pc2 && mc1 && nc1) {
            double[] p2 = QuadCurves.merge(prev.pointX(), prev.pointY(), middle.inX(), middle.inY(), middle.pointX(), middle.pointY(), next.inX(), next.inY(), next.pointX(), next.pointY(), tolerance);
            if (p2 != null) {
                result[0] = result[0].set(nextSegment, (Object)next.withIx(p2[2]).withIy(p2[3]));
            }
        } else if (pc2 && mc2 && !nc1) {
            double[] p3 = QuadCurves.merge(prev.pointX(), prev.pointY(), prev.outX(), prev.outY(), middle.pointX(), middle.pointY(), middle.outX(), middle.outY(), next.pointX(), next.pointY(), tolerance);
            if (p3 != null) {
                result[0] = result[0].set(prevSegment, (Object)prev.withOx(p3[2]).withOy(p3[3]));
            }
        } else if (pc2 && mc1 && mc2 && (p = CubicCurves.merge(prev.pointX(), prev.pointY(), prev.outX(), prev.outY(), middle.inX(), middle.inY(), middle.pointX(), middle.pointY(), middle.outX(), middle.outY(), next.inX(), next.inY(), next.pointX(), next.pointY(), tolerance)) != null) {
            result[0] = result[0].set(prevSegment, (Object)prev.withOx(p[2]).withOy(p[3]));
            result[0] = result[0].set(nextSegment, (Object)next.withIx(p[4]).withIy(p[5]));
        }
        result[0] = result[0].removeAt(segment);
        return (BezierPath)result[0];
    }

    public @Nullable Point2D getOutgoingTangentPoint(int index) {
        BezierNode node = this.get(index);
        if (node.hasOut()) {
            return new Point2D.Double(node.outX(), node.outY());
        }
        return null;
    }

    public BezierPath setWindingRule(int newValue) {
        return this.windingRule == newValue ? this : new BezierPath((Iterable<BezierNode>)((Object)this), newValue);
    }

    public BezierPath setWindingRule(FillRule newValue) {
        return this.setWindingRule(newValue == FillRule.EVEN_ODD ? 0 : 1);
    }

    public BezierPath reverse() {
        return AwtShapes.buildPathIterator(new BezierPathBuilder(), new ReversePathIterator(this.getPathIterator(null), this.windingRule)).build();
    }

    public static BezierPath of() {
        return EMPTY;
    }

    public BezierPath empty() {
        return this.isEmpty() ? this : new BezierPath(this.windingRule);
    }

    protected VectorList<BezierNode> newInstance(PrivateData privateData) {
        return new BezierPath(privateData, this.windingRule);
    }

    public BezierPath add(BezierNode element) {
        return (BezierPath)super.add((Object)element);
    }

    public BezierPath add(int index, BezierNode element) {
        return (BezierPath)super.add(index, (Object)element);
    }

    public BezierPath addAll(Iterable<? extends BezierNode> c) {
        return (BezierPath)super.addAll(c);
    }

    public BezierPath addFirst(@Nullable BezierNode element) {
        return (BezierPath)super.addFirst((Object)element);
    }

    public BezierPath addLast(@Nullable BezierNode element) {
        return (BezierPath)super.addLast((Object)element);
    }

    public BezierPath addAll(int index, Iterable<? extends BezierNode> c) {
        return (BezierPath)super.addAll(index, c);
    }

    public BezierPath remove(BezierNode element) {
        return (BezierPath)super.remove((Object)element);
    }

    public BezierPath removeAt(int index) {
        return (BezierPath)super.removeAt(index);
    }

    public BezierPath removeFirst() {
        return (BezierPath)super.removeFirst();
    }

    public BezierPath removeLast() {
        return (BezierPath)super.removeLast();
    }

    public BezierPath retainAll(Iterable<?> c) {
        return (BezierPath)super.retainAll(c);
    }

    public BezierPath removeRange(int fromIndex, int toIndex) {
        return (BezierPath)super.removeRange(fromIndex, toIndex);
    }

    public BezierPath removeAll(Iterable<?> c) {
        return (BezierPath)super.removeAll(c);
    }

    public BezierPath set(int index, BezierNode element) {
        return (BezierPath)super.set(index, (Object)element);
    }

    public BezierNode get(int index) {
        return (BezierNode)super.get(index);
    }

    public PathMetrics getPathMetrics() {
        if (this.pathMetrics == null) {
            this.pathMetrics = new SimplePathMetrics(this);
        }
        return this.pathMetrics;
    }

    public BezierPath readOnlySubList(int fromIndex, int toIndex) {
        return (BezierPath)super.readOnlySubList(fromIndex, toIndex);
    }

    public int size() {
        return super.size();
    }

    public PointAndDerivative evalFirst() {
        BezierNode first = (BezierNode)this.getFirst();
        double y0 = first.pointY();
        double x0 = first.pointX();
        if (first.hasOut()) {
            return new PointAndDerivative(x0, y0, first.outX() - x0, first.outY() - y0);
        }
        if (this.size() < 2) {
            return new PointAndDerivative(first.pointX(), y0, 1.0, 0.0);
        }
        BezierNode second = this.get(1);
        if (second.hasIn()) {
            return new PointAndDerivative(x0, y0, second.inX() - x0, second.inY() - y0);
        }
        return new PointAndDerivative(x0, y0, second.pointX() - x0, second.pointY() - y0);
    }

    public PointAndDerivative evalLastInReverse() {
        BezierNode secondLast;
        BezierNode last = (BezierNode)this.getLast();
        BezierNode bezierNode = secondLast = this.size() > 1 ? this.get(this.size() - 2) : null;
        if (last.hasMask(16) && this.size() > 1) {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (i != 0 && !this.get(i).hasMask(8)) continue;
                secondLast = i == 0 ? last : this.get(i - 1);
                last = this.get(i);
                break;
            }
        }
        double y0 = last.pointY();
        double x0 = last.pointX();
        if (last.hasIn()) {
            return new PointAndDerivative(x0, y0, last.inX() - x0, last.inY() - y0);
        }
        if (secondLast == null) {
            return new PointAndDerivative(x0, y0, -1.0, 0.0);
        }
        if (secondLast.hasOut()) {
            return new PointAndDerivative(x0, y0, secondLast.outX() - x0, secondLast.outY() - y0);
        }
        return new PointAndDerivative(x0, y0, secondLast.pointX() - x0, secondLast.pointY() - y0);
    }

    public int getWindingRule() {
        return this.windingRule;
    }
}

