/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.shape;

import java.util.ArrayList;
import java.util.List;
import org.jhotdraw8.geom.AbstractPathBuilder;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.shape.BezierNode;
import org.jhotdraw8.geom.shape.BezierPath;
import org.jspecify.annotations.Nullable;

public class BezierPathBuilder
extends AbstractPathBuilder<BezierPath> {
    private final List<BezierNode> nodes = new ArrayList<BezierNode>();
    private int moveIndex;

    private void add(BezierNode newValue) {
        this.nodes.add(newValue);
    }

    @Override
    protected void doClosePath(double lastX, double lastY, double lastMoveToX, double lastMoveToY) {
        BezierNode last = this.getLast();
        if (last != null) {
            if (this.moveIndex != -1 && this.moveIndex != this.nodes.size() - 1) {
                BezierNode moveNode = this.nodes.get(this.moveIndex);
                if (Points.almostEqual(last.pointX(), last.pointY(), moveNode.pointX(), moveNode.pointY())) {
                    moveNode = moveNode.withMaskBitsSet(last.getMask() & 2).withIx(last.inX()).withIy(last.inY());
                    BezierNode moveNodeAsLineNode = moveNode.withMaskBitsClears(8);
                    moveNode = moveNode.withCollinear(moveNodeAsLineNode.computeIsCollinear()).withEquidistant(moveNodeAsLineNode.computeIsEquidistant());
                    this.nodes.set(this.moveIndex, moveNode);
                    this.nodes.removeLast();
                    last = this.getLast();
                }
            }
            last = new BezierNode(last.getMask() | 0x10, last.isEquidistant(), last.isCollinear(), last.pointX(), last.pointY(), last.inX(), last.inY(), last.outX(), last.outY());
            this.setLast(last);
        }
    }

    @Override
    protected void doCurveTo(double lastX, double lastY, double x1, double y1, double x2, double y2, double x, double y) {
        BezierNode last = this.getLast();
        if (last != null) {
            if ((last = new BezierNode(last.getMask() | 4, last.isEquidistant(), last.isCollinear(), last.pointX(), last.pointY(), last.inX(), last.inY(), x1, y1)).computeIsCollinear()) {
                last = last.withCollinear(true);
            }
            this.setLast(last);
        }
        this.add(new BezierNode(3, false, false, x, y, x2, y2, x - x2 + x, y - y2 + y));
    }

    @Override
    protected void doLineTo(double lastX, double lastY, double x, double y) {
        this.add(new BezierNode(1, false, false, x, y, x, y, x, y));
    }

    @Override
    protected void doMoveTo(double x, double y) {
        this.moveIndex = this.nodes.size();
        this.add(new BezierNode(9, false, false, x, y, x, y, x, y));
    }

    @Override
    protected void doQuadTo(double lastX, double lastY, double x1, double y1, double x, double y) {
        BezierNode last = this.getLast();
        if (last != null && last.hasIn()) {
            last = new BezierNode(last.getMask() | 4, false, false, last.pointX(), last.pointY(), last.inX(), last.inY(), x1, y1);
            last = last.withCollinear(last.computeIsCollinear());
            last = last.withEquidistant(last.computeIsEquidistant());
            this.setLast(last);
            this.add(new BezierNode(1, false, false, x, y, x1, y1, x1, y1));
            return;
        }
        this.add(new BezierNode(3, false, false, x, y, x1, y1, x1, y1));
    }

    @Override
    protected void doSmoothCurveTo(double lastX, double lastY, double x1, double y1, double x2, double y2, double x, double y) {
        BezierNode last = this.getLast();
        this.setLast(new BezierNode(last.getMask() | 4, true, true, last.pointX(), last.pointY(), last.inX(), last.inY(), x1, y1));
        this.add(new BezierNode(3, false, false, x, y, x2, y2, x2, y2));
    }

    @Override
    protected void doSmoothQuadTo(double lastX, double lastY, double x1, double y1, double x, double y) {
        BezierNode last = this.getLast();
        this.setLast(new BezierNode(last.getMask() | 4, true, true, last.pointX(), last.pointY(), last.inX(), last.inY(), x1, y1));
        this.add(new BezierNode(1, false, false, x, y, x1, y1, x1, y1));
    }

    private @Nullable BezierNode getLast() {
        return this.nodes.isEmpty() ? null : this.nodes.getLast();
    }

    private void setLast(BezierNode newValue) {
        this.nodes.set(this.nodes.size() - 1, newValue);
    }

    @Override
    public BezierPath build() {
        return new BezierPath(this.nodes);
    }
}

