/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.shape;

import java.util.DoubleSummaryStatistics;
import org.jhotdraw8.collection.primitive.ByteArrayList;
import org.jhotdraw8.collection.primitive.DoubleArrayList;
import org.jhotdraw8.collection.primitive.IntArrayList;
import org.jhotdraw8.geom.AbstractPathDataBuilder;
import org.jhotdraw8.geom.CubicCurves;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.QuadCurves;
import org.jhotdraw8.geom.shape.PathMetrics;
import org.jhotdraw8.geom.shape.SimplePathMetrics;

public class PathMetricsBuilder
extends AbstractPathDataBuilder<PathMetrics> {
    protected final DoubleArrayList lengths = new DoubleArrayList();
    private final DoubleSummaryStatistics acc = new DoubleSummaryStatistics();
    private final double epsilon;
    private static final byte SEG_MOVETO = 0;
    private static final byte SEG_LINETO = 1;
    private static final byte SEG_QUADTO = 2;
    private static final byte SEG_CUBICTO = 3;
    private static final byte SEG_CLOSE = 4;

    public PathMetricsBuilder() {
        this(0.125);
    }

    public PathMetricsBuilder(double epsilon) {
        this.epsilon = Math.abs(epsilon);
    }

    @Override
    protected void doClosePath(double lastX, double lastY, double lastMoveToX, double lastMoveToY) {
        if (!this.commands.isEmpty() && this.commands.getLastAsByte() != 0 && this.commands.getLastAsByte() != 4) {
            double length = Points.distance(lastMoveToX, lastMoveToY, lastX, this.getLastY());
            if (length > this.epsilon) {
                this.commands.addAsByte((byte)1);
                this.offsets.addAsInt(this.coords.size());
                this.coords.addAsDouble(lastMoveToX);
                this.coords.addAsDouble(lastMoveToY);
                this.acc.accept(length);
                this.lengths.addAsDouble(this.acc.getSum());
            }
            this.commands.addAsByte((byte)4);
            this.offsets.addAsInt(this.coords.size());
            this.lengths.addAsDouble(this.acc.getSum());
        }
    }

    @Override
    protected void doCurveTo(double lastX, double lastY, double x1, double y1, double x2, double y2, double x, double y) {
        this.temp[0] = lastX;
        this.temp[1] = lastY;
        this.temp[2] = x1;
        this.temp[3] = y1;
        this.temp[4] = x2;
        this.temp[5] = y2;
        this.temp[6] = x;
        this.temp[7] = y;
        double arcLength = CubicCurves.arcLength(this.temp, 0, this.epsilon);
        if (arcLength > this.epsilon) {
            this.commands.addAsByte((byte)3);
            this.offsets.addAsInt(this.coords.size());
            this.coords.addAsDouble(x1);
            this.coords.addAsDouble(y1);
            this.coords.addAsDouble(x2);
            this.coords.addAsDouble(y2);
            this.coords.addAsDouble(x);
            this.coords.addAsDouble(y);
            this.acc.accept(arcLength);
            this.lengths.addAsDouble(this.acc.getSum());
        }
    }

    @Override
    protected void doLineTo(double lastX, double lastY, double x, double y) {
        double length = Points.distance(lastX, lastY, x, y);
        if (length > this.epsilon) {
            this.commands.addAsByte((byte)1);
            this.offsets.addAsInt(this.coords.size());
            this.coords.addAsDouble(x);
            this.coords.addAsDouble(y);
            this.acc.accept(length);
            this.lengths.addAsDouble(this.acc.getSum());
        }
    }

    @Override
    protected void doMoveTo(double x, double y) {
        this.commands.addAsByte((byte)0);
        this.offsets.addAsInt(this.coords.size());
        this.coords.addAsDouble(x);
        this.coords.addAsDouble(y);
        this.lengths.addAsDouble(this.acc.getSum());
    }

    @Override
    protected void doQuadTo(double lastX, double lastY, double x1, double y1, double x, double y) {
        this.temp[0] = lastX;
        this.temp[1] = lastY;
        this.temp[2] = x1;
        this.temp[3] = y1;
        this.temp[4] = x;
        this.temp[5] = y;
        double arcLength = QuadCurves.arcLength(this.temp, 0, this.epsilon);
        if (arcLength > this.epsilon) {
            this.commands.addAsByte((byte)2);
            this.offsets.addAsInt(this.coords.size());
            this.coords.addAsDouble(x1);
            this.coords.addAsDouble(y1);
            this.coords.addAsDouble(x);
            this.coords.addAsDouble(y);
            this.acc.accept(arcLength);
            this.lengths.addAsDouble(this.acc.getSum());
        }
    }

    @Override
    public SimplePathMetrics build() {
        return new SimplePathMetrics(this.commands.toByteArray(), this.offsets.toIntArray(), this.coords.toDoubleArray(), this.lengths.toDoubleArray(), this.windingRule, this.epsilon);
    }

    public boolean isEmpty() {
        return this.commands.isEmpty();
    }

    protected ByteArrayList getCommands() {
        return this.commands;
    }

    protected IntArrayList getOffsets() {
        return this.offsets;
    }

    protected DoubleArrayList getCoords() {
        return this.coords;
    }
}

