/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.shape;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.geom.AbstractShape;
import org.jhotdraw8.geom.AwtShapes;
import org.jhotdraw8.geom.CubicCurves;
import org.jhotdraw8.geom.EmptyPathIterator;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.QuadCurves;
import org.jhotdraw8.geom.intersect.IntersectPathIteratorPoint;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionStatus;
import org.jhotdraw8.geom.shape.PathMetrics;
import org.jhotdraw8.geom.shape.PathMetricsBuilder;
import org.jspecify.annotations.Nullable;

public class SimplePathMetrics
extends AbstractShape
implements PathMetrics {
    private static final byte SEG_MOVETO = 0;
    private static final byte SEG_LINETO = 1;
    private static final byte SEG_QUADTO = 2;
    private static final byte SEG_CUBICTO = 3;
    private static final byte SEG_CLOSE = 4;
    private final byte[] commands;
    private final int[] offsets;
    private final double[] coords;
    private final double[] lengths;
    private final int windingRule;
    private final double epsilon;

    SimplePathMetrics(byte[] commands, int[] offsets, double[] coords, double[] lengths, int windingRule, double epsilon) {
        this.commands = commands;
        this.offsets = offsets;
        this.coords = coords;
        this.lengths = lengths;
        this.windingRule = windingRule;
        this.epsilon = epsilon;
    }

    public SimplePathMetrics(Shape shape) {
        this(shape.getPathIterator(null), 0.125);
    }

    public SimplePathMetrics(PathIterator pathIterator) {
        this(pathIterator, 0.125);
    }

    public SimplePathMetrics(PathIterator pathIterator, double epsilon) {
        PathMetricsBuilder b = AwtShapes.buildPathIterator(new PathMetricsBuilder(), pathIterator);
        this.commands = b.getCommands().toByteArray();
        this.offsets = b.getOffsets().toIntArray();
        this.coords = b.getCoords().toDoubleArray();
        this.lengths = b.lengths.toDoubleArray();
        this.windingRule = b.getWindingRule();
        this.epsilon = epsilon;
    }

    @Override
    public PointAndDerivative evalAtArcLength(double s) {
        int i;
        if (this.commands.length == 0) {
            return new PointAndDerivative(0.0, 0.0, 1.0, 0.0);
        }
        int search = Arrays.binarySearch(this.lengths, s = MathUtil.clamp((double)s, (double)0.0, (double)this.arcLength()));
        int n = i = search < 0 ? Math.min(this.commands.length - 1, ~search) : search;
        if (this.commands[i] == 4) {
            while (i > 0 && this.commands[i] == 4) {
                --i;
            }
        } else if (this.commands[i] == 0) {
            while (i < this.commands.length - 1 && this.commands[i] == 0) {
                ++i;
            }
        }
        int offset = this.offsets[i] - 2;
        double start = i == 0 ? 0.0 : this.lengths[i - 1];
        double segmentS = s - start;
        return switch (this.commands[i]) {
            case 4 -> new PointAndDerivative(0.0, 0.0, 1.0, 0.0);
            case 0 -> new PointAndDerivative(this.coords[offset + 2], this.coords[offset + 3], 1.0, 0.0);
            case 1 -> Lines.eval(this.coords, offset, Lines.invArcLength(this.coords, offset, segmentS));
            case 2 -> QuadCurves.eval(this.coords, offset, QuadCurves.invArcLength(this.coords, offset, segmentS, this.epsilon));
            case 3 -> CubicCurves.eval(this.coords, offset, CubicCurves.invArcLength(this.coords, offset, segmentS, this.epsilon));
            default -> throw new IllegalStateException("unexpected command=" + this.commands[i] + " at index=" + i);
        };
    }

    @Override
    public double arcLength() {
        return this.lengths.length == 0 ? 0.0 : this.lengths[this.lengths.length - 1];
    }

    /*
     * Exception decompiling
     */
    @Override
    public PathMetrics reverse() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.ClassCastException: class org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement cannot be cast to class org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement (org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement and org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement are in unnamed module of loader 'app')
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter$LValueSingleUsageCheckingRewriter.rewriteExpression(SwitchExpressionRewriter.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression.applyExpressionRewriter(LValueExpression.java:84)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ArrayLength.applyExpressionRewriter(ArrayLength.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ArithmeticOperation.applyExpressionRewriter(ArithmeticOperation.java:171)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredFor.rewriteExpressions(StructuredFor.java:194)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.rewriteBlockSwitches(SwitchExpressionRewriter.java:140)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.transform(SwitchExpressionRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.switchExpression(Op04StructuredStatement.java:101)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:909)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isEmpty() {
        return this.commands.length == 0;
    }

    @Override
    public Rectangle2D getBounds2D() {
        double minx = Double.POSITIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.coords.length; i += 2) {
            minx = Math.min(minx, this.coords[i]);
            maxx = Math.max(maxx, this.coords[i]);
            miny = Math.min(miny, this.coords[i + 1]);
            maxy = Math.max(maxy, this.coords[i + 1]);
        }
        return new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny);
    }

    @Override
    public boolean contains(double x, double y) {
        IntersectionResult result = IntersectPathIteratorPoint.intersectPathIteratorPoint(this.getPathIterator(null), x, y, 0.0);
        return result.getStatus() == IntersectionStatus.NO_INTERSECTION_INSIDE || result.getStatus() == IntersectionStatus.INTERSECTION;
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.getBounds2D().contains(x, y, w, h);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public PathIterator getSubPathIteratorAtArcLength(double s0, double s1, @Nullable AffineTransform tx) {
        boolean endsAtLastSegment;
        if (this.commands.length == 0) {
            return new EmptyPathIterator();
        }
        double totalArcLength = this.arcLength();
        s0 = MathUtil.clamp((double)s0, (double)0.0, (double)totalArcLength);
        s1 = MathUtil.clamp((double)s1, (double)s0, (double)totalArcLength);
        boolean startsAtFirstSegment = s0 == 0.0;
        boolean bl = endsAtLastSegment = s1 == totalArcLength;
        if (startsAtFirstSegment && endsAtLastSegment) {
            return new FullPathIterator(this, tx);
        }
        return new SubPathIterator(s0, s1, this, tx);
    }

    @Override
    public PathIterator getPathIterator(@Nullable AffineTransform tx) {
        return new FullPathIterator(this, tx);
    }

    public String toString() {
        return PathMetrics.pathMetricsToString(this);
    }

    private static class FullPathIterator
    implements PathIterator {
        private final SimplePathMetrics m;
        private final AffineTransform tt;
        int current = 0;

        public FullPathIterator(SimplePathMetrics m, @Nullable AffineTransform tt) {
            this.m = m;
            this.tt = tt == null ? AffineTransform.getTranslateInstance(0.0, 0.0) : tt;
        }

        @Override
        public int getWindingRule() {
            return this.m.windingRule;
        }

        @Override
        public boolean isDone() {
            return this.current >= this.m.commands.length;
        }

        @Override
        public void next() {
            if (!this.isDone()) {
                ++this.current;
            }
        }

        @Override
        public int currentSegment(float[] coords) {
            int offset = this.m.offsets[this.current];
            switch (this.m.commands[this.current]) {
                case 0: 
                case 1: {
                    this.tt.transform(this.m.coords, offset, coords, 0, 1);
                    break;
                }
                case 2: {
                    this.tt.transform(this.m.coords, offset, coords, 0, 2);
                    break;
                }
                case 3: {
                    this.tt.transform(this.m.coords, offset, coords, 0, 3);
                    break;
                }
            }
            return this.m.commands[this.current];
        }

        @Override
        public int currentSegment(double[] coords) {
            int offset = this.m.offsets[this.current];
            switch (this.m.commands[this.current]) {
                case 0: 
                case 1: {
                    this.tt.transform(this.m.coords, offset, coords, 0, 1);
                    break;
                }
                case 2: {
                    this.tt.transform(this.m.coords, offset, coords, 0, 2);
                    break;
                }
                case 3: {
                    this.tt.transform(this.m.coords, offset, coords, 0, 3);
                    break;
                }
            }
            return this.m.commands[this.current];
        }
    }

    private static class SubPathIterator
    implements PathIterator {
        private final double s0;
        private final double s1;
        private final SimplePathMetrics m;
        private final AffineTransform tt;
        int current = 0;
        int i0;
        int i1;
        final double[] splitCoords = new double[8];
        private final double[] segCoords = new double[6];
        private int segType;
        private final double epsilon = 0.125;
        private State state;
        private final boolean endsAtSegment;

        public SubPathIterator(double s0, double s1, SimplePathMetrics m, @Nullable AffineTransform tt) {
            boolean startsAtSegment;
            double totalArcLength = m.arcLength();
            this.s0 = s0 = Math.max(0.0, s0);
            this.s1 = s1 = Math.min(totalArcLength, Math.max(this.s0, s1));
            this.m = m;
            AffineTransform affineTransform = this.tt = tt == null ? AffineTransform.getTranslateInstance(0.0, 0.0) : tt;
            if (s0 == totalArcLength) {
                startsAtSegment = false;
                this.i0 = 1;
            } else {
                int search0 = s0 == 0.0 ? 0 : Arrays.binarySearch(m.lengths, s0);
                startsAtSegment = search0 >= 0;
                int n = this.i0 = search0 < 0 ? ~search0 : search0;
            }
            while (this.i0 < m.commands.length - 1 && m.lengths[this.i0] <= s0) {
                ++this.i0;
            }
            if (s1 == 0.0) {
                this.endsAtSegment = false;
                this.i1 = 1;
            } else {
                int search1 = s1 == totalArcLength ? m.commands.length - 1 : Arrays.binarySearch(m.lengths, s1);
                this.endsAtSegment = search1 >= 0;
                this.i1 = Math.max(1, search1 < 0 ? ~search1 : search1);
                while (this.i1 > 1 && m.lengths[this.i1 - 1] >= s1) {
                    --this.i1;
                }
            }
            this.segType = 0;
            this.current = this.i0;
            if (startsAtSegment) {
                System.arraycopy(m.coords, m.offsets[this.i0 - 1], this.segCoords, 0, 2);
                this.state = this.endsAtSegment || this.i0 < this.i1 ? State.INNER_SEGMENT : State.CLIP_LAST_SEGMENT;
            } else {
                int offset = m.offsets[this.i0];
                double ss0 = s0 - m.lengths[this.i0 - 1];
                double arcLength = m.lengths[this.i0] - m.lengths[this.i0 - 1];
                switch (m.commands[this.i0]) {
                    case 1: {
                        Lines.split(m.coords, offset - 2, ss0 / arcLength, null, 0, this.splitCoords, 0);
                        break;
                    }
                    case 2: {
                        QuadCurves.split(m.coords, offset - 2, QuadCurves.invArcLength(m.coords, offset - 2, ss0, arcLength, 0.125), null, 0, this.splitCoords, 0);
                        break;
                    }
                    case 3: {
                        CubicCurves.split(m.coords, offset - 2, CubicCurves.invArcLength(m.coords, offset - 2, ss0, arcLength, 0.125), null, 0, this.splitCoords, 0);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unexpected command=" + m.commands[this.i0] + " at index=" + this.i0));
                    }
                }
                System.arraycopy(this.splitCoords, 0, this.segCoords, 0, 2);
                if (this.i0 == this.i1 && !this.endsAtSegment) {
                    double ss1 = s1 - m.lengths[this.i0 - 1];
                    switch (m.commands[this.i0]) {
                        case 1: {
                            Lines.split(m.coords, offset - 2, ss1 / arcLength, this.splitCoords, 0, null, 0);
                            break;
                        }
                        case 2: {
                            QuadCurves.split(this.splitCoords, 0, QuadCurves.invArcLength(this.splitCoords, 0, ss1 - ss0, arcLength, 0.125), this.splitCoords, 0, null, 0);
                            break;
                        }
                        case 3: {
                            CubicCurves.split(this.splitCoords, 0, CubicCurves.invArcLength(this.splitCoords, 0, ss1 - ss0, arcLength, 0.125), this.splitCoords, 0, null, 0);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("unexpected command=" + m.commands[this.i0] + " at index=" + this.i0));
                        }
                    }
                    this.state = State.CLIP_FIRST_AND_LAST_SEGMENT;
                } else {
                    this.state = State.CLIP_FIRST_SEGMENT;
                }
            }
        }

        @Override
        public int getWindingRule() {
            return this.m.windingRule;
        }

        @Override
        public boolean isDone() {
            return this.state == State.DONE;
        }

        @Override
        public void next() {
            switch (this.state.ordinal()) {
                case 1: {
                    this.segType = this.m.commands[this.current];
                    switch (this.segType) {
                        case 1: {
                            System.arraycopy(this.splitCoords, 2, this.segCoords, 0, 2);
                            break;
                        }
                        case 2: {
                            System.arraycopy(this.splitCoords, 2, this.segCoords, 0, 4);
                            break;
                        }
                        case 3: {
                            System.arraycopy(this.splitCoords, 2, this.segCoords, 0, 6);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("unexpected command=" + this.segType));
                        }
                    }
                    ++this.current;
                    if (this.current < this.i1) {
                        this.state = State.INNER_SEGMENT;
                        break;
                    }
                    if (this.endsAtSegment) {
                        if (this.i1 == this.i0) {
                            this.state = State.FINAL_SEGMENT;
                            break;
                        }
                        this.state = State.INNER_SEGMENT;
                        break;
                    }
                    this.state = State.CLIP_LAST_SEGMENT;
                    break;
                }
                case 2: {
                    this.segType = this.m.commands[this.current];
                    int offset = this.m.offsets[this.current];
                    switch (this.m.commands[this.current]) {
                        case 0: 
                        case 1: {
                            this.tt.transform(this.m.coords, offset, this.segCoords, 0, 1);
                            break;
                        }
                        case 2: {
                            this.tt.transform(this.m.coords, offset, this.segCoords, 0, 2);
                            break;
                        }
                        case 3: {
                            this.tt.transform(this.m.coords, offset, this.segCoords, 0, 3);
                            break;
                        }
                    }
                    ++this.current;
                    if (this.endsAtSegment && this.current > this.i1) {
                        this.state = State.FINAL_SEGMENT;
                        break;
                    }
                    if (this.current < this.i1) break;
                    this.state = State.CLIP_LAST_SEGMENT;
                    break;
                }
                case 3: {
                    int offset = this.m.offsets[this.i1];
                    double startLength = this.i1 > 0 ? this.m.lengths[this.i1 - 1] : 0.0;
                    double s = this.s1 - startLength;
                    double arcLength = this.m.lengths[this.i1] - startLength;
                    this.segType = this.m.commands[this.i1];
                    switch (this.segType) {
                        case 1: {
                            Lines.split(this.m.coords, offset - 2, s / arcLength, this.splitCoords, 0, null, 0);
                            break;
                        }
                        case 2: {
                            QuadCurves.split(this.m.coords, offset - 2, QuadCurves.invArcLength(this.m.coords, offset - 2, s, arcLength, 0.125), this.splitCoords, 0, null, 0);
                            break;
                        }
                        case 3: {
                            CubicCurves.split(this.m.coords, offset - 2, CubicCurves.invArcLength(this.m.coords, offset - 2, s, arcLength, 0.125), this.splitCoords, 0, null, 0);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("unexpected command=" + this.segType));
                        }
                    }
                    System.arraycopy(this.splitCoords, 2, this.segCoords, 0, 6);
                    this.state = State.FINAL_SEGMENT;
                    break;
                }
                case 0: {
                    this.segType = this.m.commands[this.i1];
                    System.arraycopy(this.splitCoords, 2, this.segCoords, 0, 6);
                    this.state = State.FINAL_SEGMENT;
                    break;
                }
                default: {
                    this.state = State.DONE;
                }
            }
        }

        @Override
        public int currentSegment(double[] coords) {
            switch (this.segType) {
                case 0: 
                case 1: {
                    this.tt.transform(this.segCoords, 0, coords, 0, 1);
                    break;
                }
                case 2: {
                    this.tt.transform(this.segCoords, 0, coords, 0, 2);
                    break;
                }
                case 3: {
                    this.tt.transform(this.segCoords, 0, coords, 0, 3);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new NoSuchElementException();
                }
            }
            return this.segType;
        }

        @Override
        public int currentSegment(float[] coords) {
            switch (this.segType) {
                case 0: 
                case 1: {
                    this.tt.transform(this.segCoords, 0, coords, 0, 1);
                    break;
                }
                case 2: {
                    this.tt.transform(this.segCoords, 0, coords, 0, 2);
                    break;
                }
                case 3: {
                    this.tt.transform(this.segCoords, 0, coords, 0, 3);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new NoSuchElementException();
                }
            }
            return this.segType;
        }

        static enum State {
            CLIP_FIRST_AND_LAST_SEGMENT,
            CLIP_FIRST_SEGMENT,
            INNER_SEGMENT,
            CLIP_LAST_SEGMENT,
            FINAL_SEGMENT,
            DONE;

        }
    }
}

