/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.Arrays;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.collection.enumerator.AbstractIntEnumerator;
import org.jhotdraw8.graph.IndexedDirectedGraph;

public abstract class AbstractDirectedGraphBuilder
implements IndexedDirectedGraph {
    protected static final int ARROWS_NEXT_FIELD = 1;
    protected static final int ARROWS_NUM_FIELDS = 2;
    protected static final int ARROWS_VERTEX_FIELD = 0;
    protected static final int LASTARROW_COUNT_FIELD = 0;
    protected static final int LASTARROW_NUM_FIELDS = 2;
    protected static final int LASTARROW_POINTER_FIELD = 1;
    protected static final int SENTINEL = -1;
    private static final int TOMBSTONE = -2;
    private int pointerToLastDeletedArrow = -1;
    private int deletedArrowCount;
    protected int arrowCountIncludingDeletedArrows;
    private int[] nextArrowHeads;
    private int[] nextLastArrow;
    private int vertexCount;
    private boolean ordered = true;

    public AbstractDirectedGraphBuilder() {
        this(16, 16);
    }

    public AbstractDirectedGraphBuilder(int vertexCapacity, int arrowCapacity) {
        if (vertexCapacity < 0) {
            throw new IllegalArgumentException("vertexCapacity: " + vertexCapacity);
        }
        if (arrowCapacity < 0) {
            throw new IllegalArgumentException("arrowCapacity: " + arrowCapacity);
        }
        this.nextArrowHeads = new int[arrowCapacity * 2];
        this.nextLastArrow = new int[vertexCapacity * 2];
    }

    protected int buildAddArrow(int a, int b) {
        if (this.nextArrowHeads.length <= this.arrowCountIncludingDeletedArrows * 2) {
            this.nextArrowHeads = Arrays.copyOf(this.nextArrowHeads, Math.max(1, this.arrowCountIncludingDeletedArrows) * 2 * 2);
        }
        return this.doAddArrow(a, b, this.nextArrowHeads, this.nextLastArrow);
    }

    protected int doAddArrow(int a, int b, int @NonNull [] arrowHeads, int @NonNull [] lastArrow) {
        int newArrowPointer;
        int lastArrowPointer;
        int arrowCountOfA = this.lastArrow_getCount(lastArrow, a);
        int n = lastArrowPointer = arrowCountOfA == 0 ? -1 : lastArrow[a * 2 + 1];
        if (this.deletedArrowCount > 0) {
            newArrowPointer = this.pointerToLastDeletedArrow;
            this.pointerToLastDeletedArrow = this.arrowHead_getNext(arrowHeads, this.pointerToLastDeletedArrow);
            --this.deletedArrowCount;
        } else {
            newArrowPointer = this.arrowCountIncludingDeletedArrows++;
        }
        this.arrowHead_setNext(arrowHeads, newArrowPointer, lastArrowPointer);
        this.arrowHead_setVertex(arrowHeads, newArrowPointer, b);
        this.lastArrow_setLast(lastArrow, a, newArrowPointer);
        this.lastArrow_setCount(lastArrow, a, arrowCountOfA + 1);
        return newArrowPointer;
    }

    private void arrowHead_setVertex(int[] arrowHeads, int pointerToArrow, int vidx) {
        arrowHeads[pointerToArrow * 2 + 0] = vidx;
    }

    private int arrowHead_getVertex(int[] arrowHeads, int pointerToArrow) {
        return arrowHeads[pointerToArrow * 2 + 0];
    }

    private int lastArrow_getCount(int[] lastArrow, int vidx) {
        return lastArrow[vidx * 2 + 0];
    }

    private void lastArrow_setCount(int[] lastArrow, int vidx, int count) {
        lastArrow[vidx * 2 + 0] = count;
    }

    protected void buildAddVertex() {
        ++this.vertexCount;
        if (this.nextLastArrow.length < this.vertexCount * 2) {
            this.nextLastArrow = Arrays.copyOf(this.nextLastArrow, this.vertexCount * 2 * 2);
        }
    }

    @Override
    public int getArrowCount() {
        return this.arrowCountIncludingDeletedArrows - this.deletedArrowCount;
    }

    protected int buildRemoveArrowAt(int a, int i) {
        return this.buildRemoveArrowAt(a, i, this.nextLastArrow, this.nextArrowHeads, this.arrowCountIncludingDeletedArrows);
    }

    protected int buildRemoveArrowAt(int vidx, int i, int @NonNull [] lastArrow, int @NonNull [] arrowHeads, int arrowCount) {
        if (vidx < 0 || vidx >= this.getVertexCount()) {
            throw new IllegalArgumentException("vidx:" + i);
        }
        int nextCount = this.getNextCount(vidx);
        if (i < 0 || i >= nextCount) {
            throw new IllegalArgumentException("i:" + i);
        }
        int prevArrowPtr = -1;
        int arrowPtr = this.lastArrow_getLast(lastArrow, vidx);
        for (int j = nextCount - 1; j > i; --j) {
            prevArrowPtr = arrowPtr;
            arrowPtr = this.arrowHead_getNext(arrowHeads, arrowPtr);
        }
        this.arrowHead_setVertex(arrowHeads, arrowPtr, -2);
        if (prevArrowPtr == -1) {
            this.lastArrow_setLast(lastArrow, vidx, this.arrowHead_getNext(arrowHeads, arrowPtr));
        } else {
            this.arrowHead_setNext(arrowHeads, prevArrowPtr, this.arrowHead_getNext(arrowHeads, arrowPtr));
        }
        this.lastArrow_setCount(lastArrow, vidx, this.lastArrow_getCount(lastArrow, vidx) - 1);
        ++this.deletedArrowCount;
        this.arrowHead_setNext(arrowHeads, arrowPtr, this.pointerToLastDeletedArrow);
        this.pointerToLastDeletedArrow = arrowPtr;
        return arrowPtr;
    }

    protected void buildRemoveVertex(int vidx) {
        for (int i = this.getNextCount(vidx) - 1; i >= 0; --i) {
            this.buildRemoveArrowAt(vidx, i);
        }
        this.buildRemoveVertexAfterArrowsHaveBeenRemoved(vidx);
    }

    protected void buildRemoveVertexAfterArrowsHaveBeenRemoved(int vidx) {
        if (vidx < this.vertexCount - 1) {
            System.arraycopy(this.nextLastArrow, (vidx + 1) * 2, this.nextLastArrow, vidx * 2, (this.vertexCount - vidx - 1) * 2);
        }
        this.lastArrow_setLast(this.nextLastArrow, this.vertexCount - 1, 0);
        this.lastArrow_setCount(this.nextLastArrow, this.vertexCount - 1, 0);
        for (int arrowPtr = 0; arrowPtr < this.arrowCountIncludingDeletedArrows; ++arrowPtr) {
            int uidx = this.arrowHead_getVertex(this.nextArrowHeads, arrowPtr);
            if (uidx <= vidx) continue;
            this.arrowHead_setVertex(this.nextArrowHeads, arrowPtr, uidx - 1);
        }
        --this.vertexCount;
    }

    protected void buildInsertVertexAt(int vidx) {
        if (this.nextLastArrow.length < (this.vertexCount + 1) * 2) {
            this.nextLastArrow = Arrays.copyOf(this.nextLastArrow, (this.vertexCount + 1) * 2 * 2);
        }
        if (vidx < this.vertexCount) {
            System.arraycopy(this.nextLastArrow, vidx * 2, this.nextLastArrow, (vidx + 1) * 2, (this.vertexCount - vidx) * 2);
        }
        this.lastArrow_setLast(this.nextLastArrow, vidx, 0);
        this.lastArrow_setCount(this.nextLastArrow, vidx, 0);
        for (int arrowPtr = 0; arrowPtr < this.arrowCountIncludingDeletedArrows; ++arrowPtr) {
            int uidx = this.arrowHead_getVertex(this.nextArrowHeads, arrowPtr);
            if (uidx < vidx) continue;
            this.arrowHead_setVertex(this.nextArrowHeads, arrowPtr, uidx + 1);
        }
        ++this.vertexCount;
    }

    private void arrowHead_setNext(int[] arrowHeads, int arrowPointer, int pointerToNextArrow) {
        arrowHeads[arrowPointer * 2 + 1] = pointerToNextArrow;
    }

    private void lastArrow_setLast(int[] lastArrow, int vidx, int arrowPointer) {
        lastArrow[vidx * 2 + 1] = arrowPointer;
    }

    private int lastArrow_getLast(int[] lastArrow, int vidx) {
        return lastArrow[vidx * 2 + 1];
    }

    private int arrowHead_getNext(int[] arrowHeads, int arrowPointer) {
        return arrowHeads[arrowPointer * 2 + 1];
    }

    protected int getNextArrowIndex(int vi, int i) {
        return this.getArrowIndex(vi, i, this.nextLastArrow, this.nextArrowHeads);
    }

    protected int getArrowIndex(int vi, int i, int @NonNull [] lastArrow, int @NonNull [] arrowHeads) {
        int arrowPointer = this.lastArrow_getLast(lastArrow, vi);
        int nextCount = this.lastArrow_getCount(lastArrow, vi);
        for (int j = nextCount - 1; j > i; --j) {
            arrowPointer = this.arrowHead_getNext(arrowHeads, arrowPointer);
        }
        return arrowPointer;
    }

    @Override
    public int getNextAsInt(int v, int i) {
        int arrowId = this.getNextArrowIndex(v, i);
        return this.arrowHead_getVertex(this.nextArrowHeads, arrowId);
    }

    @Override
    public int getNextCount(int v) {
        return this.lastArrow_getCount(this.nextLastArrow, v);
    }

    @Override
    public int getVertexCount() {
        return this.vertexCount;
    }

    public void clear() {
        this.arrowCountIncludingDeletedArrows = 0;
        this.vertexCount = 0;
        this.deletedArrowCount = 0;
        this.pointerToLastDeletedArrow = -1;
        Arrays.fill(this.nextArrowHeads, 0);
        Arrays.fill(this.nextLastArrow, 0);
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Enumerator.OfInt nextVerticesEnumerator(int v) {
        if (this.ordered) {
            return this.getNextVerticesOrdered(v);
        }
        return this.getNextVerticesUnordered(v);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Enumerator.OfInt getNextVerticesUnordered(int vidx) {
        class MySpliterator
        extends AbstractIntEnumerator {
            private int arrowPtr;

            public MySpliterator(int vidx, int lo, int hi) {
                super((long)(hi - lo), 336);
                this.arrowPtr = AbstractDirectedGraphBuilder.this.lastArrow_getCount(AbstractDirectedGraphBuilder.this.nextLastArrow, vidx) == 0 ? -1 : AbstractDirectedGraphBuilder.this.lastArrow_getLast(AbstractDirectedGraphBuilder.this.nextLastArrow, vidx);
            }

            public boolean moveNext() {
                if (this.arrowPtr != -1) {
                    this.current = AbstractDirectedGraphBuilder.this.arrowHead_getVertex(AbstractDirectedGraphBuilder.this.nextArrowHeads, this.arrowPtr);
                    this.arrowPtr = AbstractDirectedGraphBuilder.this.arrowHead_getNext(AbstractDirectedGraphBuilder.this.nextArrowHeads, this.arrowPtr);
                    return true;
                }
                return false;
            }
        }
        return new MySpliterator(vidx, 0, this.getNextCount(vidx));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Enumerator.OfInt getNextVerticesOrdered(int vidx) {
        class MySpliterator
        extends AbstractIntEnumerator {
            private int index;
            private final int limit;
            private final int vidx;
            private final int @NonNull [] arrows;

            public MySpliterator(int vidx, int lo, int hi) {
                super((long)(hi - lo), 16720);
                this.limit = hi;
                this.index = lo;
                this.vidx = vidx;
                int nextCount = AbstractDirectedGraphBuilder.this.getNextCount(vidx);
                if (nextCount > 0) {
                    this.arrows = new int[nextCount];
                    int arrowPtr = AbstractDirectedGraphBuilder.this.lastArrow_getLast(AbstractDirectedGraphBuilder.this.nextLastArrow, vidx);
                    this.arrows[nextCount - 1] = AbstractDirectedGraphBuilder.this.arrowHead_getVertex(AbstractDirectedGraphBuilder.this.nextArrowHeads, arrowPtr);
                    for (int j = nextCount - 1; j > lo; --j) {
                        arrowPtr = AbstractDirectedGraphBuilder.this.arrowHead_getNext(AbstractDirectedGraphBuilder.this.nextArrowHeads, arrowPtr);
                        this.arrows[j - 1] = AbstractDirectedGraphBuilder.this.arrowHead_getVertex(AbstractDirectedGraphBuilder.this.nextArrowHeads, arrowPtr);
                    }
                } else {
                    this.arrows = new int[0];
                }
            }

            private MySpliterator(int vidx, int lo, @NonNull int hi, int[] arrows) {
                super((long)(hi - lo), 16720);
                this.vidx = vidx;
                this.index = lo;
                this.limit = hi;
                this.arrows = arrows;
            }

            public boolean moveNext() {
                if (this.index < this.limit) {
                    int i = this.index++;
                    this.current = this.arrows[i];
                    return true;
                }
                return false;
            }

            public @Nullable MySpliterator trySplit() {
                MySpliterator mySpliterator;
                int lo = this.index;
                int hi = this.limit;
                int mid = lo + hi >>> 1;
                if (lo >= mid) {
                    mySpliterator = null;
                } else {
                    this.index = mid;
                    MySpliterator mySpliterator2 = new MySpliterator(this.vidx, lo, this.index, this.arrows);
                    mySpliterator = mySpliterator2;
                }
                return mySpliterator;
            }
        }
        return new MySpliterator(vidx, 0, this.getNextCount(vidx));
    }
}

