/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.Objects;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

public class Arc<V, A> {
    private final @NonNull V start;
    private final @NonNull V end;
    private final @Nullable A data;

    public Arc(@NonNull V start, @NonNull V end, @Nullable A data) {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(end, "end");
        this.start = start;
        this.end = end;
        this.data = data;
    }

    public @Nullable A getArrow() {
        return this.data;
    }

    public @NonNull V getEnd() {
        return this.end;
    }

    public @NonNull V getStart() {
        return this.start;
    }

    public @NonNull String toString() {
        return "Arc{" + String.valueOf(this.start) + "->" + String.valueOf(this.end) + ", " + String.valueOf(this.data) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Arc)) {
            return false;
        }
        Arc arc = (Arc)o;
        return Objects.equals(this.start, arc.start) && this.end.equals(arc.end) && Objects.equals(this.data, arc.data);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.data);
    }
}

