/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.graph.AttributedIndexedDirectedGraph;
import org.jhotdraw8.graph.IndexedBidiGraph;

public interface AttributedIndexedBidiGraph<V, A>
extends IndexedBidiGraph,
AttributedIndexedDirectedGraph<V, A> {
    public A getPrevArrow(int var1, int var2);

    default public @NonNull Collection<Map.Entry<Integer, A>> getPrevIntEntries(final int vertexIndex) {
        return new AbstractCollection<Map.Entry<Integer, A>>(){

            @Override
            public @NonNull Iterator<Map.Entry<Integer, A>> iterator() {
                class PrevVertexAndArrowIterator
                implements Iterator<Map.Entry<Integer, A>> {
                    private int index;
                    private final int vertex;
                    private final int prevCount;

                    public PrevVertexAndArrowIterator(int vertex) {
                        this.vertex = vertex;
                        this.prevCount = AttributedIndexedBidiGraph.this.getPrevCount(vertex);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < this.prevCount;
                    }

                    @Override
                    public  @NonNull Map.Entry<Integer, A> next() {
                        int i = this.index++;
                        return new AbstractMap.SimpleEntry(AttributedIndexedBidiGraph.this.getPrevAsInt(this.vertex, i), AttributedIndexedBidiGraph.this.getPrevArrow(this.vertex, i));
                    }
                }
                return new PrevVertexAndArrowIterator(vertexIndex);
            }

            @Override
            public int size() {
                return AttributedIndexedBidiGraph.this.getPrevCount(vertexIndex);
            }
        };
    }
}

