/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.Arrays;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.LongConsumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.collection.enumerator.AbstractIntEnumerator;
import org.jhotdraw8.collection.primitive.IntArrayDeque;
import org.jhotdraw8.collection.util.ListHelper;
import org.jhotdraw8.graph.GraphChunk;
import org.jhotdraw8.graph.IntAttributedIndexedBidiGraph;
import org.jhotdraw8.graph.MutableIndexedBidiGraph;
import org.jhotdraw8.graph.SingleArrayCsrGraphChunk;
import org.jhotdraw8.graph.algo.AddToIntSet;
import org.jhotdraw8.graph.precondition.Preconditions;

public class ChunkedMutableIndexedBidiGraph
implements MutableIndexedBidiGraph,
IntAttributedIndexedBidiGraph {
    private final int chunkSize;
    private final int chunkShift;
    private final int initialArityCapacity;
    int vertexCount = 0;
    int arrowCount = 0;
    private @NonNull GraphChunk @NonNull [] nextChunks = new GraphChunk[0];
    private @NonNull GraphChunk @NonNull [] prevChunks = new GraphChunk[0];
    private @NonNull BiFunction<Integer, Integer, GraphChunk> chunkFactory = SingleArrayCsrGraphChunk::new;

    public ChunkedMutableIndexedBidiGraph() {
        this(256, 4);
    }

    public ChunkedMutableIndexedBidiGraph(int chunkSize, int initialArityCapacity) {
        this(chunkSize, initialArityCapacity, SingleArrayCsrGraphChunk::new);
    }

    public ChunkedMutableIndexedBidiGraph(int chunkSize, int initialArityCapacity, @NonNull BiFunction<Integer, Integer, GraphChunk> chunkFactory) {
        if (Integer.bitCount(chunkSize) != 1) {
            throw new IllegalArgumentException("chunkSize=" + chunkSize + " is not a power of 2");
        }
        this.chunkSize = chunkSize;
        this.initialArityCapacity = chunkSize * initialArityCapacity;
        this.chunkShift = Integer.numberOfTrailingZeros(chunkSize);
        this.chunkFactory = chunkFactory;
    }

    @Override
    public void addArrowAsInt(int v, int u) {
        this.addArrowAsInt(v, u, 0);
    }

    @Override
    public void addArrowAsInt(int v, int u, int data) {
        this.addArrowIfAbsentAsInt(v, u, data);
    }

    public boolean addArrowIfAbsentAsInt(int v, int u, int data) {
        GraphChunk uChunk = this.getPrevChunk(u);
        boolean added = uChunk.tryAddArrow(u, v, data, false);
        if (added) {
            GraphChunk vChunk = this.getNextChunk(v);
            vChunk.tryAddArrow(v, u, data, false);
            ++this.arrowCount;
        }
        return added;
    }

    public boolean addOrUpdateArrowAsInt(int v, int u, int data) {
        GraphChunk uChunk = this.getPrevChunk(u);
        boolean added = uChunk.tryAddArrow(u, v, data, true);
        GraphChunk vChunk = this.getNextChunk(v);
        vChunk.tryAddArrow(v, u, data, true);
        if (added) {
            ++this.arrowCount;
        }
        return added;
    }

    @Override
    public void addVertexAsInt() {
        this.grow(this.vertexCount + 1);
        ++this.vertexCount;
    }

    @Override
    public void addVertexAsInt(int v) {
        if (v < this.vertexCount) {
            throw new UnsupportedOperationException();
        }
        this.grow(v + 1);
        this.vertexCount = v + 1;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Enumerator.OfInt searchPrevVertices(int vidx, boolean dfs, @NonNull AddToIntSet visited) {
        return new SearchVertexSpliterator(vidx, this.prevChunks, dfs, visited);
    }

    public  @NonNull Spliterator.OfLong searchPrevVertexData(int v, boolean dfs, @NonNull AddToIntSet visited) {
        return new SearchVertexDataSpliterator(v, this.prevChunks, dfs, visited);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Enumerator.OfInt searchNextVertices(int v, boolean dfs, @NonNull AddToIntSet visited) {
        return new SearchVertexSpliterator(v, this.nextChunks, dfs, visited);
    }

    public  @NonNull Spliterator.OfLong searchNextVertexData(int v, boolean dfs, @NonNull AddToIntSet visited) {
        return new SearchVertexDataSpliterator(v, this.nextChunks, dfs, visited);
    }

    public void clear() {
        Arrays.fill(this.nextChunks, null);
        Arrays.fill(this.prevChunks, null);
        this.arrowCount = 0;
        this.vertexCount = 0;
    }

    @Override
    public int findIndexOfNextAsInt(int v, int u) {
        GraphChunk chunk = this.getNextChunk(v);
        return chunk.indexOf(v, u);
    }

    @Override
    public int findIndexOfPrevAsInt(int v, int u) {
        GraphChunk chunk = this.getPrevChunk(v);
        return chunk.indexOf(v, u);
    }

    @Override
    public int getArrowCount() {
        return this.arrowCount;
    }

    @Override
    public int getNextArrowAsInt(int v, int i) {
        return this.getNextChunk(v).getArrow(v, i);
    }

    @Override
    public int getNextAsInt(int v, int i) {
        return this.getNextChunk(v).getSibling(v, i);
    }

    private @NonNull GraphChunk getNextChunk(int v) {
        return this.getOrCreateChunk(this.nextChunks, v);
    }

    @Override
    public int getNextCount(int v) {
        return this.getNextChunk(v).getSiblingCount(v);
    }

    @NonNull GraphChunk getOrCreateChunk(GraphChunk[] chunks, int v) {
        @NonNull GraphChunk chunk = chunks[v >>> this.chunkShift];
        if (chunk == null) {
            chunks[v >>> this.chunkShift] = chunk = this.chunkFactory.apply(this.chunkSize, this.initialArityCapacity);
        }
        return chunk;
    }

    @Override
    public int getPrevArrowAsInt(int v, int i) {
        return this.getPrevChunk(v).getArrow(v, i);
    }

    @Override
    public int getPrevAsInt(int v, int k) {
        return this.getPrevChunk(v).getSibling(v, k);
    }

    private @NonNull GraphChunk getPrevChunk(int v) {
        return this.getOrCreateChunk(this.prevChunks, v);
    }

    @Override
    public int getPrevCount(int v) {
        return this.getPrevChunk(v).getSiblingCount(v);
    }

    @Override
    public int getVertexDataAsInt(int v) {
        return this.getNextChunk(v).getVertexData(v);
    }

    @Override
    public int getVertexCount() {
        return this.vertexCount;
    }

    private void grow(int capacity) {
        int chunkedCapacity = capacity + this.chunkSize - 1 >>> this.chunkShift;
        this.nextChunks = (GraphChunk[])ListHelper.grow((int)chunkedCapacity, (int)1, (Object[])this.nextChunks);
        this.prevChunks = (GraphChunk[])ListHelper.grow((int)chunkedCapacity, (int)1, (Object[])this.prevChunks);
    }

    @Override
    public void removeAllNextAsInt(int v) {
        Preconditions.checkIndex(v, this.vertexCount);
        GraphChunk chunk = this.getNextChunk(v);
        int from = chunk.getSiblingsFromOffset(v);
        int siblingCount = chunk.getSiblingCount(v);
        int to = siblingCount + from;
        int[] a = chunk.getSiblingsArray();
        int[] next = new int[to - from];
        System.arraycopy(a, from, next, 0, next.length);
        for (int i = next.length - 1; i >= 0; --i) {
            int u = next[i];
            GraphChunk prevChunk = this.getPrevChunk(u);
            prevChunk.tryRemoveArrow(u, v);
        }
        chunk.removeAllArrows(v);
        this.arrowCount -= siblingCount;
    }

    @Override
    public void removeAllPrevAsInt(int v) {
        Preconditions.checkIndex(v, this.vertexCount);
        GraphChunk chunk = this.getPrevChunk(v);
        int from = chunk.getSiblingsFromOffset(v);
        int[] a = chunk.getSiblingsArray();
        int siblingCount = chunk.getSiblingCount(v);
        int to = siblingCount + from;
        int[] next = new int[to - from];
        System.arraycopy(a, from, next, 0, next.length);
        for (int i = next.length - 1; i >= 0; --i) {
            int u = next[i];
            GraphChunk nextChunk = this.getNextChunk(u);
            nextChunk.tryRemoveArrow(u, v);
        }
        chunk.removeAllArrows(v);
        this.arrowCount -= siblingCount;
    }

    @Override
    public void removeNextAsInt(int v, int index) {
        Preconditions.checkIndex(index, this.getNextCount(v));
        int u = this.getNextChunk(v).removeArrowAt(v, index);
        this.getPrevChunk(u).tryRemoveArrow(u, v);
        --this.arrowCount;
    }

    @Override
    public void removePrevAsInt(int v, int index) {
        Preconditions.checkIndex(index, this.getPrevCount(v));
        int u = this.getPrevChunk(v).removeArrowAt(v, index);
        this.getNextChunk(u).tryRemoveArrow(u, v);
        --this.arrowCount;
    }

    @Override
    public void removeVertexAsInt(int v) {
        throw new UnsupportedOperationException();
    }

    public void setVertexDataAsInt(int v, int data) {
        Preconditions.checkIndex(v, this.vertexCount);
        this.getNextChunk(v).setVertexData(v, data);
        this.getPrevChunk(v).setVertexData(v, data);
    }

    public @NonNull BiFunction<Integer, Integer, GraphChunk> getChunkFactory() {
        return this.chunkFactory;
    }

    public void setChunkFactory(@NonNull BiFunction<Integer, Integer, GraphChunk> chunkFactory) {
        this.chunkFactory = chunkFactory;
    }

    private class SearchVertexSpliterator
    extends AbstractIntEnumerator {
        private final GraphChunk[] chunks;
        private final @NonNull IntArrayDeque deque;
        private final @NonNull AddToIntSet visited;
        private final boolean dfs;

        protected SearchVertexSpliterator(int root, GraphChunk[] chunks, @NonNull boolean dfs, AddToIntSet visited) {
            super(Long.MAX_VALUE, 273);
            this.deque = new IntArrayDeque();
            this.chunks = chunks;
            this.visited = visited;
            this.dfs = dfs;
            if (visited.addAsInt(root)) {
                this.deque.addLastAsInt(root);
            }
        }

        public boolean moveNext() {
            if (this.deque.isEmpty()) {
                return false;
            }
            int v = this.dfs ? this.deque.removeLastAsInt() : this.deque.removeFirstAsInt();
            GraphChunk chunk = ChunkedMutableIndexedBidiGraph.this.getOrCreateChunk(this.chunks, v);
            this.current = v;
            int from = chunk.getSiblingsFromOffset(v);
            int to = chunk.getSiblingCount(v) + from;
            int[] a = chunk.getSiblingsArray();
            for (int i = from; i < to; ++i) {
                int u = a[i];
                if (!this.visited.addAsInt(u)) continue;
                this.deque.addLastAsInt(u);
            }
            return true;
        }
    }

    private class SearchVertexDataSpliterator
    extends Spliterators.AbstractLongSpliterator {
        private final GraphChunk[] chunks;
        private final @NonNull IntArrayDeque deque;
        private final @NonNull AddToIntSet visited;
        private final boolean dfs;

        protected SearchVertexDataSpliterator(int root, GraphChunk[] chunks, @NonNull boolean dfs, AddToIntSet visited) {
            super(Long.MAX_VALUE, 273);
            this.deque = new IntArrayDeque();
            this.chunks = chunks;
            this.visited = visited;
            this.dfs = dfs;
            if (visited.addAsInt(root)) {
                this.deque.addFirstAsInt(root);
            }
        }

        @Override
        public boolean tryAdvance(@NonNull LongConsumer action) {
            if (this.deque.isEmpty()) {
                return false;
            }
            int v = this.dfs ? this.deque.removeLastAsInt() : this.deque.removeFirstAsInt();
            GraphChunk chunk = ChunkedMutableIndexedBidiGraph.this.getOrCreateChunk(this.chunks, v);
            long current = (long)chunk.getVertexData(v) << 32 | (long)v & 0xFFFFFFFFL;
            int from = chunk.getSiblingsFromOffset(v);
            int to = chunk.getSiblingCount(v) + from;
            int[] a = chunk.getSiblingsArray();
            for (int i = from; i < to; ++i) {
                int u = a[i];
                if (!this.visited.addAsInt(u)) continue;
                this.deque.addLastAsInt(u);
            }
            action.accept(current);
            return true;
        }
    }
}

