/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.DirectedGraph;
import org.jhotdraw8.graph.MutableDirectedGraph;
import org.jhotdraw8.graph.SimpleMutableDirectedGraph;

public class DirectedGraphBuilder {
    public <V, A> @NonNull MutableDirectedGraph<V, A> inverseOfDirectedGraph(@NonNull DirectedGraph<V, A> graph) {
        int arrowCount = graph.getArrowCount();
        SimpleMutableDirectedGraph b = new SimpleMutableDirectedGraph(graph.getVertexCount(), arrowCount);
        for (Object v : graph.getVertices()) {
            b.addVertex(v);
        }
        for (Object v : graph.getVertices()) {
            int m = graph.getNextCount(v);
            for (int j = 0; j < m; ++j) {
                b.addArrow(graph.getNext(v, j), v, graph.getNextArrow(v, j));
            }
        }
        return b;
    }

    public <V, A> @NonNull MutableDirectedGraph<V, A> subsetOfDirectedGraph(@NonNull DirectedGraph<V, A> graph, @NonNull Predicate<V> vertexPredicate) {
        SimpleMutableDirectedGraph b = new SimpleMutableDirectedGraph();
        for (Object v : graph.getVertices()) {
            if (!vertexPredicate.test(v)) continue;
            b.addVertex(v);
        }
        for (Object v : graph.getVertices()) {
            for (Arc<V, A> arc : graph.getNextArcs(v)) {
                if (!vertexPredicate.test(arc.getEnd())) continue;
                b.addArrow(v, arc.getEnd(), arc.getArrow());
            }
        }
        return b;
    }

    public <V, A> void addAll(@NonNull DirectedGraph<V, A> source, @NonNull MutableDirectedGraph<V, A> target) {
        for (Object v : source.getVertices()) {
            target.addVertex(v);
        }
        for (Object v : source.getVertices()) {
            for (Arc<V, A> arc : source.getNextArcs(v)) {
                target.addArrow(arc.getStart(), arc.getEnd(), arc.getArrow());
            }
        }
    }

    public <V, A, VV, AA> void addAll(@NonNull DirectedGraph<VV, AA> source, @NonNull MutableDirectedGraph<V, A> target, @NonNull Function<VV, V> vertexMapper, @NonNull Function<AA, A> arrowMapper) {
        LinkedHashMap vertexMap = new LinkedHashMap(2 * target.getVertexCount());
        for (Object v : source.getVertices()) {
            V v2 = vertexMapper.apply(v);
            vertexMap.put(v, v2);
            target.addVertex(v2);
        }
        for (Map.Entry entry : vertexMap.entrySet()) {
            Object vv = entry.getKey();
            Object v = entry.getValue();
            int n = source.getNextCount(vv);
            for (int i = 0; i < n; ++i) {
                target.addArrow(v, vertexMapper.apply(source.getNext(vv, i)), arrowMapper.apply(source.getNextArrow(vv, i)));
            }
        }
    }
}

