/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.graph.BidiGraph;
import org.jhotdraw8.graph.IndexedBidiGraph;

public class IndexedBidiGraphBidiGraphFacade
implements BidiGraph<Integer, Integer> {
    private final @NonNull IndexedBidiGraph graph;

    public IndexedBidiGraphBidiGraphFacade(@NonNull IndexedBidiGraph graph) {
        this.graph = graph;
    }

    @Override
    public int getArrowCount() {
        return this.graph.getArrowCount();
    }

    @Override
    public @NonNull Integer getPrev(@NonNull Integer vertex, int index) {
        return this.graph.getPrevAsInt(vertex, index);
    }

    @Override
    public @NonNull Integer getPrevArrow(@NonNull Integer vertex, int index) {
        return this.graph.getPrevArrowAsInt(vertex, index);
    }

    @Override
    public int getPrevCount(@NonNull Integer vertex) {
        return this.graph.getPrevCount(vertex);
    }

    @Override
    public @NonNull Integer getVertex(int index) {
        return index;
    }

    @Override
    public @NonNull Integer getNext(@NonNull Integer v, int index) {
        return this.graph.getNextAsInt(v, index);
    }

    @Override
    public @NonNull Integer getNextArrow(@NonNull Integer v, int index) {
        return this.graph.getNextArrowAsInt(v, index);
    }

    @Override
    public int findIndexOfPrev(@NonNull Integer v, @NonNull Integer u) {
        return this.graph.findIndexOfPrevAsInt(v, u);
    }

    @Override
    public int findIndexOfNext(@NonNull Integer v, @NonNull Integer u) {
        return this.graph.findIndexOfNextAsInt(v, u);
    }

    @Override
    public int getNextCount(@NonNull Integer v) {
        return this.graph.getNextCount(v);
    }

    @Override
    public @NonNull Set<Integer> getVertices() {
        LinkedHashSet<Integer> set = new LinkedHashSet<Integer>(this.graph.getVertexCount());
        int n = this.graph.getVertexCount();
        for (int i = 0; i < n; ++i) {
            set.add(i);
        }
        return set;
    }
}

