/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.collection.enumerator.AbstractIntEnumerator;
import org.jhotdraw8.collection.enumerator.AbstractLongEnumerator;
import org.jhotdraw8.collection.enumerator.IntUShortArrayEnumerator;
import org.jhotdraw8.collection.primitive.DenseIntSet8Bit;
import org.jhotdraw8.collection.primitive.IntArrayDeque;
import org.jhotdraw8.collection.util.ListHelper;
import org.jhotdraw8.graph.IntAttributedIndexedBidiGraph;
import org.jhotdraw8.graph.MutableIndexedBidiGraph;
import org.jhotdraw8.graph.algo.AddToIntSet;
import org.jhotdraw8.graph.precondition.Preconditions;

public class MutableIntAttributed16BitIndexedBidiGraph
implements MutableIndexedBidiGraph,
IntAttributedIndexedBidiGraph {
    private final int maxArity;
    private final int stride;
    private short[] prev;
    private short[] next;
    private int[] nextArrow;
    private int[] prevArrow;
    private int vertexCount;
    private int arrowCount;
    private static final int VERTEX_DATA_SIZE = 2;

    public MutableIntAttributed16BitIndexedBidiGraph(int vertexCapacity, int maxArity) {
        if (vertexCapacity < 0) {
            throw new IllegalArgumentException("vertexCount=" + vertexCapacity);
        }
        if (maxArity < 0) {
            throw new IllegalArgumentException("maxArity=" + maxArity);
        }
        this.vertexCount = 0;
        this.maxArity = maxArity;
        this.stride = 3 + maxArity;
        this.next = new short[vertexCapacity * this.stride];
        this.prev = new short[vertexCapacity * this.stride];
        this.nextArrow = new int[vertexCapacity * maxArity];
        this.prevArrow = new int[vertexCapacity * maxArity];
    }

    public void clear() {
        this.vertexCount = 0;
        this.arrowCount = 0;
        Arrays.fill(this.next, (short)0);
        Arrays.fill(this.prev, (short)0);
        Arrays.fill(this.nextArrow, 0);
        Arrays.fill(this.prevArrow, 0);
    }

    @Override
    public void addArrowAsInt(int v, int u) {
        this.addArrowAsInt(v, u, 0);
    }

    @Override
    public void addArrowAsInt(int v, int u, int arrowData) {
        Preconditions.checkIndex(v, this.getVertexCount());
        Preconditions.checkIndex(u, this.getVertexCount());
        int vOffset = v * this.stride + 2;
        int vNewNextCount = this.next[vOffset] + 1;
        int uOffset = u * this.stride + 2;
        int uNewPrevCount = this.prev[uOffset] + 1;
        if (vNewNextCount > this.maxArity || uNewPrevCount > this.maxArity) {
            throw new IndexOutOfBoundsException("Not enough capacity for a new arrow " + v + "->" + u);
        }
        this.next[vOffset + vNewNextCount] = (short)u;
        this.next[vOffset] = (short)vNewNextCount;
        this.nextArrow[v * this.maxArity + vNewNextCount - 1] = arrowData;
        this.prevArrow[u * this.maxArity + uNewPrevCount - 1] = arrowData;
        this.prev[uOffset + uNewPrevCount] = (short)v;
        this.prev[uOffset] = (short)uNewPrevCount;
        ++this.arrowCount;
    }

    private void addToVectorIndices(short[] src, int vsrc, short[] dest, int vdst, int length, int vidx, int addend) {
        int srcOffset = vsrc * this.stride + 2;
        int dstOffset = vdst * this.stride + 2;
        for (int v = 0; v < length; ++v) {
            int i;
            short nDest = dest[dstOffset];
            int nSrc = src[srcOffset];
            dest[dstOffset] = (short)nSrc;
            for (i = 1; i <= nSrc; ++i) {
                short uidx = src[srcOffset + i];
                if (uidx < vidx) continue;
                dest[dstOffset + i] = (short)(uidx + addend);
            }
            if (nDest > nSrc) {
                for (i = nSrc + 1; i <= nDest; ++i) {
                    dest[dstOffset + i] = 0;
                }
            }
            srcOffset += this.stride;
            dstOffset += this.stride;
        }
    }

    @Override
    public void addVertexAsInt() {
        this.grow(this.vertexCount + 1);
        ++this.vertexCount;
    }

    @Override
    public void addVertexAsInt(int v) {
        this.grow(Math.max(this.vertexCount + 1, v));
        int newVertexCount = Math.max(v, this.vertexCount + 1);
        int vOffset = v * this.stride + 2;
        if (v < this.vertexCount) {
            this.addToVectorIndices(this.next, 0, this.next, 0, v, v, 1);
            this.addToVectorIndices(this.next, v, this.next, v + 1, this.vertexCount - v, v, 1);
            this.addToVectorIndices(this.prev, 0, this.prev, 0, v, v, 1);
            this.addToVectorIndices(this.prev, v, this.prev, v + 1, this.vertexCount - v, v, 1);
            System.arraycopy(this.nextArrow, v * this.maxArity, this.nextArrow, (v + 1) * this.maxArity, (this.vertexCount - v) * this.maxArity);
            System.arraycopy(this.prevArrow, v * this.maxArity, this.prevArrow, (v + 1) * this.maxArity, (this.vertexCount - v) * this.maxArity);
            Arrays.fill(this.next, vOffset, vOffset + this.stride, (short)0);
            Arrays.fill(this.prev, vOffset, vOffset + this.stride, (short)0);
            Arrays.fill(this.nextArrow, v * this.maxArity, (v + 1) * this.maxArity, 0);
            Arrays.fill(this.prevArrow, v * this.maxArity, (v + 1) * this.maxArity, 0);
        }
        this.vertexCount = newVertexCount;
    }

    @Override
    public int findIndexOfNextAsInt(int v, int u) {
        int vOffset;
        int end = vOffset + this.next[vOffset - 1];
        for (int i = vOffset = v * this.stride + 2 + 1; i < end; ++i) {
            if (this.next[i] != u) continue;
            return i - vOffset;
        }
        return -1;
    }

    @Override
    public int findIndexOfPrevAsInt(int v, int u) {
        int vOffset;
        int end = vOffset + this.prev[vOffset - 1];
        for (int i = vOffset = v * this.stride + 2 + 1; i < end; ++i) {
            if (this.prev[i] != u) continue;
            return i - vOffset;
        }
        return -1;
    }

    @Override
    public int getArrowCount() {
        return this.arrowCount;
    }

    @Override
    public int getNextAsInt(int v, int i) {
        int vOffset = v * this.stride + 2;
        Preconditions.checkIndex(i, this.next[vOffset]);
        return this.next[vOffset + i + 1];
    }

    @Override
    public int getNextCount(int v) {
        return this.next[v * this.stride + 2];
    }

    @Override
    public int getPrevAsInt(int v, int i) {
        int vOffset = v * this.stride + 2;
        Preconditions.checkIndex(i, this.prev[vOffset]);
        return this.prev[vOffset + i + 1];
    }

    @Override
    public int getPrevCount(int v) {
        return this.prev[v * this.stride + 2];
    }

    @Override
    public int getVertexCount() {
        return this.vertexCount;
    }

    private void grow(int capacity) {
        short[] temp = ListHelper.grow((int)capacity, (int)this.stride, (short[])this.next);
        if (temp.length < capacity * this.stride) {
            throw new IllegalStateException("too much capacity requested:" + capacity);
        }
        this.next = temp;
        this.prev = ListHelper.grow((int)capacity, (int)this.stride, (short[])this.prev);
        this.nextArrow = ListHelper.grow((int)capacity, (int)this.maxArity, (int[])this.nextArrow);
        this.prevArrow = ListHelper.grow((int)capacity, (int)this.maxArity, (int[])this.prevArrow);
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Enumerator.OfInt nextVerticesEnumerator(int v) {
        int vOffset = v * this.stride + 2;
        return new IntUShortArrayEnumerator(vOffset + 1, vOffset + 1 + this.next[vOffset], this.next);
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Enumerator.OfInt prevVerticesEnumerator(int v) {
        int vOffset = v * this.stride + 2;
        return new IntUShortArrayEnumerator(vOffset + 1, vOffset + 1 + this.prev[vOffset], this.prev);
    }

    @Override
    public void removeAllPrevAsInt(int v) {
        int vPrevCount;
        Preconditions.checkIndex(v, this.vertexCount);
        int vOffset = v * this.stride + 2;
        for (int i = vPrevCount = this.prev[vOffset]; i >= 0; --i) {
            this.removePrevAsInt(v, i);
        }
        this.prev[vOffset] = 0;
    }

    @Override
    public void removeAllNextAsInt(int v) {
        int vNextCount;
        Preconditions.checkIndex(v, this.vertexCount);
        int vOffset = v * this.stride + 2;
        for (int i = vNextCount = this.next[vOffset]; i >= 0; --i) {
            this.removeNextAsInt(v, i);
        }
    }

    @Override
    public void removeNextAsInt(int v, int index) {
        int uidx = this.getNextAsInt(v, index);
        int vOffset = v * this.stride + 2;
        int vNewNextCount = this.next[vOffset] - 1;
        int uOffset = uidx * this.stride + 2;
        int uNewPrevCount = this.prev[uOffset] - 1;
        int vIndex = this.findIndexOfPrevAsInt(uidx, v);
        if (vIndex < 0 || index < 0) {
            throw new NoSuchElementException("There is no arrow " + v + "->" + uidx);
        }
        int vArrowOffset = v * this.maxArity;
        if (index < vNewNextCount) {
            System.arraycopy(this.next, vOffset + index + 2, this.next, vOffset + index + 1, vNewNextCount - index);
            System.arraycopy(this.nextArrow, vArrowOffset + index + 1, this.nextArrow, vArrowOffset + index, vNewNextCount - index);
        }
        int uArrowOffset = uidx * this.maxArity;
        if (vIndex < uNewPrevCount) {
            System.arraycopy(this.prev, uOffset + vIndex + 2, this.prev, uOffset + vIndex + 1, uNewPrevCount - vIndex);
            System.arraycopy(this.prevArrow, uArrowOffset + vIndex + 1, this.prevArrow, uArrowOffset + vIndex, uNewPrevCount - vIndex);
        }
        this.next[vOffset + vNewNextCount + 1] = 0;
        this.prev[uOffset + uNewPrevCount + 1] = 0;
        this.nextArrow[vArrowOffset + vNewNextCount] = 0;
        this.prevArrow[uArrowOffset + uNewPrevCount] = 0;
        this.next[vOffset] = (short)vNewNextCount;
        this.prev[uOffset] = (short)uNewPrevCount;
        --this.arrowCount;
    }

    @Override
    public void removePrevAsInt(int vidx, int i) {
        int uidx = this.getPrevAsInt(vidx, i);
        int vOffset = vidx * this.stride + 2;
        int vNewPrevCount = this.prev[vOffset] - 1;
        int uOffset = uidx * this.stride + 2;
        int uNewNextCount = this.next[uOffset] - 1;
        int vIndex = this.findIndexOfNextAsInt(uidx, vidx);
        if (vIndex < 0 || i < 0) {
            throw new NoSuchElementException("There is no arrow " + vidx + "->" + uidx);
        }
        int vArrowOffset = vidx * this.maxArity;
        if (i < vNewPrevCount) {
            System.arraycopy(this.prev, vOffset + i + 2, this.prev, vOffset + i + 1, vNewPrevCount - i);
            System.arraycopy(this.prevArrow, vArrowOffset + i + 1, this.prevArrow, vArrowOffset + i, vNewPrevCount - i);
        }
        int uArrowOffset = uidx * this.maxArity;
        if (vIndex < uNewNextCount) {
            System.arraycopy(this.next, uOffset + vIndex + 2, this.next, uOffset + vIndex + 1, uNewNextCount - vIndex);
            System.arraycopy(this.nextArrow, uArrowOffset + vIndex + 1, this.nextArrow, uArrowOffset + vIndex, uNewNextCount - vIndex);
        }
        this.prev[vOffset + vNewPrevCount] = 0;
        this.next[uOffset + uNewNextCount] = 0;
        this.prevArrow[vArrowOffset + vNewPrevCount] = 0;
        this.nextArrow[uArrowOffset + uNewNextCount] = 0;
        this.prev[vOffset] = (short)vNewPrevCount;
        this.next[uOffset] = (short)uNewNextCount;
        --this.arrowCount;
    }

    @Override
    public void removeVertexAsInt(int v) {
        Preconditions.checkIndex(v, this.vertexCount);
        this.removeAllNextAsInt(v);
        this.removeAllPrevAsInt(v);
        if (v < this.vertexCount - 1) {
            this.addToVectorIndices(this.next, 0, this.next, 0, v, v, -1);
            this.addToVectorIndices(this.next, v, this.next, v + 1, this.vertexCount - v, v, -1);
            this.addToVectorIndices(this.prev, 0, this.prev, 0, v, v, -1);
            this.addToVectorIndices(this.prev, v, this.prev, v + 1, this.vertexCount - v, v, -1);
            System.arraycopy(this.nextArrow, (v + 1) * this.maxArity, this.nextArrow, v * this.maxArity, (this.vertexCount - v - 1) * this.maxArity);
            System.arraycopy(this.prevArrow, (v + 1) * this.maxArity, this.prevArrow, v * this.maxArity, (this.vertexCount - v - 1) * this.maxArity);
        }
        int vOffset = (this.vertexCount - 1) * this.stride + 2;
        Arrays.fill(this.next, vOffset, vOffset + this.stride, (short)0);
        Arrays.fill(this.prev, vOffset, vOffset + this.stride, (short)0);
        Arrays.fill(this.nextArrow, (this.vertexCount - 1) * this.maxArity, this.vertexCount * this.maxArity, 0);
        Arrays.fill(this.prevArrow, (this.vertexCount - 1) * this.maxArity, this.vertexCount * this.maxArity, 0);
        --this.vertexCount;
    }

    public void setVertexAsInt(int vidx, int data) {
        int offset = vidx * this.stride;
        this.prev[offset] = this.next[offset] = (short)(data >>> 16);
        short s = (short)data;
        this.next[offset + 1] = s;
        this.prev[offset + 1] = s;
    }

    @Override
    public int getNextArrowAsInt(int v, int i) {
        return this.nextArrow[v * this.maxArity + i];
    }

    @Override
    public int getPrevArrowAsInt(int v, int i) {
        return this.prevArrow[v * this.maxArity + i];
    }

    @Override
    public int getVertexDataAsInt(int vidx) {
        return this.getVertexDataFromNextAsInt(vidx);
    }

    public int getVertexDataFromNextAsInt(int vidx) {
        int offset = vidx * this.stride;
        return this.next[offset] << 16 | this.next[offset + 1];
    }

    public int getVertexDataFromPrevAsInt(int vidx) {
        int offset = vidx * this.stride;
        return this.prev[offset] << 16 | this.prev[offset + 1];
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Enumerator.OfInt seachNextVerticesAsInt(int vidx, boolean dfs) {
        return this.seachNextVerticesAsInt(vidx, arg_0 -> ((DenseIntSet8Bit)new DenseIntSet8Bit(this.vertexCount)).addAsInt(arg_0), dfs);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Enumerator.OfInt seachNextVerticesAsInt(int vidx, @NonNull AddToIntSet visited, boolean dfs) {
        return new VertexOfShortSpliterator(vidx, this.next, this.stride, 2, visited, dfs);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Enumerator.OfInt searchPrevVerticesAsInt(int vidx, boolean dfs) {
        return this.searchPrevVerticesAsInt(vidx, arg_0 -> ((DenseIntSet8Bit)new DenseIntSet8Bit(this.vertexCount)).addAsInt(arg_0), dfs);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Enumerator.OfInt searchPrevVerticesAsInt(int vidx, @NonNull AddToIntSet visited, boolean dfs) {
        return new VertexOfShortSpliterator(vidx, this.prev, this.stride, 2, visited, dfs);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Enumerator.OfLong searchNextVerticesWithVertexData(int vidx, boolean dfs) {
        return this.searchNextVerticesWithVertexData(vidx, arg_0 -> ((DenseIntSet8Bit)new DenseIntSet8Bit(this.vertexCount)).addAsInt(arg_0), dfs);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Enumerator.OfLong searchNextVerticesWithVertexData(int vidx, @NonNull AddToIntSet visited, boolean dfs) {
        return new VertexEnumeratorOfLongShortSpliterator(vidx, this.next, this.stride, 0, visited, dfs);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Enumerator.OfLong searchPrevVerticesWithVertexData(int vidx, boolean dfs) {
        return this.searchPrevVerticesWithVertexData(vidx, arg_0 -> ((DenseIntSet8Bit)new DenseIntSet8Bit(this.vertexCount)).addAsInt(arg_0), dfs);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Enumerator.OfLong searchPrevVerticesWithVertexData(int vidx, @NonNull AddToIntSet visited, boolean dfs) {
        return new VertexEnumeratorOfLongShortSpliterator(vidx, this.prev, this.stride, 0, visited, dfs);
    }

    private static class VertexOfShortSpliterator
    extends AbstractIntEnumerator {
        private final short[] array;
        private final int stride;
        private final int offset;
        private final @NonNull IntArrayDeque deque = new IntArrayDeque();
        private final @NonNull AddToIntSet visited;
        private final boolean dfs;

        protected VertexOfShortSpliterator(int root, short[] array, int stride, int offset, @NonNull AddToIntSet visited, boolean dfs) {
            super(Long.MAX_VALUE, 273);
            this.array = array;
            this.stride = stride;
            this.offset = offset;
            this.visited = visited;
            this.dfs = dfs;
            if (visited.addAsInt(root)) {
                this.deque.addFirstAsInt(root);
            }
        }

        public boolean moveNext() {
            if (this.deque.isEmpty()) {
                return false;
            }
            this.current = this.dfs ? this.deque.removeLastAsInt() : this.deque.removeFirstAsInt();
            int currentOffset = this.current * this.stride + this.offset;
            int size = this.array[currentOffset] & 0xFFFF;
            int end = currentOffset + size + 1;
            for (int i = currentOffset + 1; i < end; ++i) {
                int vidx = this.array[i] & 0xFFFF;
                if (!this.visited.addAsInt(vidx)) continue;
                this.deque.addLastAsInt(vidx);
            }
            return true;
        }
    }

    private static class VertexEnumeratorOfLongShortSpliterator
    extends AbstractLongEnumerator {
        private final short[] array;
        private final int stride;
        private final int offset;
        private final @NonNull IntArrayDeque deque = new IntArrayDeque();
        private final @NonNull AddToIntSet visited;
        private final boolean dfs;

        protected VertexEnumeratorOfLongShortSpliterator(int root, short[] array, int stride, int offset, @NonNull AddToIntSet visited, boolean dfs) {
            super(Long.MAX_VALUE, 273);
            this.array = array;
            this.stride = stride;
            this.offset = offset;
            this.visited = visited;
            this.dfs = dfs;
            if (visited.addAsInt(root)) {
                this.deque.addFirstAsInt(root);
            }
        }

        public boolean moveNext() {
            if (this.deque.isEmpty()) {
                return false;
            }
            int currentIdx = this.dfs ? this.deque.removeLastAsInt() : this.deque.removeFirstAsInt();
            int currentDataOffset = currentIdx * this.stride;
            this.current = (long)this.array[currentDataOffset] << 48 | (long)this.array[currentDataOffset] << 32 | (long)currentIdx & 0xFFFFFFFFL;
            int currentOffset = currentDataOffset + this.offset;
            short size = this.array[currentOffset];
            int end = currentOffset + size;
            for (int i = currentOffset + 1; i <= end; ++i) {
                int vidx = this.array[i] & 0xFFFF;
                if (!this.visited.addAsInt(vidx)) continue;
                this.deque.addLastAsInt(vidx);
            }
            return true;
        }
    }
}

