/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.algo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.collection.pair.OrderedPair;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.DirectedGraph;
import org.jhotdraw8.graph.SimpleMutableDirectedGraph;

public class MinimumSpanningTreeAlgo {
    public static <VV> @NonNull Map<VV, List<VV>> createForest(@NonNull Collection<VV> vertices) {
        LinkedHashMap forest = new LinkedHashMap(vertices.size());
        for (VV v : vertices) {
            ArrayList<VV> initialSet = new ArrayList<VV>(1);
            initialSet.add(v);
            forest.put(v, initialSet);
        }
        return forest;
    }

    public static <VV> void union(@NonNull List<VV> uset, @NonNull List<VV> vset, @NonNull Map<VV, List<VV>> forest) {
        if (uset != vset) {
            if (uset.size() < vset.size()) {
                for (VV uu : uset) {
                    forest.put(uu, vset);
                }
                vset.addAll(uset);
            } else {
                for (VV vv : vset) {
                    forest.put(vv, uset);
                }
                uset.addAll(vset);
            }
        }
    }

    public <V, A, C extends Number, P extends OrderedPair<V, V>> @NonNull List<P> findMinimumSpanningTree(@NonNull Collection<V> vertices, @NonNull List<P> orderedEdges, @Nullable List<P> rejectedEdges) {
        ArrayList<OrderedPair> minimumSpanningTree = new ArrayList<OrderedPair>(orderedEdges.size());
        if (rejectedEdges == null) {
            rejectedEdges = new ArrayList<P>(orderedEdges.size());
        }
        Map<V, List<V>> forest = MinimumSpanningTreeAlgo.createForest(vertices);
        for (OrderedPair arrow : orderedEdges) {
            List<V> vset;
            List<V> uset = forest.get(arrow.first());
            if (uset != (vset = forest.get(arrow.second()))) {
                MinimumSpanningTreeAlgo.union(uset, vset, forest);
                minimumSpanningTree.add(arrow);
                continue;
            }
            rejectedEdges.add(arrow);
        }
        return minimumSpanningTree;
    }

    public <V, A, C extends Number> @NonNull SimpleMutableDirectedGraph<V, A> findMinimumSpanningTreeGraph(@NonNull DirectedGraph<V, A> graph, @NonNull Function<A, C> costf) {
        return this.findMinimumSpanningTreeGraph(graph, (u, v, a) -> (Number)costf.apply(a));
    }

    public <V, A, C extends Number> @NonNull SimpleMutableDirectedGraph<V, A> findMinimumSpanningTreeGraph(@NonNull DirectedGraph<V, A> graph, @NonNull Function3<V, V, A, C> costf) {
        Set vertices = graph.getVertices();
        HashSet done = new HashSet();
        ArrayList<ArrowWithCost> arrowWithCosts = new ArrayList<ArrowWithCost>();
        for (Object start : vertices) {
            done.add(start);
            for (Arc<V, A> entry : graph.getNextArcs(start)) {
                V end = entry.getEnd();
                A arrow = entry.getArrow();
                if (done.contains(end)) continue;
                arrowWithCosts.add(new ArrowWithCost(start, end, arrow, (Number)costf.apply(start, end, arrow)));
            }
        }
        arrowWithCosts.sort(Comparator.comparing(a -> a.cost));
        List mst = this.findMinimumSpanningTree(vertices, arrowWithCosts, null);
        SimpleMutableDirectedGraph builder = new SimpleMutableDirectedGraph(vertices.size(), mst.size() * 2);
        for (Arc<V, A> v : vertices) {
            builder.addVertex(v);
        }
        for (ArrowWithCost e : mst) {
            builder.addArrow(e.first(), e.second(), e.arrow);
            builder.addArrow(e.second(), e.first(), e.arrow);
        }
        return builder;
    }

    public <V, A, C extends Number, P extends OrderedPair<V, V>> @NonNull SimpleMutableDirectedGraph<V, P> findMinimumSpanningTreeGraph(@NonNull Collection<V> vertices, @NonNull List<P> orderedArrows, @Nullable List<P> includedArrows, List<P> rejectedArrows) {
        List<P> includedArrowList = this.findMinimumSpanningTree(vertices, orderedArrows, rejectedArrows);
        if (includedArrows != null) {
            includedArrows.addAll(includedArrowList);
        }
        SimpleMutableDirectedGraph<Object, OrderedPair> builder = new SimpleMutableDirectedGraph<Object, OrderedPair>();
        for (V v : vertices) {
            builder.addVertex(v);
        }
        for (OrderedPair e : includedArrowList) {
            builder.addArrow(e.first(), e.second(), e);
            builder.addArrow(e.second(), e.first(), e);
        }
        return builder;
    }

    private static class ArrowWithCost<VV, AA, CC extends Number>
    extends SimpleOrderedPair<VV, VV> {
        private final AA arrow;
        private final CC cost;

        public ArrowWithCost(VV a, VV b, AA arrow, CC cost) {
            super(a, b);
            this.arrow = arrow;
            this.cost = cost;
        }
    }
}

