/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.algo;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.collection.enumerator.Enumerator;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.collection.primitive.IntArrayList;
import org.jhotdraw8.graph.AttributedIndexedDirectedGraph;
import org.jhotdraw8.graph.DirectedGraph;
import org.jhotdraw8.graph.IndexedDirectedGraph;
import org.jhotdraw8.graph.algo.StronglyConnectedComponentsAlgo;

public class TopologicalSortAlgo {
    public <V, A> @NonNull List<V> sortTopologically(DirectedGraph<V, A> m) {
        if (!(m instanceof AttributedIndexedDirectedGraph)) {
            return this.sortTopologicallyObject(m);
        }
        AttributedIndexedDirectedGraph im = (AttributedIndexedDirectedGraph)((Object)m);
        int[] a = this.sortTopologicallyInt(im);
        ArrayList result = new ArrayList(a.length);
        for (int j : a) {
            result.add(im.getVertex(j));
        }
        return result;
    }

    public int @NonNull [] sortTopologicallyInt(@NonNull IndexedDirectedGraph model) {
        int n = model.getVertexCount();
        int[] deg = new int[n];
        for (int i = 0; i < n; ++i) {
            Enumerator.OfInt iter = model.nextVerticesEnumerator(i);
            while (iter.moveNext()) {
                int v;
                int n2 = v = iter.currentAsInt();
                deg[n2] = deg[n2] + 1;
            }
        }
        int[] queue = new int[n];
        int first = 0;
        int last = 0;
        for (int i = 0; i < n; ++i) {
            if (deg[i] != 0) continue;
            queue[last++] = i;
        }
        int[] result = new int[n];
        int done = 0;
        while (done < n) {
            int i;
            while (done < n && first != last) {
                int v = queue[first++];
                Enumerator.OfInt iter = model.nextVerticesEnumerator(v);
                while (iter.moveNext()) {
                    int u;
                    int n3 = u = iter.currentAsInt();
                    deg[n3] = deg[n3] - 1;
                    if (deg[n3] != 0) continue;
                    queue[last++] = u;
                }
                result[done] = v;
                ++done;
            }
            if (done >= n) continue;
            for (i = 0; i < n - 1 && deg[i] <= 0; ++i) {
            }
            if (deg[i] == 0) {
                throw new AssertionError((Object)("bug in loop-breaking algorithm i: " + i));
            }
            deg[i] = 0;
            queue[last++] = i;
        }
        return result;
    }

    public @NonNull SimpleOrderedPair<int[], IntArrayList> sortTopologicallyIntBatches(@NonNull IndexedDirectedGraph model) {
        int n = model.getVertexCount();
        IntArrayList batches = new IntArrayList();
        boolean hasLoop = false;
        int[] deg = new int[n];
        for (int i = 0; i < n; ++i) {
            Enumerator.OfInt iter = model.nextVerticesEnumerator(i);
            while (iter.moveNext()) {
                int v;
                int n2 = v = iter.currentAsInt();
                deg[n2] = deg[n2] + 1;
            }
        }
        int[] queue = new int[n];
        int first = 0;
        int last = 0;
        for (int i = 0; i < n; ++i) {
            if (deg[i] != 0) continue;
            queue[last++] = i;
        }
        int lastBatch = last;
        batches.addAsInt(last);
        int[] result = new int[n];
        int done = 0;
        while (done < n) {
            int i;
            while (done < n) {
                if (first == last) {
                    hasLoop = true;
                    break;
                }
                int v = queue[first++];
                queue[first - 1] = 0;
                Enumerator.OfInt iter = model.nextVerticesEnumerator(v);
                while (iter.moveNext()) {
                    int u;
                    int n3 = u = iter.currentAsInt();
                    deg[n3] = deg[n3] - 1;
                    if (deg[n3] != 0) continue;
                    queue[last++] = u;
                }
                result[done] = v;
                if (first == lastBatch && done < n - 1) {
                    lastBatch = last;
                    batches.addAsInt(last);
                }
                ++done;
            }
            if (done >= n) continue;
            for (i = 0; i < n - 1 && deg[i] <= 0; ++i) {
            }
            if (deg[i] == 0) {
                throw new AssertionError((Object)("bug in loop-breaking algorithm i: " + i));
            }
            deg[i] = 0;
            queue[last++] = i;
        }
        if (hasLoop) {
            batches.clear();
        }
        return new SimpleOrderedPair((Object)result, (Object)batches);
    }

    public <V, A> @NonNull List<V> sortTopologicallyObject(@NonNull DirectedGraph<V, A> model) {
        return this.sortTopologically(model.getVertices(), model::getNextVertices);
    }

    /*
     * WARNING - void declaration
     */
    public <V> @NonNull List<V> sortTopologically(@NonNull Collection<V> vertices, @NonNull Function<V, Iterable<? extends V>> nextVertices) {
        void var8_12;
        int n = vertices.size();
        LinkedHashSet verticesInLoops = null;
        LinkedHashMap<Object, Integer> deg = new LinkedHashMap<Object, Integer>(n);
        for (Object v : vertices) {
            deg.putIfAbsent(v, 0);
            for (V u : nextVertices.apply(v)) {
                deg.merge(u, 1, Integer::sum);
            }
        }
        ArrayDeque<Object> queue = new ArrayDeque<Object>(n);
        for (Map.Entry entry : deg.entrySet()) {
            if ((Integer)entry.getValue() != 0) continue;
            queue.add(entry.getKey());
        }
        ArrayList result = new ArrayList(n);
        boolean bl = false;
        while (var8_12 < n) {
            while (var8_12 < n && !queue.isEmpty()) {
                Object v = queue.remove();
                for (Object object : nextVertices.apply(v)) {
                    if (deg.merge(object, -1, Integer::sum) != 0) continue;
                    queue.add(object);
                }
                result.add(v);
                ++var8_12;
            }
            if (var8_12 >= n) continue;
            if (verticesInLoops == null) {
                List<List<V>> stronglyConnectedComponents = new StronglyConnectedComponentsAlgo().findStronglyConnectedComponents(vertices, nextVertices);
                verticesInLoops = new LinkedHashSet();
                for (List list : stronglyConnectedComponents) {
                    if (list.size() <= 1) continue;
                    verticesInLoops.addAll(list);
                }
            }
            boolean didBreakLoop = false;
            for (Object object : verticesInLoops) {
                if ((Integer)deg.get(object) <= 0) continue;
                deg.put(object, 0);
                queue.add(object);
                didBreakLoop = true;
                break;
            }
            if (!didBreakLoop) {
                throw new AssertionError((Object)"Programming error in loop breaking code.");
            }
        }
        return result;
    }
}

