/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.io;

import java.io.IOException;
import java.io.StringWriter;
import java.util.function.Function;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.DirectedGraph;

public class GraphvizWriter {
    public <V, A> void write(@NonNull Appendable w, @NonNull DirectedGraph<V, A> graph) throws IOException {
        this.write(w, graph, v -> "\"" + String.valueOf(v) + "\"", null, null, null);
    }

    public <V, A> void write(@NonNull Appendable w, @NonNull DirectedGraph<V, A> graph, @NonNull Function<V, String> vertexToString) throws IOException {
        this.write(w, graph, vertexToString, null, null, "G");
    }

    public <V, A> String write(@NonNull DirectedGraph<V, A> graph, @NonNull Function<V, String> vertexToString, @NonNull Function<V, String> vertexAttributes, @NonNull Function<A, String> arrowAttributes) {
        StringWriter w = new StringWriter();
        try {
            this.write(w, graph, vertexToString, vertexAttributes, arrowAttributes, "G");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return w.toString();
    }

    public <V, A> void write(@NonNull Appendable w, @NonNull DirectedGraph<V, A> graph, @NonNull Function<V, String> vertexToString, @Nullable Function<V, String> vertexAttributes, @Nullable Function<A, String> arrowAttributes, @Nullable String graphId) throws IOException {
        w.append("digraph");
        if (graphId != null) {
            w.append(" ").append(graphId);
        }
        w.append(" {\n");
        for (Object v : graph.getVertices()) {
            String vertexName = vertexToString.apply(v);
            if (vertexName == null) continue;
            String vattr = vertexAttributes == null ? null : vertexAttributes.apply(v);
            w.append(vertexName);
            if (vattr != null && !vattr.isEmpty()) {
                w.append(" [").append(vattr).append("]");
            }
            w.append('\n');
        }
        for (Object start : graph.getVertices()) {
            for (Arc<V, A> arc : graph.getNextArcs(start)) {
                String attrString;
                V end = arc.getEnd();
                A arrow = arc.getArrow();
                String startVertexName = vertexToString.apply(start);
                String endVertexName = vertexToString.apply(end);
                if (startVertexName == null || endVertexName == null) continue;
                w.append(startVertexName);
                w.append(" -> ").append(endVertexName);
                if (arrowAttributes != null && (attrString = arrowAttributes.apply(arrow)) != null && !attrString.isEmpty()) {
                    w.append(" [");
                    w.append(attrString);
                    w.append("]");
                }
                w.append('\n');
            }
        }
        w.append("}\n");
    }

    public <V, A> String write(@NonNull DirectedGraph<V, A> graph) {
        StringWriter w = new StringWriter();
        try {
            this.write(w, graph, Object::toString);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return w.toString();
    }
}

