/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.collection.pair.OrderedPair;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public interface ArrowSequenceFinder<V, A, C extends Number> {
    public @Nullable SimpleOrderedPair<ImmutableList<A>, C> findArrowSequence(@NonNull Iterable<V> var1, @NonNull Predicate<V> var2, int var3, @NonNull C var4, @NonNull AddToSet<V> var5);

    default public @Nullable SimpleOrderedPair<ImmutableList<A>, C> findArrowSequence(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, int maxDepth, @NonNull C costLimit) {
        return this.findArrowSequence(startVertices, goalPredicate, maxDepth, costLimit, new HashSet()::add);
    }

    default public @Nullable SimpleOrderedPair<ImmutableList<A>, C> findArrowSequence(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, @NonNull C costLimit) {
        return this.findArrowSequence(startVertices, goalPredicate, Integer.MAX_VALUE, costLimit, new HashSet()::add);
    }

    default public @Nullable OrderedPair<ImmutableList<A>, C> findArrowSequence(@NonNull V start, @NonNull V goal, int maxDepth, @NonNull C costLimit, @NonNull AddToSet<V> visited) {
        return this.findArrowSequence((Iterable<V>)VectorList.of((Object[])new Object[]{start}), (Predicate<V>)((Predicate<Object>)goal::equals), maxDepth, costLimit, visited);
    }

    default public @Nullable SimpleOrderedPair<ImmutableList<A>, C> findArrowSequence(@NonNull V start, @NonNull V goal, int maxDepth, @NonNull C costLimit) {
        return this.findArrowSequence((Iterable<V>)VectorList.of((Object[])new Object[]{start}), (Predicate<V>)((Predicate<Object>)goal::equals), maxDepth, costLimit, (AddToSet<V>)((AddToSet<Object>)new HashSet()::add));
    }

    default public @Nullable SimpleOrderedPair<ImmutableList<A>, C> findArrowSequence(@NonNull V start, @NonNull V goal, @NonNull C costLimit) {
        return this.findArrowSequence((Iterable<V>)VectorList.of((Object[])new Object[]{start}), (Predicate<V>)((Predicate<Object>)goal::equals), Integer.MAX_VALUE, costLimit, (AddToSet<V>)((AddToSet<Object>)new HashSet()::add));
    }

    public @Nullable SimpleOrderedPair<ImmutableList<A>, C> findArrowSequenceOverWaypoints(@NonNull Iterable<V> var1, int var2, @NonNull C var3, @NonNull Supplier<AddToSet<V>> var4);

    default public @Nullable SimpleOrderedPair<ImmutableList<A>, C> findArrowSequenceOverWaypoints(@NonNull Iterable<V> waypoints, int maxDepth, @NonNull C costLimit) {
        return this.findArrowSequenceOverWaypoints(waypoints, maxDepth, costLimit, () -> new HashSet()::add);
    }

    default public @Nullable SimpleOrderedPair<ImmutableList<A>, C> findArrowSequenceOverWaypoints(@NonNull Iterable<V> waypoints, @NonNull C costLimit) {
        return this.findArrowSequenceOverWaypoints(waypoints, Integer.MAX_VALUE, costLimit, () -> new HashSet()::add);
    }

    public static <VV, AA, CC extends Number> @Nullable SimpleOrderedPair<ImmutableList<AA>, CC> findArrowSequenceOverWaypoints(@NonNull Iterable<VV> waypoints, @NonNull BiFunction<VV, VV, OrderedPair<ImmutableList<AA>, CC>> findArrowSequenceFunction, @NonNull CC zero, @NonNull BiFunction<CC, CC, CC> sumFunction) {
        ArrayList sequence = new ArrayList();
        Object sum = zero;
        Object prev = null;
        int count = 0;
        for (VV next : waypoints) {
            if (prev != null) {
                OrderedPair<ImmutableList<AA>, CC> result = findArrowSequenceFunction.apply(prev, next);
                if (result == null) {
                    return null;
                }
                List nextSequence = ((ImmutableList)result.first()).asList();
                sequence.addAll(nextSequence);
                sum = (Number)sumFunction.apply(sum, (Number)result.second());
            }
            prev = next;
            ++count;
        }
        if (count == 1) {
            return new SimpleOrderedPair((Object)VectorList.of(), zero);
        }
        return new SimpleOrderedPair((Object)VectorList.copyOf(sequence), sum);
    }
}

