/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.collection.pair.OrderedPair;
import org.jhotdraw8.collection.spliterator.SpliteratorIterable;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.path.CombinedAllSequencesFinder;
import org.jhotdraw8.graph.path.algo.AllWalksSpliterator;
import org.jhotdraw8.graph.path.backlink.ArcBackLinkWithCost;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class SimpleCombinedAllSequencesFinder<V, A, C extends Number>
implements CombinedAllSequencesFinder<V, A, C> {
    private final @NonNull C zero;
    private final @NonNull Function<V, Iterable<Arc<V, A>>> nextArcsFunction;
    private final @NonNull Function3<V, V, A, C> costFunction;
    private final @NonNull BiFunction<C, C, C> sumFunction;

    public SimpleCombinedAllSequencesFinder(@NonNull Function<V, Iterable<Arc<V, A>>> nextArcsFunction, @NonNull C zero, @NonNull Function3<V, V, A, C> costFunction, @NonNull BiFunction<C, C, C> sumFunction) {
        this.zero = zero;
        this.nextArcsFunction = nextArcsFunction;
        this.costFunction = costFunction;
        this.sumFunction = sumFunction;
    }

    @Override
    public @NonNull Iterable<OrderedPair<ImmutableList<Arc<V, A>>, C>> findAllArcSequences(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, int maxDepth, @NonNull C costLimit) {
        return new SpliteratorIterable(() -> new AllWalksSpliterator(startVertices, goalPredicate, this.nextArcsFunction, backLink -> ArcBackLinkWithCost.toArrowSequence(backLink, (a, b) -> new Arc(a.getVertex(), b.getVertex(), b.getArrow())), maxDepth, (Number)costLimit, (Number)this.zero, this.costFunction, (BiFunction<Number, Number, Number>)this.sumFunction));
    }

    @Override
    public @NonNull Iterable<OrderedPair<ImmutableList<A>, C>> findAllArrowSequences(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, int maxDepth, @NonNull C costLimit) {
        return new SpliteratorIterable(() -> new AllWalksSpliterator(startVertices, goalPredicate, this.nextArcsFunction, backLink -> ArcBackLinkWithCost.toArrowSequence(backLink, (a, b) -> b.getArrow()), maxDepth, (Number)costLimit, (Number)this.zero, this.costFunction, (BiFunction<Number, Number, Number>)this.sumFunction));
    }

    @Override
    public @NonNull Iterable<OrderedPair<ImmutableList<V>, C>> findAllVertexSequences(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, int maxDepth, @NonNull C costLimit) {
        return new SpliteratorIterable(() -> new AllWalksSpliterator(startVertices, goalPredicate, this.nextArcsFunction, backLink -> ArcBackLinkWithCost.toVertexSequence(backLink, ArcBackLinkWithCost::getVertex), maxDepth, (Number)costLimit, (Number)this.zero, this.costFunction, (BiFunction<Number, Number, Number>)this.sumFunction));
    }
}

