/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path;

import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.graph.algo.AddToIntSet;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.VertexSequenceFinder;
import org.jhotdraw8.graph.path.algo.IndexedVertexPathSearchAlgo;
import org.jhotdraw8.graph.path.backlink.IndexedVertexBackLinkWithCost;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class SimpleIndexedVertexSequenceFinder<C extends Number>
implements VertexSequenceFinder<Integer, C> {
    private final @NonNull IndexedVertexPathSearchAlgo<C> algo;
    private final @NonNull C zero;
    private final @NonNull Function<Integer, Spliterator.OfInt> nextVerticesFunction;
    private final @NonNull BiFunction<Integer, Integer, C> costFunction;
    private final @NonNull BiFunction<C, C, C> sumFunction;

    public SimpleIndexedVertexSequenceFinder(@NonNull C zero, @NonNull Function<Integer, Spliterator.OfInt> nextVerticesFunction, @NonNull BiFunction<Integer, Integer, C> costFunction, @NonNull BiFunction<C, C, C> sumFunction, @NonNull IndexedVertexPathSearchAlgo<C> algo) {
        this.zero = zero;
        this.nextVerticesFunction = nextVerticesFunction;
        this.costFunction = costFunction;
        this.sumFunction = sumFunction;
        this.algo = algo;
    }

    public static @NonNull SimpleIndexedVertexSequenceFinder<Integer> newIntCostInstance(@NonNull Function<Integer, Spliterator.OfInt> nextVerticesFunction, @NonNull BiFunction<Integer, Integer, Integer> costFunction, @NonNull IndexedVertexPathSearchAlgo<Integer> algo) {
        return new SimpleIndexedVertexSequenceFinder<Integer>(0, nextVerticesFunction, costFunction, Integer::sum, algo);
    }

    public static @NonNull SimpleIndexedVertexSequenceFinder<Integer> newIntCostInstance(@NonNull Function<Integer, Spliterator.OfInt> nextVerticesFunction, @NonNull IndexedVertexPathSearchAlgo<Integer> algo) {
        return new SimpleIndexedVertexSequenceFinder<Integer>(0, nextVerticesFunction, (u, v) -> 1, Integer::sum, algo);
    }

    public static @NonNull SimpleIndexedVertexSequenceFinder<Long> newLongCostInstance(@NonNull Function<Integer, Spliterator.OfInt> nextVerticesFunction, @NonNull BiFunction<Integer, Integer, Long> costFunction, @NonNull IndexedVertexPathSearchAlgo<Long> algo) {
        return new SimpleIndexedVertexSequenceFinder<Long>(0L, nextVerticesFunction, costFunction, Long::sum, algo);
    }

    @Override
    public @Nullable SimpleOrderedPair<ImmutableList<Integer>, C> findVertexSequence(@NonNull Iterable<Integer> startVertices, @NonNull Predicate<Integer> goalPredicate, int maxDepth, @NonNull C costLimit, @NonNull AddToSet<Integer> visited) {
        AddToIntSet visitedAsInt = visited instanceof AddToIntSet ? (AddToIntSet)visited : visited::add;
        return IndexedVertexBackLinkWithCost.toVertexSequence(this.algo.search(startVertices, goalPredicate::test, this.nextVerticesFunction, maxDepth, this.zero, costLimit, this.costFunction, this.sumFunction, visitedAsInt), IndexedVertexBackLinkWithCost::getVertex);
    }

    @Override
    public @Nullable SimpleOrderedPair<ImmutableList<Integer>, C> findVertexSequenceOverWaypoints(@NonNull Iterable<Integer> waypoints, int maxDepth, @NonNull C costLimit, @NonNull Supplier<AddToSet<Integer>> visitedSetFactory) {
        return VertexSequenceFinder.findVertexSequenceOverWaypoints(waypoints, (start, goal) -> this.findVertexSequence(start, goal, maxDepth, costLimit, (AddToSet)visitedSetFactory.get()), this.zero, this.sumFunction);
    }
}

