/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path;

import java.util.Collections;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.ReachabilityChecker;
import org.jhotdraw8.graph.path.algo.ArcReachabilityAlgo;

public class SimpleReachabilityChecker<V, A, C extends Number>
implements ReachabilityChecker<V, C> {
    private final @NonNull ArcReachabilityAlgo<V, A, C> algo;
    private final @NonNull C zero;
    private final @NonNull Function<V, Iterable<Arc<V, A>>> nextArcsFunction;
    private final @NonNull Function3<V, V, A, C> costFunction;
    private final @NonNull BiFunction<C, C, C> sumFunction;

    public SimpleReachabilityChecker(@NonNull C zero, @NonNull Function<V, Iterable<Arc<V, A>>> nextArcsFunction, @NonNull Function3<V, V, A, C> costFunction, @NonNull BiFunction<C, C, C> sumFunction, @NonNull ArcReachabilityAlgo<V, A, C> algo) {
        if (((Number)zero).doubleValue() != 0.0) {
            throw new IllegalArgumentException("zero(" + String.valueOf(zero) + ") is != 0");
        }
        this.zero = zero;
        this.nextArcsFunction = nextArcsFunction;
        this.costFunction = costFunction;
        this.sumFunction = sumFunction;
        this.algo = algo;
    }

    public static <VV, AA> @NonNull SimpleReachabilityChecker<VV, AA, Integer> newIntCostInstance(@NonNull Function<VV, Iterable<Arc<VV, AA>>> nextArcsFunction, @NonNull Function3<VV, VV, AA, Integer> costFunction, @NonNull ArcReachabilityAlgo<VV, AA, Integer> algo) {
        return new SimpleReachabilityChecker<VV, AA, Integer>(0, nextArcsFunction, costFunction, Integer::sum, algo);
    }

    public static <VV, AA> @NonNull SimpleReachabilityChecker<VV, AA, Integer> newIntCostInstance(@NonNull Function<VV, Iterable<Arc<VV, AA>>> nextArcsFunction, @NonNull ArcReachabilityAlgo<VV, AA, Integer> algo) {
        return new SimpleReachabilityChecker<VV, AA, Integer>(0, nextArcsFunction, (u, v, a) -> 1, Integer::sum, algo);
    }

    public static <VV, AA> @NonNull SimpleReachabilityChecker<VV, AA, Long> newLongCostInstance(@NonNull Function<VV, Iterable<Arc<VV, AA>>> nextArcsFunction, @NonNull Function3<VV, VV, AA, Long> costFunction, @NonNull ArcReachabilityAlgo<VV, AA, Long> algo) {
        return new SimpleReachabilityChecker<VV, AA, Long>(0L, nextArcsFunction, costFunction, Long::sum, algo);
    }

    @Override
    public boolean isReachable(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, int maxDepth, @NonNull C costLimit, @NonNull AddToSet<V> visited) {
        return this.algo.tryToReach(startVertices, goalPredicate, this.nextArcsFunction, maxDepth, this.zero, costLimit, this.costFunction, this.sumFunction);
    }

    @Override
    public boolean isReachable(@NonNull V start, @NonNull Predicate<V> goalPredicate, int maxDepth, @NonNull C costLimit, @NonNull AddToSet<V> visited) {
        return this.algo.tryToReach(Collections.singletonList(start), goalPredicate, this.nextArcsFunction, maxDepth, this.zero, costLimit, this.costFunction, this.sumFunction);
    }

    @Override
    public boolean isReachable(@NonNull V start, @NonNull V goal, int maxDepth, @NonNull C costLimit, @NonNull AddToSet<V> visited) {
        return this.algo.tryToReach(Collections.singletonList(start), goal::equals, this.nextArcsFunction, maxDepth, this.zero, costLimit, this.costFunction, this.sumFunction);
    }
}

