/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.collection.pair.OrderedPair;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public interface VertexSequenceFinder<V, C extends Number> {
    public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequence(@NonNull Iterable<V> var1, @NonNull Predicate<V> var2, int var3, @NonNull C var4, @NonNull AddToSet<V> var5);

    default public @Nullable OrderedPair<ImmutableList<V>, C> findVertexSequence(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, int maxDepth, @NonNull C costLimit) {
        return this.findVertexSequence((V)startVertices, (V)goalPredicate, maxDepth, costLimit, (AddToSet<V>)((AddToSet<Object>)new HashSet()::add));
    }

    default public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequence(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, @NonNull C costLimit) {
        return this.findVertexSequence((V)startVertices, (V)goalPredicate, Integer.MAX_VALUE, costLimit, (AddToSet<V>)((AddToSet<Object>)new HashSet()::add));
    }

    default public @Nullable OrderedPair<ImmutableList<V>, C> findVertexSequence(@NonNull V start, @NonNull Predicate<V> goalPredicate, int maxDepth, @NonNull C costLimit, @NonNull AddToSet<V> visited) {
        return this.findVertexSequence((V)Collections.singletonList(start), (V)goalPredicate, maxDepth, costLimit, visited);
    }

    default public @Nullable OrderedPair<ImmutableList<V>, C> findVertexSequence(@NonNull V start, @NonNull Predicate<V> goalPredicate, int maxDepth, @NonNull C costLimit) {
        return this.findVertexSequence((V)Collections.singletonList(start), (V)goalPredicate, maxDepth, costLimit, (AddToSet<V>)((AddToSet<Object>)new HashSet()::add));
    }

    default public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequence(@NonNull V start, @NonNull Predicate<V> goalPredicate, @NonNull C costLimit) {
        return this.findVertexSequence((V)Collections.singletonList(start), (V)goalPredicate, Integer.MAX_VALUE, costLimit, (AddToSet<V>)((AddToSet<Object>)new HashSet()::add));
    }

    default public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequence(@NonNull V start, @NonNull V goal, int maxDepth, @NonNull C costLimit, @NonNull AddToSet<V> visited) {
        return this.findVertexSequence((V)VectorList.of((Object[])new Object[]{start}), (V)((Predicate<Object>)goal::equals), maxDepth, costLimit, visited);
    }

    default public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequence(@NonNull V start, @NonNull V goal, int maxDepth, @NonNull C costLimit) {
        return this.findVertexSequence((V)VectorList.of((Object[])new Object[]{start}), (V)((Predicate<Object>)goal::equals), maxDepth, costLimit, (AddToSet<V>)((AddToSet<Object>)new HashSet()::add));
    }

    default public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequence(@NonNull V start, @NonNull V goal, @NonNull C costLimit) {
        return this.findVertexSequence((V)VectorList.of((Object[])new Object[]{start}), (V)((Predicate<Object>)goal::equals), Integer.MAX_VALUE, costLimit, (AddToSet<V>)((AddToSet<Object>)new HashSet()::add));
    }

    public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequenceOverWaypoints(@NonNull Iterable<V> var1, int var2, @NonNull C var3, @NonNull Supplier<AddToSet<V>> var4);

    default public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequenceOverWaypoints(@NonNull Iterable<V> waypoints, int maxDepth, @NonNull C costLimit) {
        return this.findVertexSequenceOverWaypoints(waypoints, maxDepth, costLimit, () -> new HashSet()::add);
    }

    default public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequenceOverWaypoints(@NonNull Iterable<V> waypoints, @NonNull C costLimit) {
        return this.findVertexSequenceOverWaypoints(waypoints, Integer.MAX_VALUE, costLimit, () -> new HashSet()::add);
    }

    public static <VV, CC extends Number> @Nullable SimpleOrderedPair<ImmutableList<VV>, CC> findVertexSequenceOverWaypoints(@NonNull Iterable<VV> waypoints, @NonNull BiFunction<VV, VV, OrderedPair<ImmutableList<VV>, CC>> findVertexSequenceFunction, @NonNull CC zero, @NonNull BiFunction<CC, CC, CC> sumFunction) {
        ArrayList sequence = new ArrayList();
        Object prev = null;
        Object sum = zero;
        int count = 0;
        for (VV next : waypoints) {
            if (prev != null) {
                OrderedPair<ImmutableList<VV>, CC> result = findVertexSequenceFunction.apply(prev, next);
                if (result == null) {
                    return null;
                }
                List nextSequence = ((ImmutableList)result.first()).asList();
                sequence.addAll(sequence.isEmpty() ? nextSequence : nextSequence.subList(1, nextSequence.size()));
                sum = (Number)sumFunction.apply(sum, (Number)result.second());
            }
            prev = next;
            ++count;
        }
        if (count == 1) {
            return new SimpleOrderedPair((Object)VectorList.of((Object[])new Object[]{prev}), zero);
        }
        return new SimpleOrderedPair((Object)VectorList.copyOf(sequence), sum);
    }
}

