/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.algo;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.collection.enumerator.AbstractEnumerator;
import org.jhotdraw8.collection.pair.OrderedPair;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.path.algo.AlgoArguments;
import org.jhotdraw8.graph.path.algo.CheckedNonNegativeArcCostFunction3;
import org.jhotdraw8.graph.path.backlink.ArcBackLinkWithCost;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class AllWalksSpliterator<V, A, C extends Number, E>
extends AbstractEnumerator<OrderedPair<ImmutableList<E>, C>> {
    private final @NonNull Queue<ArcBackLinkWithCost<V, A, C>> queue = new ArrayDeque<ArcBackLinkWithCost<V, A, C>>();
    private final @NonNull Predicate<V> goalPredicate;
    private final int maxDepth;
    private final @NonNull C maxCost;
    private final @NonNull Function3<V, V, A, C> costFunction;
    private final @NonNull BiFunction<C, C, C> sumFunction;
    private final @NonNull Function<V, Iterable<Arc<V, A>>> nextArcsFunction;
    private final @NonNull Function<ArcBackLinkWithCost<V, A, C>, OrderedPair<ImmutableList<E>, C>> sequenceFunction;

    public AllWalksSpliterator(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, @NonNull Function<V, Iterable<Arc<V, A>>> nextArcsFunction, @NonNull Function<ArcBackLinkWithCost<V, A, C>, OrderedPair<ImmutableList<E>, C>> sequenceFunction, int maxDepth, @NonNull C maxCost, @NonNull C zero, @NonNull Function3<V, V, A, C> costFunction, @NonNull BiFunction<C, C, C> sumFunction) {
        super(Long.MAX_VALUE, 0);
        AlgoArguments.checkMaxDepthMaxCostArguments(maxDepth, zero, maxCost);
        this.maxDepth = maxDepth;
        this.maxCost = maxCost;
        this.goalPredicate = goalPredicate;
        this.nextArcsFunction = nextArcsFunction;
        this.sequenceFunction = sequenceFunction;
        this.costFunction = new CheckedNonNegativeArcCostFunction3<V, A, C>(zero, costFunction);
        this.sumFunction = sumFunction;
        for (V start : startVertices) {
            this.queue.add(new ArcBackLinkWithCost<V, Object, C>(start, null, null, zero));
        }
    }

    public boolean moveNext() {
        while (!this.queue.isEmpty()) {
            ArcBackLinkWithCost<V, A, C> u = this.queue.remove();
            if (this.goalPredicate.test(u.getVertex())) {
                this.current = this.sequenceFunction.apply(u);
                return true;
            }
            if (u.getDepth() >= this.maxDepth) continue;
            for (Arc<V, A> v : this.nextArcsFunction.apply(u.getVertex())) {
                Number cost = (Number)this.sumFunction.apply(u.getCost(), (Number)this.costFunction.apply(u.getVertex(), v.getEnd(), v.getArrow()));
                if (((Comparable)((Object)cost)).compareTo(this.maxCost) > 0) continue;
                ArcBackLinkWithCost<V, A, Number> newNode = new ArcBackLinkWithCost<V, A, Number>(v.getEnd(), v.getArrow(), u, cost);
                this.queue.add(newNode);
            }
        }
        return false;
    }
}

