/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.algo;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.algo.AlgoArguments;
import org.jhotdraw8.graph.path.algo.ArcPathSearchAlgo;
import org.jhotdraw8.graph.path.backlink.ArcBackLink;
import org.jhotdraw8.graph.path.backlink.ArcBackLinkWithCost;

public class AnyArcPathSearchAlgo<V, A, C extends Number>
implements ArcPathSearchAlgo<V, A, C> {
    @Override
    public @Nullable ArcBackLinkWithCost<V, A, C> search(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, @NonNull Function<V, Iterable<Arc<V, A>>> nextArcsFunction, int maxDepth, @NonNull C zero, @NonNull C costLimit, @NonNull Function3<V, V, A, C> costFunction, @NonNull BiFunction<C, C, C> sumFunction, @NonNull AddToSet<V> visited) {
        AlgoArguments.checkZero(zero);
        return ArcBackLink.toArcBackLinkWithCost(this.search(startVertices, goalPredicate, nextArcsFunction, new HashSet()::add, maxDepth), zero, costFunction, sumFunction);
    }

    public @Nullable ArcBackLink<V, A> search(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, @NonNull Function<V, Iterable<Arc<V, A>>> nextArcsFunction, @NonNull AddToSet<V> visited, int maxDepth) {
        AlgoArguments.checkMaxDepth(maxDepth);
        ArrayDeque<ArcBackLink<V, A>> queue = new ArrayDeque<ArcBackLink<V, A>>(16);
        for (V s : startVertices) {
            ArcBackLink<V, Object> rootBackLink = new ArcBackLink<V, Object>(s, null, null);
            if (!visited.add(s)) continue;
            queue.add(rootBackLink);
        }
        while (!queue.isEmpty()) {
            ArcBackLink u = (ArcBackLink)queue.remove();
            if (goalPredicate.test(u.getVertex())) {
                return u;
            }
            if (u.getDepth() >= maxDepth) continue;
            for (Arc<V, A> v : nextArcsFunction.apply(u.getVertex())) {
                if (!visited.add(v.getEnd())) continue;
                queue.add(new ArcBackLink<V, A>(v.getEnd(), v.getArrow(), u));
            }
        }
        return null;
    }
}

