/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.algo;

import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.algo.AlgoArguments;
import org.jhotdraw8.graph.path.algo.ArcPathSearchAlgo;
import org.jhotdraw8.graph.path.algo.CheckedNonNegativeArcCostFunction3;
import org.jhotdraw8.graph.path.backlink.AbstractBackLink;
import org.jhotdraw8.graph.path.backlink.AbstractBackLinkWithCost;
import org.jhotdraw8.graph.path.backlink.ArcBackLinkWithCost;

public class AnyShortestArcPathSearchAlgo<V, A, C extends Number>
implements ArcPathSearchAlgo<V, A, C> {
    @Override
    public @Nullable ArcBackLinkWithCost<V, A, C> search(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, @NonNull Function<V, Iterable<Arc<V, A>>> nextArcsFunction, int maxDepth, @NonNull C zero, @NonNull C costLimit, @NonNull Function3<V, V, A, C> costFunction, @NonNull BiFunction<C, C, C> sumFunction, @NonNull AddToSet<V> visited) {
        AlgoArguments.checkMaxDepthMaxCostArguments(maxDepth, zero, costLimit);
        CheckedNonNegativeArcCostFunction3<V, A, C> costf = new CheckedNonNegativeArcCostFunction3<V, A, C>(zero, costFunction);
        PriorityQueue<ArcBackLinkWithCost> queue = new PriorityQueue<ArcBackLinkWithCost>(Comparator.comparing(AbstractBackLinkWithCost::getCost).thenComparing(AbstractBackLink::getDepth));
        HashMap<V, Object> costMap = new HashMap<V, Object>();
        for (V start : startVertices) {
            queue.add(new ArcBackLinkWithCost<V, Object, C>(start, null, null, zero));
            costMap.put(start, zero);
        }
        while (!queue.isEmpty()) {
            ArcBackLinkWithCost u = (ArcBackLinkWithCost)queue.remove();
            if (goalPredicate.test(u.getVertex())) {
                return u;
            }
            if (u.getDepth() >= maxDepth) continue;
            for (Arc<V, A> arc : nextArcsFunction.apply(u.getVertex())) {
                V v = arc.getEnd();
                Number bestKnownCost = (Number)costMap.get(v);
                Number cost = (Number)sumFunction.apply(u.getCost(), costf.apply(u.getVertex(), (Object)v, (Object)arc.getArrow()));
                if (bestKnownCost != null && ((Comparable)((Object)cost)).compareTo(bestKnownCost) >= 0 || ((Comparable)((Object)cost)).compareTo(costLimit) > 0) continue;
                costMap.put(v, cost);
                queue.add(new ArcBackLinkWithCost<V, A, Number>(v, arc.getArrow(), u, cost));
            }
        }
        return null;
    }
}

