/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.algo;

import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.algo.AlgoArguments;
import org.jhotdraw8.graph.path.algo.VertexPathSearchAlgo;
import org.jhotdraw8.graph.path.backlink.VertexBackLink;
import org.jhotdraw8.graph.path.backlink.VertexBackLinkWithCost;

public class UniqueOnAcyclicGraphVertexPathSearchAlgo<V, C extends Number>
implements VertexPathSearchAlgo<V, C> {
    @Override
    public @Nullable VertexBackLinkWithCost<V, C> search(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, @NonNull Function<V, Iterable<V>> nextVerticesFunction, int maxDepth, @NonNull C zero, @NonNull C costLimit, @NonNull BiFunction<V, V, C> costFunction, @NonNull BiFunction<C, C, C> sumFunction, @NonNull AddToSet<V> visited) {
        AlgoArguments.checkZero(zero);
        return VertexBackLink.toVertexBackLinkWithCost(this.search(startVertices, goalPredicate, nextVerticesFunction, maxDepth), zero, costFunction, sumFunction);
    }

    public @Nullable VertexBackLink<V> search(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, @NonNull Function<V, Iterable<V>> nextVerticesFunction, int maxDepth) {
        AlgoArguments.checkMaxDepth(maxDepth);
        ArrayDeque<VertexBackLink<V>> queue = new ArrayDeque<VertexBackLink<V>>(16);
        LinkedHashMap<V, Integer> visitedCount = new LinkedHashMap<V, Integer>(16);
        for (V s : startVertices) {
            if (visitedCount.put(s, 1) != null) continue;
            queue.add(new VertexBackLink<V>(s, null));
        }
        VertexBackLink found = null;
        while (!queue.isEmpty()) {
            VertexBackLink u = (VertexBackLink)queue.remove();
            if (goalPredicate.test(u.getVertex())) {
                if (found != null) {
                    return null;
                }
                found = u;
            }
            if (u.getDepth() >= maxDepth) continue;
            for (V v : nextVerticesFunction.apply(u.getVertex())) {
                if (visitedCount.merge(v, 1, Integer::sum) != 1) continue;
                queue.add(new VertexBackLink<V>(v, u));
            }
        }
        for (VertexBackLink node = found; node != null; node = (VertexBackLink)node.getParent()) {
            if ((Integer)visitedCount.get(node.getVertex()) <= 1) continue;
            return null;
        }
        return found;
    }
}

