/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.backlink;

import java.util.ArrayDeque;
import java.util.function.BiFunction;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.graph.path.backlink.AbstractBackLink;
import org.jhotdraw8.graph.path.backlink.VertexBackLinkWithCost;

public class VertexBackLink<V>
extends AbstractBackLink<VertexBackLink<V>> {
    private final @NonNull V vertex;

    public VertexBackLink(@NonNull V vertex, @Nullable VertexBackLink<V> parent) {
        super(parent);
        this.vertex = vertex;
    }

    public @NonNull V getVertex() {
        return this.vertex;
    }

    public static <VV, CC extends Number> @Nullable VertexBackLinkWithCost<VV, CC> toVertexBackLinkWithCost(@Nullable VertexBackLink<VV> node, @NonNull CC zero, @NonNull BiFunction<VV, VV, CC> costFunction, @NonNull BiFunction<CC, CC, CC> sumFunction) {
        if (node == null) {
            return null;
        }
        ArrayDeque<VertexBackLink> deque = new ArrayDeque<VertexBackLink>();
        for (VertexBackLink n = node; n != null; n = (VertexBackLink)n.getParent()) {
            deque.addFirst(n);
        }
        VertexBackLinkWithCost newNode = null;
        for (VertexBackLink n : deque) {
            newNode = new VertexBackLinkWithCost(n.getVertex(), newNode, newNode == null ? zero : (Number)sumFunction.apply(newNode.getCost(), (Number)costFunction.apply(newNode.getVertex(), n.getVertex())));
        }
        return newNode;
    }
}

