/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.graph.IndexedDirectedGraph;

public interface AttributedIndexedDirectedGraph<V, A>
extends IndexedDirectedGraph {
    public A getArrow(int var1);

    public @NonNull V getVertex(int var1);

    public int getVertexIndex(V var1);

    public A getNextArrow(int var1, int var2);

    default public @NonNull Collection<Map.Entry<Integer, A>> getNextIntEntries(final int vertexIndex) {
        return new AbstractCollection<Map.Entry<Integer, A>>(){

            @Override
            public @NonNull Iterator<Map.Entry<Integer, A>> iterator() {
                class NextVertexAndArrowIterator
                implements Iterator<Map.Entry<Integer, A>> {
                    private int index;
                    private final int vertex;
                    private final int nextCount;

                    public NextVertexAndArrowIterator(int vertex) {
                        this.vertex = vertex;
                        this.nextCount = AttributedIndexedDirectedGraph.this.getNextCount(vertex);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < this.nextCount;
                    }

                    @Override
                    public  @NonNull Map.Entry<Integer, A> next() {
                        int i = this.index++;
                        return new AbstractMap.SimpleEntry(AttributedIndexedDirectedGraph.this.getNextAsInt(this.vertex, i), AttributedIndexedDirectedGraph.this.getNextArrow(this.vertex, i));
                    }
                }
                return new NextVertexAndArrowIterator(vertexIndex);
            }

            @Override
            public int size() {
                return AttributedIndexedDirectedGraph.this.getNextCount(vertexIndex);
            }
        };
    }
}

