/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.Collection;
import java.util.HashSet;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.collection.enumerator.Enumerator;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.BareBidiGraph;
import org.jhotdraw8.graph.DirectedGraph;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.iterator.BfsDfsVertexSpliterator;
import org.jhotdraw8.icollection.facade.ListFacade;

public interface BidiGraph<V, A>
extends DirectedGraph<V, A>,
BareBidiGraph<V, A> {
    default public @NonNull Collection<A> getPrevArrows(@NonNull V v) {
        return new ListFacade(() -> this.getPrevCount(v), i -> this.getPrevArrow(v, i));
    }

    default public @NonNull Collection<V> getPrevVertices(@NonNull V v) {
        return new ListFacade(() -> this.getPrevCount(v), i -> this.getPrev(v, i));
    }

    default public @NonNull Arc<V, A> getPrevArc(@NonNull V v, int i) {
        return new Arc(this.getPrev(v, i), v, this.getPrevArrow(v, i));
    }

    default public @NonNull Collection<Arc<V, A>> getPrevArcs(@NonNull V v) {
        return new ListFacade(() -> this.getPrevCount(v), i -> this.getPrevArc(v, i));
    }

    default public int findIndexOfPrev(@NonNull V v, @NonNull V u) {
        int n = this.getPrevCount(v);
        for (int i = 0; i < n; ++i) {
            if (!u.equals(this.getPrev(v, i))) continue;
            return i;
        }
        return -1;
    }

    default public boolean isPrev(@NonNull V v, @NonNull V u) {
        return this.findIndexOfPrev(v, u) >= 0;
    }

    default public @NonNull Enumerator<V> searchPrevVertices(@NonNull V start, boolean dfs) {
        HashSet visited = new HashSet();
        return this.searchPrevVertices(start, visited::add, dfs);
    }

    default public @NonNull Enumerator<V> searchPrevVertices(@NonNull V start, @NonNull AddToSet<V> visited, boolean dfs) {
        return new BfsDfsVertexSpliterator<Object>(this::getPrevVertices, start, visited, dfs);
    }
}

