/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.collection.enumerator.AbstractEnumerator;
import org.jhotdraw8.collection.enumerator.Enumerator;
import org.jhotdraw8.collection.util.ListHelper;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.DirectedGraph;
import org.jhotdraw8.graph.MutableBidiGraph;

public class SimpleMutableBidiGraph<V, A>
implements MutableBidiGraph<V, A> {
    private final @NonNull Map<V, Node<V, A>> nodeMap;
    private @Nullable List<V> cachedVertices = null;
    private int arrowCount = 0;

    public SimpleMutableBidiGraph() {
        this(10, 10);
    }

    public SimpleMutableBidiGraph(int initialVertexCapacity, int initialArrowCapacity) {
        this.nodeMap = new LinkedHashMap<V, Node<V, A>>(initialVertexCapacity * 2);
    }

    public SimpleMutableBidiGraph(@NonNull DirectedGraph<V, A> g) {
        this.nodeMap = new LinkedHashMap<V, Node<V, A>>(g.getVertexCount() * 2);
        for (Object v : g.getVertices()) {
            this.addVertex(v);
        }
        for (Object v : this.nodeMap.keySet()) {
            for (Arc<V, A> arc : g.getNextArcs(v)) {
                this.addArrow(arc.getStart(), arc.getEnd(), arc.getArrow());
            }
        }
    }

    @Override
    public void addVertex(@NonNull V v) {
        if (this.nodeMap.containsKey(v)) {
            return;
        }
        this.nodeMap.put(v, new Node(v));
        this.cachedVertices = null;
    }

    @Override
    public void removeVertex(@NonNull V v) {
        Node<V, A> node = this.nodeMap.remove(v);
        if (node == null) {
            return;
        }
        int oldArrowCount = this.arrowCount;
        Enumerator i = node.next.nodesEnumerator();
        while (i.moveNext()) {
            Node next = (Node)i.current();
            next.prev.remove(node);
            --this.arrowCount;
        }
        i = node.prev.nodesEnumerator();
        while (i.moveNext()) {
            Node prev = (Node)i.current();
            prev.next.remove(node);
            --this.arrowCount;
        }
        node.next.clear();
        node.prev.clear();
        this.cachedVertices = null;
    }

    @Override
    public void addArrow(@NonNull V v, @NonNull V u, @Nullable A a) {
        Node<V, A> vNode = this.getNodeNonNull(v);
        Node<V, A> uNode = this.getNodeNonNull(u);
        vNode.next.add(uNode, a);
        uNode.prev.add(vNode, a);
        ++this.arrowCount;
    }

    @Override
    public void removeArrow(@NonNull V v, @NonNull V u, @Nullable A a) {
        Node<V, A> vNode = this.getNodeNonNull(v);
        Node<V, A> uNode = this.getNodeNonNull(u);
        if (!vNode.next.remove(uNode, a)) {
            throw new IllegalStateException("arrow v=" + String.valueOf(v) + " u=" + String.valueOf(u) + " a=" + String.valueOf(a) + " is not in graph");
        }
        if (!uNode.prev.remove(vNode, a)) {
            throw new IllegalStateException("arrow v=" + String.valueOf(v) + " u=" + String.valueOf(u) + " a=" + String.valueOf(a) + " is not in graph");
        }
        --this.arrowCount;
    }

    @Override
    public void removeArrow(@NonNull V v, @NonNull V u) {
        Node<V, A> vNode = this.getNodeNonNull(v);
        Node<V, A> uNode = this.getNodeNonNull(u);
        if (!vNode.next.remove(uNode)) {
            throw new IllegalStateException("arrow v=" + String.valueOf(v) + " u=" + String.valueOf(u) + " is not in graph");
        }
        if (!uNode.prev.remove(vNode)) {
            throw new IllegalStateException("arrow v=" + String.valueOf(v) + " u=" + String.valueOf(u) + " is not in graph");
        }
        --this.arrowCount;
    }

    private @NonNull Node<V, A> getNodeNonNull(@NonNull V v) {
        Node<V, A> node = this.nodeMap.get(v);
        if (node == null) {
            throw new IllegalArgumentException("vertex " + String.valueOf(v) + " is not in graph");
        }
        return node;
    }

    @Override
    public void removeNext(@NonNull V v, int k) {
        Node<V, A> vNode = this.getNodeNonNull(v);
        Node uNode = vNode.next.getNode(k);
        Object uArrow = vNode.next.getArrow(k);
        vNode.next.removeAt(k);
        if (!uNode.prev.remove(vNode, uArrow)) {
            throw new IllegalStateException("arrow v=" + String.valueOf(v) + " k=" + k + " is not in graph");
        }
        --this.arrowCount;
    }

    @Override
    public @NonNull V getNext(@NonNull V v, int index) {
        Node<V, A> vNode = this.getNodeNonNull(v);
        return vNode.next.getVertex(index);
    }

    @Override
    public @Nullable A getNextArrow(@NonNull V v, int index) {
        Node<V, A> vNode = this.getNodeNonNull(v);
        return vNode.next.getArrow(index);
    }

    @Override
    public int getNextCount(@NonNull V v) {
        Node<V, A> vNode = this.getNodeNonNull(v);
        return vNode.next.size();
    }

    @Override
    public @NonNull V getVertex(int index) {
        if (this.cachedVertices == null) {
            this.cachedVertices = List.copyOf(this.nodeMap.keySet());
        }
        return this.cachedVertices.get(index);
    }

    @Override
    public @NonNull Set<V> getVertices() {
        return Collections.unmodifiableSet(this.nodeMap.keySet());
    }

    @Override
    public int getVertexCount() {
        return this.nodeMap.size();
    }

    @Override
    public int getArrowCount() {
        return this.arrowCount;
    }

    @Override
    public @NonNull V getPrev(@NonNull V vertex, int index) {
        Node<V, A> node = this.getNodeNonNull(vertex);
        return node.prev.getVertex(index);
    }

    @Override
    public @NonNull A getPrevArrow(@NonNull V vertex, int index) {
        Node<V, A> node = this.getNodeNonNull(vertex);
        return node.prev.getArrow(index);
    }

    @Override
    public int getPrevCount(@NonNull V vertex) {
        Node<V, A> node = this.getNodeNonNull(vertex);
        return node.prev.size();
    }

    private static class Node<V, A> {
        final AdjacencyList<V, A> next = new AdjacencyList();
        final AdjacencyList<V, A> prev = new AdjacencyList();
        final V vertex;

        public Node(V vertex) {
            this.vertex = vertex;
        }
    }

    private static class AdjacencyList<V, A> {
        private static final int ITEM_SIZE = 2;
        private static final int ITEM_NODE_OFFSET = 0;
        private static final int ITEM_ARROW_OFFSET = 1;
        private static final @NonNull Object[] EMPTY_ARRAY = new Object[0];
        private @NonNull Object[] items = EMPTY_ARRAY;
        private int size;

        public void add(Node<V, A> node, A a) {
            this.grow(this.size + 1);
            int index = this.size++;
            this.items[index * 2 + 0] = node;
            this.items[index * 2 + 1] = a;
        }

        public @NonNull Node<V, A> getNode(int index) {
            this.rangeCheck(index, this.size);
            Node unchecked = (Node)this.items[index * 2 + 0];
            return unchecked;
        }

        public V getVertex(int index) {
            return this.getNode((int)index).vertex;
        }

        public @NonNull A getArrow(int index) {
            this.rangeCheck(index, this.size);
            Object unchecked = this.items[index * 2 + 1];
            return (A)unchecked;
        }

        private @NonNull Enumerator<Node<V, A>> nodesEnumerator() {
            return new AbstractEnumerator<Node<V, A>>(this.size, 0){
                int index;
                {
                    super(arg0, arg1);
                    this.index = 0;
                }

                public boolean moveNext() {
                    if (this.index < size) {
                        this.current = this.getNode(this.index++);
                        return true;
                    }
                    return false;
                }
            };
        }

        private void rangeCheck(int index, int maxExclusive) throws IllegalArgumentException {
            if (index < 0 || index >= maxExclusive) {
                throw new IndexOutOfBoundsException("Index out of bounds " + index);
            }
        }

        public boolean remove(Node<V, A> n) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.getNode(i).equals(n)) continue;
                this.removeAt(i);
                return true;
            }
            return false;
        }

        public boolean remove(Node<V, A> n, A a) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.getNode(i).equals(n) || !this.getArrow(i).equals(a)) continue;
                this.removeAt(i);
                return true;
            }
            return false;
        }

        public void removeAt(int index) {
            this.rangeCheck(index, this.size);
            int numMoved = this.size - index - 1;
            if (numMoved > 0) {
                System.arraycopy(this.items, (index + 1) * 2, this.items, index * 2, numMoved * 2);
            }
            --this.size;
        }

        private void grow(int targetCapacity) {
            this.items = ListHelper.grow((int)targetCapacity, (int)2, (Object[])this.items);
        }

        public int size() {
            return this.size;
        }

        public void clear() {
            Arrays.fill(this.items, 0, this.size, null);
            this.size = 0;
        }
    }
}

