/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.Arrays;
import org.jhotdraw8.graph.GraphChunk;

public class SingleArrayCsrGraphChunk
implements GraphChunk {
    private static final boolean CLEAR_UNUSED_ELEMENTS = false;
    private static final int CLEAR_VALUE = 99;
    private final int vertexCount;
    private int capacity;
    private int free;
    private int gapIndex;
    private int gapSize;
    private int[] chunk;

    public SingleArrayCsrGraphChunk(int vertexCount, int initialArrowCapacity) {
        this.vertexCount = vertexCount;
        this.free = this.gapSize = initialArrowCapacity;
        this.capacity = this.gapSize;
        this.gapIndex = 0;
        this.chunk = new int[this.vertexCount * 2 + initialArrowCapacity * 2];
    }

    @Override
    public int indexOf(int v, int u) {
        int to;
        int from = this.getSiblingsFromOffset(v);
        int result = Arrays.binarySearch(this.chunk, from, to = from + this.getSiblingCount(v), u);
        return result < 0 ? result + from : result - from;
    }

    @Override
    public int[] getSiblingsArray() {
        return this.chunk;
    }

    @Override
    public int getSiblingCount(int v) {
        int vIndex = v & this.vertexCount - 1;
        int sizesOffset = this.getSizesOffset();
        return vIndex == 0 ? this.chunk[sizesOffset + vIndex] : this.chunk[sizesOffset + vIndex] - this.chunk[sizesOffset + vIndex - 1];
    }

    @Override
    public int getVertexData(int v) {
        int vIndex = v & this.vertexCount - 1;
        return this.chunk[vIndex];
    }

    @Override
    public void setVertexData(int v, int data) {
        int vIndex = v & this.vertexCount - 1;
        this.chunk[vIndex] = data;
    }

    @Override
    public int getArrow(int v, int k) {
        return this.chunk[this.getArrowsFromOffset(v) + k];
    }

    @Override
    public int getSiblingsFromOffset(int v) {
        int vIndex = v & this.vertexCount - 1;
        int siblingsOffset = this.getSiblingsFromOffset();
        return vIndex == 0 ? siblingsOffset : siblingsOffset + this.chunk[this.getSizesOffset() + vIndex - 1] + (vIndex <= this.gapIndex ? 0 : this.gapSize);
    }

    int getSiblingsToOffset(int v) {
        int vIndex = v & this.vertexCount - 1;
        return this.getSiblingsFromOffset() + this.chunk[this.getSizesOffset() + vIndex] + (vIndex <= this.gapIndex ? 0 : this.gapSize);
    }

    int getSiblingsFromOffset() {
        return this.vertexCount * 2;
    }

    @Override
    public int getSibling(int v, int k) {
        return this.chunk[this.getSiblingsFromOffset(v) + k];
    }

    int getSizesOffset() {
        return this.vertexCount;
    }

    int getArrowsFromOffset() {
        return this.vertexCount * 2 + this.capacity;
    }

    int getSiblingsToOffset() {
        return this.vertexCount * 2 + this.capacity - (this.gapIndex == this.vertexCount - 1 ? this.gapSize : 0);
    }

    int getArrowsFromOffset(int v) {
        int vIndex = v & this.vertexCount - 1;
        int arrowsOffset = this.getArrowsFromOffset();
        return vIndex == 0 ? arrowsOffset : arrowsOffset + this.chunk[this.getSizesOffset() + vIndex - 1] + (vIndex <= this.gapIndex ? 0 : this.gapSize);
    }

    int getArrowsToOffset(int v) {
        int vIndex = v & this.vertexCount - 1;
        return this.getArrowsFromOffset() + this.chunk[this.getSizesOffset() + vIndex] + (vIndex <= this.gapIndex ? 0 : this.gapSize);
    }

    @Override
    public boolean tryAddArrow(int v, int u, int data, boolean updateIfPresent) {
        int result = this.indexOf(v, u);
        if (result >= 0) {
            if (updateIfPresent) {
                this.setArrowAt(v, result, data);
            }
            return false;
        }
        if (this.free < 1) {
            this.grow();
        }
        int siblingsFrom = this.getSiblingsFromOffset(v);
        int siblingCount = this.getSiblingCount(v);
        int siblingsTo = siblingCount + siblingsFrom;
        int insertionIndex = ~result;
        int vIndex = v & this.vertexCount - 1;
        if (this.gapIndex < vIndex) {
            this.insertAfterGap(u, data, siblingsFrom, siblingsTo, insertionIndex);
        } else if (this.gapIndex > vIndex) {
            this.insertBeforeGap(u, data, siblingsFrom, siblingsTo, insertionIndex);
        } else {
            this.insertAtGap(u, data, siblingsFrom, siblingsTo, insertionIndex);
        }
        this.gapIndex = vIndex;
        --this.free;
        --this.gapSize;
        int sizesOffset = this.getSizesOffset();
        int i = sizesOffset + vIndex;
        int n = sizesOffset + this.vertexCount;
        while (i < n) {
            int n2 = i++;
            this.chunk[n2] = this.chunk[n2] + 1;
        }
        return true;
    }

    void setArrowAt(int v, int index, int data) {
        this.chunk[this.getArrowsFromOffset((int)v) + index] = data;
    }

    @Override
    public boolean tryRemoveArrow(int v, int u) {
        int result = this.indexOf(v, u);
        if (result < 0) {
            return false;
        }
        this.removeArrowAt(v, result);
        return true;
    }

    @Override
    public void removeAllArrows(int v) {
        int vIndex = v & this.vertexCount - 1;
        int size = this.getSiblingCount(vIndex);
        if (size == 0) {
            return;
        }
        int from = this.getSiblingsFromOffset(v);
        if (this.gapIndex > vIndex) {
            gapFrom = this.getSiblingsToOffset(this.gapIndex);
            int to = this.getSiblingsToOffset(v);
            System.arraycopy(this.chunk, to, this.chunk, to + this.gapSize, gapFrom - to);
            System.arraycopy(this.chunk, to + this.capacity, this.chunk, to + this.gapSize + this.capacity, gapFrom - to);
        } else if (this.gapIndex < vIndex) {
            gapFrom = this.getSiblingsToOffset(this.gapIndex);
            System.arraycopy(this.chunk, gapFrom + this.gapSize, this.chunk, gapFrom, from - gapFrom - this.gapSize);
            System.arraycopy(this.chunk, gapFrom + this.gapSize + this.capacity, this.chunk, gapFrom + this.capacity, from - gapFrom - this.gapSize);
            from -= this.gapSize;
        }
        int sizesOffset = this.getSizesOffset();
        int i = sizesOffset + vIndex;
        int n = sizesOffset + this.vertexCount;
        while (i < n) {
            int n2 = i++;
            this.chunk[n2] = this.chunk[n2] - size;
        }
        this.gapIndex = vIndex;
        this.gapSize += size;
        this.free += size;
    }

    @Override
    public int removeArrowAt(int v, int removalIndex) {
        int siblingsFrom = this.getSiblingsFromOffset(v);
        int siblingsTo = this.getSiblingCount(v) + siblingsFrom;
        int vIndex = v & this.vertexCount - 1;
        int u = this.chunk[siblingsFrom + removalIndex];
        if (this.gapIndex < vIndex) {
            this.removeAfterGap(siblingsFrom, siblingsTo, removalIndex);
        } else if (this.gapIndex > vIndex) {
            this.removeBeforeGap(siblingsFrom, siblingsTo, removalIndex);
        } else {
            this.removeAtGap(siblingsFrom, siblingsTo, removalIndex);
        }
        this.gapIndex = vIndex;
        ++this.free;
        ++this.gapSize;
        int sizesOffset = this.getSizesOffset();
        int i = sizesOffset + vIndex;
        int n = sizesOffset + this.vertexCount;
        while (i < n) {
            int n2 = i++;
            this.chunk[n2] = this.chunk[n2] - 1;
        }
        return u;
    }

    void grow() {
        int newCapacity = this.capacity * 2;
        if (newCapacity <= this.capacity) {
            throw new OutOfMemoryError("can not grow to newCapacity=" + newCapacity + ", current capacity=" + this.capacity);
        }
        int[] newChunk = new int[this.vertexCount * 2 + newCapacity * 2];
        int siblingsGapFromOffset = this.getSiblingsToOffset(this.gapIndex);
        int arrowsGapFromOffset = this.getArrowsToOffset(this.gapIndex);
        int siblingsGapToOffset = siblingsGapFromOffset + this.gapSize;
        int arrowsGapToOffset = arrowsGapFromOffset + this.gapSize;
        int arrowsFromOffset = this.getArrowsFromOffset();
        int deltaCapacity = newCapacity - this.capacity;
        System.arraycopy(this.chunk, 0, newChunk, 0, siblingsGapFromOffset);
        System.arraycopy(this.chunk, arrowsFromOffset, newChunk, arrowsFromOffset + deltaCapacity, this.getArrowsToOffset(this.gapIndex) - arrowsFromOffset);
        int length = this.getSiblingsToOffset() - siblingsGapToOffset;
        if (length > 0) {
            System.arraycopy(this.chunk, siblingsGapToOffset, newChunk, siblingsGapToOffset + deltaCapacity, length);
            System.arraycopy(this.chunk, arrowsGapToOffset, newChunk, arrowsGapToOffset + deltaCapacity * 2, length);
        }
        this.chunk = newChunk;
        this.free += deltaCapacity;
        this.capacity = newCapacity;
        this.gapSize += deltaCapacity;
    }

    void insertAtGap(int u, int data, int from, int to, int insertionIndex) {
        int arrowDataFrom = from + this.capacity;
        int length = to - from - insertionIndex;
        if (length > 0) {
            System.arraycopy(this.chunk, from + insertionIndex, this.chunk, from + insertionIndex + 1, length);
            System.arraycopy(this.chunk, arrowDataFrom + insertionIndex, this.chunk, arrowDataFrom + insertionIndex + 1, length);
        }
        this.chunk[from + insertionIndex] = u;
        this.chunk[arrowDataFrom + insertionIndex] = data;
    }

    void insertBeforeGap(int u, int data, int from, int to, int insertionIndex) {
        int siblingsStartOfGapOffset = this.getSiblingsToOffset(this.gapIndex);
        int length = siblingsStartOfGapOffset - to;
        System.arraycopy(this.chunk, to, this.chunk, to + this.free, length);
        System.arraycopy(this.chunk, to + this.capacity, this.chunk, to + this.capacity + this.free, length);
        length = to - from - insertionIndex;
        System.arraycopy(this.chunk, from + insertionIndex, this.chunk, from + insertionIndex + 1, length);
        System.arraycopy(this.chunk, from + this.capacity + insertionIndex, this.chunk, from + this.capacity + insertionIndex + 1, length);
        this.chunk[from + insertionIndex] = u;
        this.chunk[from + this.capacity + insertionIndex] = data;
    }

    void insertAfterGap(int u, int data, int from, int to, int insertionIndex) {
        int siblingsGapFrom = this.getSiblingsToOffset(this.gapIndex);
        int arrowsGapFrom = siblingsGapFrom + this.capacity;
        int length = from + insertionIndex - siblingsGapFrom - this.free;
        if (length > 0) {
            System.arraycopy(this.chunk, siblingsGapFrom + this.free, this.chunk, siblingsGapFrom, length);
            System.arraycopy(this.chunk, arrowsGapFrom + this.free, this.chunk, arrowsGapFrom, length);
        }
        int arrowDataFrom = from + this.capacity;
        this.chunk[from + insertionIndex - this.free] = u;
        this.chunk[arrowDataFrom + insertionIndex - this.free] = data;
        length = to - from - insertionIndex;
        System.arraycopy(this.chunk, from + insertionIndex, this.chunk, from + insertionIndex - this.free + 1, length);
        System.arraycopy(this.chunk, arrowDataFrom + insertionIndex, this.chunk, arrowDataFrom + insertionIndex - this.free + 1, length);
    }

    void removeAtGap(int from, int to, int removalIndex) {
        int length = to - removalIndex - from - 1;
        if (length > 0) {
            System.arraycopy(this.chunk, from + removalIndex + 1, this.chunk, from + removalIndex, length);
            System.arraycopy(this.chunk, from + this.capacity + removalIndex + 1, this.chunk, from + this.capacity + removalIndex, length);
        }
    }

    void removeBeforeGap(int from, int to, int removalIndex) {
        int gapFrom = this.getSiblingsToOffset(this.gapIndex);
        int length = gapFrom - to;
        System.arraycopy(this.chunk, to, this.chunk, to + this.free, length);
        System.arraycopy(this.chunk, to + this.capacity, this.chunk, to + this.capacity + this.free, length);
        length = to - from - removalIndex;
        System.arraycopy(this.chunk, from + removalIndex + 1, this.chunk, from + removalIndex, length);
        System.arraycopy(this.chunk, from + this.capacity + removalIndex + 1, this.chunk, from + this.capacity + removalIndex, length);
    }

    void removeAfterGap(int from, int to, int removalIndex) {
        int siblingsGapFrom = this.getSiblingsToOffset(this.gapIndex);
        int arrowsGapFrom = siblingsGapFrom + this.capacity;
        int length = from + removalIndex - siblingsGapFrom - this.gapSize;
        if (length > 0) {
            System.arraycopy(this.chunk, siblingsGapFrom + this.free, this.chunk, siblingsGapFrom, length);
            System.arraycopy(this.chunk, arrowsGapFrom + this.free, this.chunk, arrowsGapFrom, length);
        }
        length = to - from - removalIndex - 1;
        System.arraycopy(this.chunk, from + removalIndex + 1, this.chunk, from + removalIndex - this.free, length);
        System.arraycopy(this.chunk, from + this.capacity + removalIndex + 1, this.chunk, from + this.capacity + removalIndex - this.free, length);
    }
}

