/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.algo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.graph.DirectedGraph;
import org.jhotdraw8.graph.algo.MinimumSpanningTreeAlgo;

public class DisjointSetsAlgo {
    public <V, A> @NonNull List<Set<V>> findDisjointSets(@NonNull DirectedGraph<V, A> graph) {
        return this.findDisjointSets(graph.getVertices(), graph::getNextVertices);
    }

    public <V> @NonNull List<Set<V>> findDisjointSets(@NonNull Collection<V> vertices, @NonNull Function<V, Iterable<V>> getNextVertices) {
        Map<V, List<V>> forest = MinimumSpanningTreeAlgo.createForest(vertices);
        for (V u : vertices) {
            for (V v : getNextVertices.apply(u)) {
                List<V> vset;
                List<V> uset = forest.get(u);
                if (uset == (vset = forest.get(v))) continue;
                MinimumSpanningTreeAlgo.union(uset, vset, forest);
            }
        }
        Set visited = Collections.newSetFromMap(new IdentityHashMap(forest.size()));
        ArrayList<Set<V>> disjointSets = new ArrayList<Set<V>>(forest.size());
        for (List list : forest.values()) {
            if (!visited.add(list)) continue;
            disjointSets.add(new LinkedHashSet(list));
        }
        return disjointSets;
    }
}

