/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.io;

import java.io.IOException;
import java.io.StringWriter;
import java.util.function.Function;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.graph.DirectedGraph;

public class AdjacencyListWriter {
    public <V, A> String write(@NonNull DirectedGraph<V, A> graph) {
        StringWriter w = new StringWriter();
        try {
            this.write(w, graph, Object::toString);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return w.toString();
    }

    public <V, A> void write(@NonNull Appendable w, @NonNull DirectedGraph<V, A> graph) throws IOException {
        this.write(w, graph, Object::toString);
    }

    public <V, A> void write(@NonNull Appendable w, @NonNull DirectedGraph<V, A> graph, @NonNull Function<V, String> toStringFunction) throws IOException {
        int i = 0;
        for (Object v : graph.getVertices()) {
            if (i != 0) {
                w.append("\n");
            }
            w.append(toStringFunction.apply(v)).append(" -> ");
            int j = 0;
            for (V u : graph.getNextVertices(v)) {
                if (j != 0) {
                    w.append(", ");
                }
                w.append(toStringFunction.apply(u));
                ++j;
            }
            w.append('.');
            ++i;
        }
    }
}

