/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.collection.pair.OrderedPair;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.graph.MutableDirectedGraph;
import org.jhotdraw8.graph.SimpleMutableBidiGraph;

public class GraphvizReader<V, A> {
    private final @NonNull BiFunction<String, Map<String, String>, V> vertexFactory;
    private final @NonNull Function<Map<String, String>, A> arrowFactory;
    private final @NonNull Supplier<MutableDirectedGraph<V, A>> graphFactory;

    public GraphvizReader(@NonNull Function<String, V> vertexFactory, @NonNull Function<Map<String, String>, A> arrowFactory) {
        this.vertexFactory = (id, map) -> vertexFactory.apply((String)id);
        this.arrowFactory = arrowFactory;
        this.graphFactory = () -> new SimpleMutableBidiGraph(16, 16);
    }

    public GraphvizReader(@NonNull BiFunction<String, Map<String, String>, V> vertexFactory, @NonNull Function<Map<String, String>, A> arrowFactory, @NonNull Supplier<MutableDirectedGraph<V, A>> graphFactory) {
        this.vertexFactory = vertexFactory;
        this.arrowFactory = arrowFactory;
        this.graphFactory = graphFactory;
    }

    public static @NonNull GraphvizReader<String, String> newInstance() {
        return new GraphvizReader<String, String>((id, map) -> id, Object::toString, () -> new SimpleMutableBidiGraph(16, 16));
    }

    public MutableDirectedGraph<V, A> read(@NonNull Path file) throws IOException {
        try (BufferedReader r = Files.newBufferedReader(file);){
            MutableDirectedGraph<V, A> mutableDirectedGraph = this.read(r);
            return mutableDirectedGraph;
        }
    }

    public MutableDirectedGraph<V, A> read(@NonNull Reader r) throws IOException {
        MutableDirectedGraph<V, A> g = this.graphFactory.get();
        this.parseGraph(new StreamTokenizer(r), g, new LinkedHashMap());
        return g;
    }

    public MutableDirectedGraph<V, A> read(@NonNull String str) throws IOException {
        MutableDirectedGraph<V, A> g = this.graphFactory.get();
        try (StringReader r = new StringReader(str);){
            StreamTokenizer tt = new StreamTokenizer(r);
            tt.resetSyntax();
            tt.wordChars(97, 122);
            tt.wordChars(65, 90);
            tt.wordChars(160, 255);
            tt.whitespaceChars(0, 32);
            tt.commentChar(47);
            tt.quoteChar(34);
            tt.quoteChar(39);
            tt.wordChars(48, 57);
            tt.wordChars(46, 46);
            this.parseGraph(tt, g, new LinkedHashMap());
            MutableDirectedGraph<V, A> mutableDirectedGraph = g;
            return mutableDirectedGraph;
        }
    }

    private void parseGraph(@NonNull StreamTokenizer tt, @NonNull MutableDirectedGraph<V, A> g, @NonNull Map<String, V> vertices) throws IOException {
        if (tt.nextToken() != -3) {
            this.throwException(tt, "graph: `strict`, `graph` or expected `digraph`");
        }
        if (!"strict".equals(tt.sval)) {
            tt.pushBack();
        }
        if (tt.nextToken() != -3) {
            this.throwException(tt, "graph: `graph` or expected `digraph`");
        }
        if (!"graph".equals(tt.sval) && !"digraph".equals(tt.sval)) {
            this.throwException(tt, "graph: `graph` or expected `digraph`");
        }
        if (tt.nextToken() == -3) {
            id = tt.sval;
        } else {
            tt.pushBack();
            id = null;
        }
        if (tt.nextToken() != 123) {
            this.throwException(tt, "graph: expected `{`");
        }
        while (tt.nextToken() != 125 && tt.ttype != -1) {
            tt.pushBack();
            this.parseStmtLst(tt, g, vertices);
        }
        if (tt.ttype != 125) {
            this.throwException(tt, "graph: expected `}`");
        }
    }

    private void parseStmtLst(@NonNull StreamTokenizer tt, @NonNull MutableDirectedGraph<V, A> g, @NonNull Map<String, V> vertexMap) throws IOException {
        do {
            tt.pushBack();
            this.parseStmt(tt, g, vertexMap);
            if (tt.nextToken() != 59) continue;
            tt.nextToken();
        } while (tt.ttype != 125 && tt.ttype != -1);
        tt.pushBack();
    }

    private void parseStmt(@NonNull StreamTokenizer tt, @NonNull MutableDirectedGraph<V, A> g, @NonNull Map<String, V> vertexMap) throws IOException {
        Map<String, String> attrList;
        if (tt.nextToken() != 34 && tt.ttype != -3) {
            this.throwException(tt, "stmt: expected `node_id`");
        }
        String node_id = tt.sval;
        boolean isDefinitelyNodeStmt = false;
        boolean isDefinitelyEdgeStmt = false;
        if (tt.nextToken() == 91) {
            isDefinitelyNodeStmt = true;
            tt.pushBack();
            attrList = this.parseAttrList(tt, g);
        } else {
            tt.pushBack();
            attrList = null;
        }
        if (!vertexMap.containsKey(node_id)) {
            V vertex = this.vertexFactory.apply(node_id, attrList);
            vertexMap.put(node_id, vertex);
            g.addVertex(vertex);
        }
        if (!isDefinitelyNodeStmt && tt.nextToken() == 45) {
            isDefinitelyEdgeStmt = true;
            tt.pushBack();
            this.parseEdgeRhs(tt, g, node_id, vertexMap);
        }
    }

    private void parseEdgeRhs(@NonNull StreamTokenizer tt, @NonNull MutableDirectedGraph<V, A> g, @NonNull String node_id, @NonNull Map<String, V> vertexMap) throws IOException {
        ArrayList<SimpleOrderedPair> arrows = new ArrayList<SimpleOrderedPair>();
        do {
            String next_node_id;
            boolean isEdge;
            tt.pushBack();
            if (tt.nextToken() != 45) {
                this.throwException(tt, "edgeRHS: edgeop expected");
            }
            if (tt.nextToken() != 45 && tt.ttype != 62) {
                this.throwException(tt, "edgeRHS: `--` or `->` expected");
            }
            boolean bl = isEdge = tt.ttype == 45;
            if (tt.nextToken() != 34 && tt.ttype != -3) {
                this.throwException(tt, "edgeRHS: expected `node_id`");
            }
            if (!vertexMap.containsKey(next_node_id = tt.sval)) {
                V v = this.vertexFactory.apply(next_node_id, Collections.emptyMap());
                vertexMap.put(next_node_id, v);
                g.addVertex(v);
            }
            arrows.add(new SimpleOrderedPair((Object)node_id, (Object)next_node_id));
            if (isEdge) {
                arrows.add(new SimpleOrderedPair((Object)next_node_id, (Object)node_id));
            }
            node_id = next_node_id;
        } while (tt.nextToken() == 45);
        tt.pushBack();
        Map<String, String> attrList = null;
        if (tt.nextToken() == 91) {
            tt.pushBack();
            attrList = this.parseAttrList(tt, g);
        } else {
            tt.pushBack();
        }
        for (OrderedPair orderedPair : arrows) {
            g.addArrow(vertexMap.get(orderedPair.first()), vertexMap.get(orderedPair.second()), attrList == null ? null : (Object)this.arrowFactory.apply(attrList));
        }
    }

    private @NonNull Map<String, String> parseAttrList(@NonNull StreamTokenizer tt, @NonNull MutableDirectedGraph<V, A> g) throws IOException {
        LinkedHashMap<String, String> attrList = new LinkedHashMap<String, String>();
        if (tt.nextToken() != 91) {
            this.throwException(tt, "attr_list: expected `[`");
        }
        while (tt.nextToken() != 93 && tt.ttype != -1) {
            this.parseAList(tt, g, attrList);
        }
        return attrList;
    }

    private void parseAList(@NonNull StreamTokenizer tt, @NonNull MutableDirectedGraph<V, A> g, @NonNull Map<String, String> attrList) throws IOException {
        do {
            tt.pushBack();
            if (tt.nextToken() != 34 && tt.ttype != -3) {
                this.throwException(tt, "a_list: expected `ID`");
            }
            String key = tt.sval;
            if (tt.nextToken() != 61) {
                this.throwException(tt, "a_list: expected `=`");
            }
            if (tt.nextToken() != 34 && tt.ttype != -3) {
                this.throwException(tt, "a_list: expected `ID`");
            }
            String value = tt.sval;
            attrList.put(key, value);
            if (tt.nextToken() == 44 || tt.ttype == 59) continue;
            tt.pushBack();
        } while (tt.nextToken() == 34 || tt.ttype == -3);
        tt.pushBack();
    }

    private void throwException(StreamTokenizer tt, String message) throws IOException {
        throw new IOException(message + " but found " + String.valueOf(tt));
    }
}

