/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.collection.pair.OrderedPair;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.ArcSequenceFinder;
import org.jhotdraw8.graph.path.ArrowSequenceFinder;
import org.jhotdraw8.graph.path.CombinedSequenceFinder;
import org.jhotdraw8.graph.path.VertexSequenceFinder;
import org.jhotdraw8.graph.path.algo.ArcPathSearchAlgo;
import org.jhotdraw8.graph.path.backlink.ArcBackLinkWithCost;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class SimpleCombinedSequenceFinder<V, A, C extends Number>
implements CombinedSequenceFinder<V, A, C> {
    private final @NonNull C zero;
    private final @NonNull Function<V, Iterable<Arc<V, A>>> nextArcsFunction;
    private final @NonNull Function3<V, V, A, C> costFunction;
    private final @NonNull BiFunction<C, C, C> sumFunction;
    private final @NonNull ArcPathSearchAlgo<V, A, C> algo;

    public SimpleCombinedSequenceFinder(@NonNull C zero, @NonNull Function<V, Iterable<Arc<V, A>>> nextArcsFunction, @NonNull Function3<V, V, A, C> costFunction, @NonNull BiFunction<C, C, C> sumFunction, @NonNull ArcPathSearchAlgo<V, A, C> algo) {
        if (((Number)zero).doubleValue() != 0.0) {
            throw new IllegalArgumentException("zero(" + String.valueOf(zero) + ") is != 0");
        }
        this.zero = zero;
        this.nextArcsFunction = nextArcsFunction;
        this.costFunction = costFunction;
        this.sumFunction = sumFunction;
        this.algo = algo;
    }

    public static <VV, AA> @NonNull SimpleCombinedSequenceFinder<VV, AA, Integer> newIntCostInstance(@NonNull Function<VV, Iterable<Arc<VV, AA>>> nextArcsFunction, @NonNull Function3<VV, VV, AA, Integer> costFunction, @NonNull ArcPathSearchAlgo<VV, AA, Integer> algo) {
        return new SimpleCombinedSequenceFinder<VV, AA, Integer>(0, nextArcsFunction, costFunction, Integer::sum, algo);
    }

    public static <VV, AA> @NonNull SimpleCombinedSequenceFinder<VV, AA, Integer> newIntCostInstance(@NonNull Function<VV, Iterable<Arc<VV, AA>>> nextArcsFunction, @NonNull BiFunction<VV, VV, Integer> costFunction, @NonNull ArcPathSearchAlgo<VV, AA, Integer> algo) {
        return new SimpleCombinedSequenceFinder<VV, AA, Integer>(0, nextArcsFunction, (u, v, a) -> (Integer)costFunction.apply(u, v), Integer::sum, algo);
    }

    public static <VV, AA> @NonNull SimpleCombinedSequenceFinder<VV, AA, Integer> newIntCostInstance(@NonNull Function<VV, Iterable<Arc<VV, AA>>> nextArcsFunction, @NonNull ArcPathSearchAlgo<VV, AA, Integer> algo) {
        return new SimpleCombinedSequenceFinder<VV, AA, Integer>(0, nextArcsFunction, (u, v, a) -> 1, Integer::sum, algo);
    }

    public static <VV, AA> @NonNull SimpleCombinedSequenceFinder<VV, AA, Double> newDoubleCostInstance(@NonNull Function<VV, Iterable<Arc<VV, AA>>> nextArcsFunction, @NonNull Function3<VV, VV, AA, Double> costFunction, @NonNull ArcPathSearchAlgo<VV, AA, Double> algo) {
        return new SimpleCombinedSequenceFinder<VV, AA, Double>(0.0, nextArcsFunction, costFunction, Double::sum, algo);
    }

    public static <VV, AA> @NonNull SimpleCombinedSequenceFinder<VV, AA, Long> newLongCostInstance(@NonNull Function<VV, Iterable<Arc<VV, AA>>> nextArcsFunction, @NonNull Function3<VV, VV, AA, Long> costFunction, @NonNull ArcPathSearchAlgo<VV, AA, Long> algo) {
        return new SimpleCombinedSequenceFinder<VV, AA, Long>(0L, nextArcsFunction, costFunction, Long::sum, algo);
    }

    @Override
    public @Nullable OrderedPair<ImmutableList<Arc<V, A>>, C> findArcSequence(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, int maxDepth, @NonNull C costLimit, @NonNull AddToSet<V> visited) {
        return ArcBackLinkWithCost.toArrowSequence(this.algo.search(startVertices, goalPredicate, this.nextArcsFunction, maxDepth, this.zero, costLimit, this.costFunction, this.sumFunction, visited), (a, b) -> new Arc(a.getVertex(), b.getVertex(), b.getArrow()));
    }

    @Override
    public @Nullable OrderedPair<ImmutableList<Arc<V, A>>, C> findArcSequenceOverWaypoints(@NonNull Iterable<V> waypoints, int maxDepth, @NonNull C costLimit, @NonNull Supplier<AddToSet<V>> visitedSetFactory) {
        return ArcSequenceFinder.findArcSequenceOverWaypoints(waypoints, (start, goal) -> this.findArcSequence(start, goal, maxDepth, costLimit, (AddToSet)visitedSetFactory.get()), this.zero, this.sumFunction);
    }

    @Override
    public @Nullable SimpleOrderedPair<ImmutableList<A>, C> findArrowSequence(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, int maxDepth, @NonNull C costLimit, @NonNull AddToSet<V> visited) {
        return ArcBackLinkWithCost.toArrowSequence(this.algo.search(startVertices, goalPredicate, this.nextArcsFunction, maxDepth, this.zero, costLimit, this.costFunction, this.sumFunction, visited), (a, b) -> b.getArrow());
    }

    @Override
    public @Nullable SimpleOrderedPair<ImmutableList<A>, C> findArrowSequenceOverWaypoints(@NonNull Iterable<V> waypoints, int maxDepth, @NonNull C costLimit, @NonNull Supplier<AddToSet<V>> visitedSetFactory) {
        return ArrowSequenceFinder.findArrowSequenceOverWaypoints(waypoints, (start, goal) -> this.findArrowSequence(start, goal, maxDepth, costLimit, (AddToSet)visitedSetFactory.get()), this.zero, this.sumFunction);
    }

    @Override
    public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequence(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, int maxDepth, @NonNull C costLimit, @NonNull AddToSet<V> visited) {
        return ArcBackLinkWithCost.toVertexSequence(this.algo.search(startVertices, goalPredicate, this.nextArcsFunction, maxDepth, this.zero, costLimit, this.costFunction, this.sumFunction, visited), ArcBackLinkWithCost::getVertex);
    }

    @Override
    public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequenceOverWaypoints(@NonNull Iterable<V> waypoints, int maxDepth, @NonNull C costLimit, @NonNull Supplier<AddToSet<V>> visitedSetFactory) {
        return VertexSequenceFinder.findVertexSequenceOverWaypoints(waypoints, (start, goal) -> this.findVertexSequence(start, goal, maxDepth, costLimit, (AddToSet)visitedSetFactory.get()), this.zero, this.sumFunction);
    }
}

