/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.VertexSequenceFinder;
import org.jhotdraw8.graph.path.algo.VertexPathSearchAlgo;
import org.jhotdraw8.graph.path.backlink.VertexBackLinkWithCost;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class SimpleVertexSequenceFinder<V, C extends Number>
implements VertexSequenceFinder<V, C> {
    private final @NonNull C zero;
    private final @NonNull Function<V, Iterable<V>> nextVerticesFunction;
    private final @NonNull BiFunction<V, V, C> costFunction;
    private final @NonNull BiFunction<C, C, C> sumFunction;
    private final @NonNull VertexPathSearchAlgo<V, C> algo;

    public SimpleVertexSequenceFinder(@NonNull C zero, @NonNull Function<V, Iterable<V>> nextVerticesFunction, @NonNull BiFunction<V, V, C> costFunction, @NonNull BiFunction<C, C, C> sumFunction, @NonNull VertexPathSearchAlgo<V, C> algo) {
        this.zero = zero;
        this.nextVerticesFunction = nextVerticesFunction;
        this.costFunction = costFunction;
        this.sumFunction = sumFunction;
        this.algo = algo;
    }

    public static <VV> @NonNull SimpleVertexSequenceFinder<VV, Integer> newIntCostInstance(@NonNull Function<VV, Iterable<VV>> nextVerticesFunction, @NonNull BiFunction<VV, VV, Integer> costFunction, @NonNull VertexPathSearchAlgo<VV, Integer> algo) {
        return new SimpleVertexSequenceFinder<VV, Integer>(0, nextVerticesFunction, costFunction, Integer::sum, algo);
    }

    public static <VV> @NonNull SimpleVertexSequenceFinder<VV, Integer> newIntCostInstance(@NonNull Function<VV, Iterable<VV>> nextVerticesFunction, @NonNull VertexPathSearchAlgo<VV, Integer> algo) {
        return new SimpleVertexSequenceFinder<Object, Integer>(0, nextVerticesFunction, (u, v) -> 1, Integer::sum, algo);
    }

    public static <VV> @NonNull SimpleVertexSequenceFinder<VV, Long> newLongCostInstance(@NonNull Function<VV, Iterable<VV>> nextVerticesFunction, @NonNull BiFunction<VV, VV, Long> costFunction, @NonNull VertexPathSearchAlgo<VV, Long> algo) {
        return new SimpleVertexSequenceFinder<VV, Long>(0L, nextVerticesFunction, costFunction, Long::sum, algo);
    }

    @Override
    public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequence(@NonNull Iterable<V> startVertices, @NonNull Predicate<V> goalPredicate, int maxDepth, @NonNull C costLimit, @NonNull AddToSet<V> visited) {
        return VertexBackLinkWithCost.toVertexSequence(this.algo.search(startVertices, goalPredicate, this.nextVerticesFunction, maxDepth, this.zero, costLimit, this.costFunction, this.sumFunction, visited), VertexBackLinkWithCost::getVertex);
    }

    @Override
    public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequenceOverWaypoints(@NonNull Iterable<V> waypoints, int maxDepth, @NonNull C costLimit, @NonNull Supplier<AddToSet<V>> visitedSetFactory) {
        return VertexSequenceFinder.findVertexSequenceOverWaypoints(waypoints, (start, goal) -> this.findVertexSequence(start, goal, maxDepth, costLimit, (AddToSet)visitedSetFactory.get()), this.zero, this.sumFunction);
    }
}

