/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.backlink;

import java.util.ArrayDeque;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.graph.path.backlink.AbstractBackLinkWithCost;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class ArcBackLinkWithCost<V, A, C extends Number>
extends AbstractBackLinkWithCost<ArcBackLinkWithCost<V, A, C>, C> {
    private final @NonNull V vertex;
    private final @Nullable A arrow;

    public ArcBackLinkWithCost(@NonNull V vertex, @Nullable A arrow, @Nullable ArcBackLinkWithCost<V, A, C> parent, @NonNull C cost) {
        super(parent, cost);
        this.vertex = vertex;
        this.arrow = arrow;
    }

    public static <VV, AA, CC extends Number, XX> @Nullable SimpleOrderedPair<ImmutableList<XX>, CC> toVertexSequence(@Nullable ArcBackLinkWithCost<VV, AA, CC> node, @NonNull Function<ArcBackLinkWithCost<VV, AA, CC>, XX> mappingFunction) {
        if (node == null) {
            return null;
        }
        ArrayDeque<XX> deque = new ArrayDeque<XX>();
        for (ArcBackLinkWithCost parent = node; parent != null; parent = (ArcBackLinkWithCost)parent.getParent()) {
            deque.addFirst(mappingFunction.apply(parent));
        }
        return new SimpleOrderedPair((Object)VectorList.copyOf(deque), node.getCost());
    }

    public static <VV, AA, CC extends Number, XX> @Nullable SimpleOrderedPair<ImmutableList<XX>, CC> toArrowSequence(@Nullable ArcBackLinkWithCost<VV, AA, CC> node, @NonNull BiFunction<ArcBackLinkWithCost<VV, AA, CC>, ArcBackLinkWithCost<VV, AA, CC>, XX> mappingFunction) {
        if (node == null) {
            return null;
        }
        ArrayDeque<XX> deque = new ArrayDeque<XX>();
        ArcBackLinkWithCost prev = node;
        for (ArcBackLinkWithCost parent = (ArcBackLinkWithCost)node.getParent(); parent != null; parent = (ArcBackLinkWithCost)parent.getParent()) {
            deque.addFirst(mappingFunction.apply(parent, prev));
            prev = parent;
        }
        return new SimpleOrderedPair((Object)VectorList.copyOf(deque), node.getCost());
    }

    public @Nullable A getArrow() {
        return this.arrow;
    }

    public @NonNull V getVertex() {
        return this.vertex;
    }
}

