/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.backlink;

import java.util.ArrayDeque;
import java.util.function.Function;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.graph.path.backlink.AbstractBackLinkWithCost;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class IndexedVertexBackLinkWithCost<C extends Number>
extends AbstractBackLinkWithCost<IndexedVertexBackLinkWithCost<C>, C> {
    final int vertex;

    public IndexedVertexBackLinkWithCost(int vertex, @Nullable IndexedVertexBackLinkWithCost<C> parent, @NonNull C cost) {
        super(parent, cost);
        this.vertex = vertex;
    }

    public int getVertex() {
        return this.vertex;
    }

    public static <XX, CC extends Number> @Nullable SimpleOrderedPair<ImmutableList<XX>, CC> toVertexSequence(@Nullable IndexedVertexBackLinkWithCost<CC> node, @NonNull Function<IndexedVertexBackLinkWithCost<CC>, XX> mappingFunction) {
        if (node == null) {
            return null;
        }
        ArrayDeque<XX> deque = new ArrayDeque<XX>();
        for (IndexedVertexBackLinkWithCost parent = node; parent != null; parent = (IndexedVertexBackLinkWithCost)parent.getParent()) {
            deque.addFirst(mappingFunction.apply(parent));
        }
        return new SimpleOrderedPair((Object)VectorList.copyOf(deque), node.getCost());
    }
}

