/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.backlink;

import java.util.ArrayDeque;
import java.util.function.BiFunction;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.graph.path.backlink.AbstractBackLink;
import org.jhotdraw8.graph.path.backlink.VertexBackLinkWithCost;
import org.jhotdraw8.icollection.ChampAddOnlySet;

public class VertexBackLinkWithAncestorSet<V>
extends AbstractBackLink<VertexBackLinkWithAncestorSet<V>> {
    private final @NonNull V vertex;
    private @Nullable ChampAddOnlySet<V> ancestors;

    public VertexBackLinkWithAncestorSet(@NonNull V vertex, @Nullable VertexBackLinkWithAncestorSet<V> parent, @NonNull ChampAddOnlySet<V> ancestors) {
        super(parent);
        this.vertex = vertex;
        this.ancestors = ancestors;
    }

    public static <VV, CC extends Number> @Nullable VertexBackLinkWithCost<VV, CC> toVertexBackLinkWithCost(@Nullable VertexBackLinkWithAncestorSet<VV> node, @NonNull CC zero, @NonNull BiFunction<VV, VV, CC> costFunction, @NonNull BiFunction<CC, CC, CC> sumFunction) {
        if (node == null) {
            return null;
        }
        ArrayDeque<VertexBackLinkWithAncestorSet> deque = new ArrayDeque<VertexBackLinkWithAncestorSet>();
        for (VertexBackLinkWithAncestorSet n = node; n != null; n = (VertexBackLinkWithAncestorSet)n.getParent()) {
            deque.addFirst(n);
        }
        VertexBackLinkWithCost newNode = null;
        for (VertexBackLinkWithAncestorSet n : deque) {
            newNode = new VertexBackLinkWithCost(n.getVertex(), newNode, newNode == null ? zero : (Number)sumFunction.apply(newNode.getCost(), (Number)costFunction.apply(newNode.getVertex(), n.getVertex())));
        }
        return newNode;
    }

    public @NonNull ChampAddOnlySet<V> removeAncestors() {
        if (this.ancestors == null) {
            throw new IllegalStateException("ancestors already removed");
        }
        ChampAddOnlySet<V> ancestors = this.ancestors;
        this.ancestors = null;
        return ancestors;
    }

    public @NonNull V getVertex() {
        return this.vertex;
    }
}

