/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.Arrays;
import java.util.Objects;
import org.jhotdraw8.collection.enumerator.Enumerator;
import org.jhotdraw8.collection.primitive.IntArrayList;
import org.jhotdraw8.graph.IndexedBidiGraph;
import org.jhotdraw8.graph.IndexedDirectedGraph;

public abstract class AbstractMutableIndexedBidiGraph
implements IndexedBidiGraph {
    private Node[] nodes = new Node[0];
    private int vertexCount;
    private int arrowCount;

    public AbstractMutableIndexedBidiGraph() {
    }

    public AbstractMutableIndexedBidiGraph(int vertexCount) {
        this.buildAddVertices(vertexCount);
    }

    public AbstractMutableIndexedBidiGraph(IndexedDirectedGraph g) {
        this.buildAddVertices(g.getVertexCount());
        for (int v = 0; v < this.vertexCount; ++v) {
            Enumerator.OfInt it = g.nextVerticesEnumerator(v);
            while (it.moveNext()) {
                this.buildAddArrow(v, it.currentAsInt());
            }
        }
    }

    protected void buildAddVertex() {
        ++this.vertexCount;
        if (this.nodes.length < this.vertexCount) {
            this.nodes = Arrays.copyOf(this.nodes, this.vertexCount * 2);
        }
    }

    protected void buildAddVertices(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count: " + count);
        }
        this.vertexCount += count;
        if (this.nodes.length < this.vertexCount) {
            this.nodes = Arrays.copyOf(this.nodes, this.vertexCount * 2);
        }
    }

    protected void buildRemoveVertex(int vidx) {
        Objects.checkIndex(vidx, this.vertexCount);
        Node vnode = this.nodes[vidx];
        this.arrowCount -= vnode.next.size();
        if (vidx < this.vertexCount - 1) {
            System.arraycopy(this.nodes, vidx + 1, this.nodes, vidx, this.vertexCount - vidx);
        }
        this.nodes[this.vertexCount - 1] = null;
        --this.vertexCount;
        for (Node node : this.nodes) {
            int uidx;
            int j;
            if (node == null) continue;
            for (j = node.next.size() - 1; j >= 0; --j) {
                uidx = node.next.getAsInt(j);
                if (uidx == vidx) {
                    node.next.removeAtAsInt(j);
                    --this.arrowCount;
                    continue;
                }
                if (uidx <= vidx) continue;
                node.next.setAsInt(j, uidx - 1);
            }
            for (j = node.prev.size() - 1; j >= 0; --j) {
                uidx = node.prev.getAsInt(j);
                if (uidx == vidx) {
                    node.prev.removeAtAsInt(j);
                    continue;
                }
                if (uidx <= vidx) continue;
                node.prev.setAsInt(j, uidx - 1);
            }
            if (!node.isNodeEmpty()) continue;
            this.nodes[i] = null;
        }
    }

    protected void buildAddArrow(int vidx, int uidx) {
        Node node = this.nodes[vidx];
        if (node == null) {
            node = this.nodes[vidx] = new Node();
        }
        node.next.addAsInt(uidx);
        node = this.nodes[uidx];
        if (node == null) {
            node = this.nodes[uidx] = new Node();
        }
        node.prev.addAsInt(vidx);
        ++this.arrowCount;
    }

    protected void buildRemoveArrow(int vidx, int uidx) {
        Node node = this.nodes[vidx];
        if (node == null) {
            throw new IndexOutOfBoundsException("vidx=" + vidx);
        }
        this.buildRemoveArrowAt(vidx, node.next.indexOfAsInt(uidx));
    }

    protected void buildRemoveArrowAt(int vidx, int i) {
        Node unode;
        Node vnode = this.nodes[vidx];
        if (vnode == null) {
            throw new IndexOutOfBoundsException("vidx=" + vidx + ", i=" + i);
        }
        int uidx = vnode.next.removeAtAsInt(i);
        if (vnode.isNodeEmpty()) {
            this.nodes[vidx] = null;
        }
        if ((unode = this.nodes[uidx]) == null) {
            throw new IndexOutOfBoundsException("vidx=" + vidx + ", i=" + i);
        }
        unode.prev.removeAtAsInt(unode.prev.indexOfAsInt(vidx));
        if (unode.isNodeEmpty()) {
            this.nodes[uidx] = null;
        }
        --this.arrowCount;
    }

    @Override
    public int getArrowCount() {
        return this.arrowCount;
    }

    @Override
    public int getNextAsInt(int v, int index) {
        Node node = this.nodes[v];
        if (node == null) {
            throw new IndexOutOfBoundsException("vidx=" + v + ", k=" + index);
        }
        return node.next.getAsInt(index);
    }

    @Override
    public int getNextCount(int v) {
        Node node = this.nodes[v];
        return node == null ? 0 : node.next.size();
    }

    @Override
    public int getPrevAsInt(int v, int i) {
        Node node = this.nodes[v];
        if (node == null) {
            throw new IndexOutOfBoundsException("vidx=" + v + ", i=" + i);
        }
        return node.prev.getAsInt(i);
    }

    @Override
    public int getPrevCount(int v) {
        Node node = this.nodes[v];
        return node == null ? 0 : node.prev.size();
    }

    @Override
    public int getVertexCount() {
        return this.vertexCount;
    }

    private static class Node
    extends IntArrayList {
        private final IntArrayList next = this;
        private final IntArrayList prev = new IntArrayList();

        private Node() {
        }

        private boolean isNodeEmpty() {
            return this.next.isEmpty() && this.prev.isEmpty();
        }
    }
}

