/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.Collection;
import java.util.HashSet;
import org.jhotdraw8.collection.enumerator.Enumerator;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.BareBidiGraph;
import org.jhotdraw8.graph.DirectedGraph;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.iterator.BfsDfsVertexSpliterator;
import org.jhotdraw8.icollection.facade.ListFacade;

public interface BidiGraph<V, A>
extends DirectedGraph<V, A>,
BareBidiGraph<V, A> {
    default public Collection<A> getPrevArrows(V v) {
        return new ListFacade(() -> this.getPrevCount(v), i -> this.getPrevArrow(v, i));
    }

    default public Collection<V> getPrevVertices(V v) {
        return new ListFacade(() -> this.getPrevCount(v), i -> this.getPrev(v, i));
    }

    default public Arc<V, A> getPrevArc(V v, int i) {
        return new Arc(this.getPrev(v, i), v, this.getPrevArrow(v, i));
    }

    default public Collection<Arc<V, A>> getPrevArcs(V v) {
        return new ListFacade(() -> this.getPrevCount(v), i -> this.getPrevArc(v, i));
    }

    default public int findIndexOfPrev(V v, V u) {
        int n = this.getPrevCount(v);
        for (int i = 0; i < n; ++i) {
            if (!u.equals(this.getPrev(v, i))) continue;
            return i;
        }
        return -1;
    }

    default public boolean isPrev(V v, V u) {
        return this.findIndexOfPrev(v, u) >= 0;
    }

    default public Enumerator<V> searchPrevVertices(V start, boolean dfs) {
        HashSet visited = new HashSet();
        return this.searchPrevVertices(start, visited::add, dfs);
    }

    default public Enumerator<V> searchPrevVertices(V start, AddToSet<V> visited, boolean dfs) {
        return new BfsDfsVertexSpliterator<Object>(this::getPrevVertices, start, visited, dfs);
    }
}

