/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jhotdraw8.collection.enumerator.Enumerator;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.BareDirectedGraph;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.iterator.BfsDfsVertexSpliterator;
import org.jhotdraw8.icollection.facade.ListFacade;
import org.jspecify.annotations.Nullable;

public interface DirectedGraph<V, A>
extends BareDirectedGraph<V, A> {
    default public @Nullable A findArrow(V u, V v) {
        int index = this.findIndexOfNext(u, v);
        return index < 0 ? null : (A)this.getNextArrow(u, index);
    }

    default public int findIndexOfNext(V v, V u) {
        int n = this.getNextCount(v);
        for (int i = 0; i < n; ++i) {
            if (!u.equals(this.getNext(v, i))) continue;
            return i;
        }
        return -1;
    }

    default public Collection<V> getNextVertices(V v) {
        return new ListFacade(() -> this.getNextCount(v), i -> this.getNext(v, i));
    }

    default public Arc<V, A> getNextArc(V v, int i) {
        return new Arc(v, this.getNext(v, i), this.getNextArrow(v, i));
    }

    default public Collection<A> getNextArrows(V v) {
        return new ListFacade(() -> this.getNextCount(v), i -> this.getNextArrow(v, i));
    }

    default public Collection<Arc<V, A>> getNextArcs(V v) {
        return new ListFacade(() -> this.getNextCount(v), i -> this.getNextArc(v, i));
    }

    default public int getVertexCount() {
        return this.getVertices().size();
    }

    public int getArrowCount();

    default public Collection<A> getArrows(V v1, V v2) {
        int n = this.getNextCount(v1);
        ArrayList arrows = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            if (!this.getNext(v1, i).equals(v2)) continue;
            arrows.add(this.getNextArrow(v1, i));
        }
        return Collections.unmodifiableList(arrows);
    }

    default public Collection<A> getArrows() {
        ArrayList arrows = new ArrayList(this.getArrowCount());
        for (Object v1 : this.getVertices()) {
            int n = this.getNextCount(v1);
            for (int i = 0; i < n; ++i) {
                arrows.add(this.getNextArrow(v1, i));
            }
        }
        return Collections.unmodifiableList(arrows);
    }

    default public boolean isNext(V v, V u) {
        return this.findIndexOfNext(v, u) != -1;
    }

    public V getVertex(int var1);

    default public Enumerator<V> searchNextVertices(V start, boolean dfs) {
        HashSet visited = new HashSet();
        return this.searchNextVertices(start, visited::add, dfs);
    }

    default public Enumerator<V> searchNextVertices(V start, AddToSet<V> visited, boolean dfs) {
        return new BfsDfsVertexSpliterator<Object>(this::getNextVertices, start, visited, dfs);
    }
}

