/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jhotdraw8.collection.enumerator.Enumerator;
import org.jhotdraw8.collection.enumerator.IntArrayEnumerator;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.AttributedIndexedBidiGraph;
import org.jhotdraw8.graph.BidiGraph;

public class ImmutableAttributed32BitIndexedBidiGraph<V, A>
implements AttributedIndexedBidiGraph<V, A>,
BidiGraph<V, A> {
    protected final int[] next;
    protected final int[] prev;
    protected final int[] nextOffset;
    protected final int[] prevOffset;
    protected final A[] nextArrows;
    protected final A[] prevArrows;
    protected final V[] vertices;
    protected final Map<V, Integer> vertexToIndexMap;

    public ImmutableAttributed32BitIndexedBidiGraph(AttributedIndexedBidiGraph<V, A> graph) {
        int arrowCount = graph.getArrowCount();
        int vertexCount = graph.getVertexCount();
        this.next = new int[arrowCount];
        this.prev = new int[arrowCount];
        Object[] uncheckedNextArrows = new Object[arrowCount];
        this.nextArrows = uncheckedNextArrows;
        Object[] uncheckedPrevArrows = new Object[arrowCount];
        this.prevArrows = uncheckedPrevArrows;
        this.nextOffset = new int[vertexCount];
        this.prevOffset = new int[vertexCount];
        Object[] uncheckedVertices = new Object[vertexCount];
        this.vertices = uncheckedVertices;
        this.vertexToIndexMap = new HashMap<V, Integer>(vertexCount);
        int nextOffset = 0;
        int prevOffset = 0;
        for (int vi = 0; vi < vertexCount; ++vi) {
            int i;
            this.nextOffset[vi] = nextOffset;
            Object v = graph.getVertex(vi);
            this.vertices[vi] = v;
            this.vertexToIndexMap.put((Integer)v, vi);
            int n = graph.getNextCount(vi);
            for (i = 0; i < n; ++i) {
                this.next[nextOffset] = graph.getNextAsInt(vi, i);
                this.nextArrows[nextOffset] = graph.getNextArrow(vi, i);
                ++nextOffset;
            }
            n = graph.getPrevCount(vi);
            for (i = 0; i < n; ++i) {
                this.prev[prevOffset] = graph.getPrevAsInt(vi, i);
                this.prevArrows[prevOffset] = graph.getPrevArrow(vi, i);
                ++prevOffset;
            }
        }
    }

    public ImmutableAttributed32BitIndexedBidiGraph(BidiGraph<V, A> graph) {
        int arrowCount = graph.getArrowCount();
        int vertexCount = graph.getVertexCount();
        this.next = new int[arrowCount];
        this.prev = new int[arrowCount];
        Object[] uncheckedArrows = new Object[arrowCount];
        this.nextArrows = uncheckedArrows;
        Object[] uncheckedPrevArrows = new Object[arrowCount];
        this.prevArrows = uncheckedPrevArrows;
        this.nextOffset = new int[vertexCount];
        this.prevOffset = new int[vertexCount];
        Object[] uncheckedVertices = new Object[vertexCount];
        this.vertices = uncheckedVertices;
        this.vertexToIndexMap = new HashMap<V, Integer>(vertexCount);
        int vi = 0;
        for (Object v : graph.getVertices()) {
            this.vertexToIndexMap.put((Integer)v, vi);
            ++vi;
        }
        int nextOffset = 0;
        int prevOffset = 0;
        int vi2 = 0;
        for (Object v : graph.getVertices()) {
            this.nextOffset[vi2] = nextOffset;
            this.vertices[vi2] = v;
            for (Arc arc : graph.getNextArcs(v)) {
                this.next[nextOffset] = this.vertexToIndexMap.get(arc.getEnd());
                this.nextArrows[nextOffset] = arc.getArrow();
                ++nextOffset;
            }
            for (Arc arc : graph.getPrevArcs(v)) {
                this.prev[prevOffset] = this.vertexToIndexMap.get(arc.getStart());
                this.prevArrows[prevOffset] = arc.getArrow();
                ++prevOffset;
            }
            ++vi2;
        }
    }

    @Override
    public A getArrow(int index) {
        return this.nextArrows[index];
    }

    public A getArrow(int vertex, int index) {
        return this.nextArrows[this.getArrowIndex(vertex, index)];
    }

    @Override
    public int getArrowCount() {
        return this.next.length;
    }

    protected int getArrowIndex(int vi, int i) {
        if (i < 0 || i >= this.getNextCount(vi)) {
            throw new IllegalArgumentException("i(" + i + ") < 0 || i >= " + this.getNextCount(vi));
        }
        return this.nextOffset[vi] + i;
    }

    @Override
    public V getNext(V v, int i) {
        return this.vertices[this.getNextAsInt(this.vertexToIndexMap.get(v), i)];
    }

    @Override
    public A getNextArrow(int v, int i) {
        int length = this.getNextCount(v);
        Objects.checkIndex(i, length);
        return this.nextArrows[this.nextOffset[v] + i];
    }

    @Override
    public A getNextArrow(V v, int i) {
        return this.getNextArrow((V)this.getVertexIndex(v), i);
    }

    @Override
    public int getNextAsInt(int v, int i) {
        int length = this.getNextCount(v);
        Objects.checkIndex(i, length);
        return this.next[this.nextOffset[v] + i];
    }

    @Override
    public int getNextArrowAsInt(int v, int i) {
        return this.getNextAsInt(v, i);
    }

    @Override
    public int getNextCount(int v) {
        int offset = this.nextOffset[v];
        int offset2 = v == this.nextOffset.length - 1 ? this.nextOffset.length : this.nextOffset[v + 1];
        return offset2 - offset;
    }

    @Override
    public int getNextCount(V v) {
        return this.getNextCount(this.vertexToIndexMap.get(v));
    }

    @Override
    public V getPrev(V vertex, int i) {
        return this.vertices[this.getPrevAsInt(this.vertexToIndexMap.get(vertex), i)];
    }

    @Override
    public A getPrevArrow(int vi, int i) {
        int length = this.getPrevCount(vi);
        Objects.checkIndex(i, length);
        return this.prevArrows[this.prevOffset[vi] + i];
    }

    @Override
    public A getPrevArrow(V v, int i) {
        return this.getPrevArrow((V)this.getVertexIndex(v), i);
    }

    @Override
    public int getPrevAsInt(int v, int i) {
        int length = this.getPrevCount(v);
        Objects.checkIndex(i, length);
        return this.prev[this.prevOffset[v] + i];
    }

    @Override
    public int getPrevArrowAsInt(int v, int i) {
        return this.getPrevAsInt(v, i);
    }

    @Override
    public int getPrevCount(V vertex) {
        return this.getPrevCount(this.vertexToIndexMap.get(vertex));
    }

    @Override
    public int getPrevCount(int v) {
        int offset = this.prevOffset[v];
        int offset2 = v == this.prevOffset.length - 1 ? this.prevOffset.length : this.prevOffset[v + 1];
        return offset2 - offset;
    }

    @Override
    public V getVertex(int index) {
        return this.vertices[index];
    }

    @Override
    public int getVertexCount() {
        return this.nextOffset.length;
    }

    @Override
    public int getVertexIndex(V vertex) {
        Integer index = this.vertexToIndexMap.get(vertex);
        return index == null ? -1 : index;
    }

    @Override
    public Set<V> getVertices() {
        return Collections.unmodifiableSet(this.vertexToIndexMap.keySet());
    }

    @Override
    public Enumerator.OfInt nextVerticesEnumerator(int v) {
        int offset = this.nextOffset[v];
        int nextOffset = v == this.nextOffset.length - 1 ? this.next.length : this.nextOffset[v + 1];
        return new IntArrayEnumerator(this.next, offset, nextOffset);
    }
}

