/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jhotdraw8.collection.enumerator.Enumerator;
import org.jhotdraw8.collection.enumerator.IntArrayEnumerator;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.AttributedIndexedDirectedGraph;
import org.jhotdraw8.graph.DirectedGraph;

public class ImmutableAttributed32BitIndexedDirectedGraph<V, A>
implements AttributedIndexedDirectedGraph<V, A>,
DirectedGraph<V, A> {
    protected final int[] next;
    protected final int[] nextOffset;
    protected final A[] nextArrows;
    protected final V[] vertices;
    protected final Map<V, Integer> vertexToIndexMap;

    public ImmutableAttributed32BitIndexedDirectedGraph(AttributedIndexedDirectedGraph<V, A> graph) {
        int arrowCount = graph.getArrowCount();
        int vertexCount = graph.getVertexCount();
        this.next = new int[arrowCount];
        Object[] uncheckedArrows = new Object[arrowCount];
        this.nextArrows = uncheckedArrows;
        this.nextOffset = new int[vertexCount];
        Object[] uncheckedVertices = new Object[vertexCount];
        this.vertices = uncheckedVertices;
        this.vertexToIndexMap = new HashMap<V, Integer>(vertexCount);
        int offset = 0;
        for (int vi = 0; vi < vertexCount; ++vi) {
            this.nextOffset[vi] = offset;
            V v = graph.getVertex(vi);
            this.vertices[vi] = v;
            this.vertexToIndexMap.put((Integer)v, vi);
            int n = graph.getNextCount(vi);
            for (int i = 0; i < n; ++i) {
                this.next[offset] = graph.getNextAsInt(vi, i);
                this.nextArrows[offset] = graph.getNextArrow(vi, i);
                ++offset;
            }
        }
    }

    public ImmutableAttributed32BitIndexedDirectedGraph(DirectedGraph<V, A> graph) {
        int arrowCapacity = graph.getArrowCount();
        int vertexCapacity = graph.getVertexCount();
        this.next = new int[arrowCapacity];
        Object[] uncheckedArrows = new Object[arrowCapacity];
        this.nextArrows = uncheckedArrows;
        this.nextOffset = new int[vertexCapacity];
        Object[] uncheckedVertices = new Object[vertexCapacity];
        this.vertices = uncheckedVertices;
        this.vertexToIndexMap = new HashMap<V, Integer>(vertexCapacity);
        int vi = 0;
        for (Object v : graph.getVertices()) {
            this.vertexToIndexMap.put((Integer)v, vi);
            ++vi;
        }
        int offset = 0;
        int vi2 = 0;
        for (Object v : graph.getVertices()) {
            this.nextOffset[vi2] = offset;
            this.vertices[vi2] = v;
            for (Arc<V, A> arc : graph.getNextArcs(v)) {
                this.next[offset] = this.vertexToIndexMap.get(arc.getEnd());
                this.nextArrows[offset] = arc.getArrow();
                ++offset;
            }
            ++vi2;
        }
    }

    @Override
    public A getArrow(int index) {
        return this.nextArrows[index];
    }

    public A getArrow(int vertex, int index) {
        return this.nextArrows[this.getArrowIndex(vertex, index)];
    }

    @Override
    public int getArrowCount() {
        return this.next.length;
    }

    protected int getArrowIndex(int vi, int i) {
        if (i < 0 || i >= this.getNextCount(vi)) {
            throw new IllegalArgumentException("i(" + i + ") < 0 || i >= " + this.getNextCount(vi));
        }
        return this.nextOffset[vi] + i;
    }

    @Override
    public V getNext(V v, int i) {
        return this.vertices[this.getNextAsInt(this.vertexToIndexMap.get(v), i)];
    }

    @Override
    public A getNextArrow(int v, int i) {
        if (i < 0 || i >= this.getNextCount(v)) {
            throw new IllegalArgumentException("i(" + i + ") < 0 || i >= " + this.getNextCount(v));
        }
        return this.nextArrows[this.nextOffset[v] + i];
    }

    @Override
    public int getNextArrowAsInt(int v, int i) {
        return this.getNextAsInt(v, i);
    }

    @Override
    public A getNextArrow(V v, int i) {
        return this.getNextArrow((V)this.getVertexIndex(v), i);
    }

    @Override
    public int getNextAsInt(int v, int i) {
        if (i < 0 || i >= this.getNextCount(v)) {
            throw new IllegalArgumentException("i(" + i + ") < 0 || i >= " + this.getNextCount(v));
        }
        return this.next[this.nextOffset[v] + i];
    }

    @Override
    public int getNextCount(int v) {
        int offset = this.nextOffset[v];
        int nextOffset = v == this.nextOffset.length - 1 ? this.next.length : this.nextOffset[v + 1];
        return nextOffset - offset;
    }

    @Override
    public int getNextCount(V v) {
        return this.getNextCount(this.vertexToIndexMap.get(v));
    }

    @Override
    public V getVertex(int index) {
        return this.vertices[index];
    }

    @Override
    public int getVertexCount() {
        return this.nextOffset.length;
    }

    @Override
    public int getVertexIndex(V vertex) {
        Integer index = this.vertexToIndexMap.get(vertex);
        return index == null ? -1 : index;
    }

    @Override
    public Set<V> getVertices() {
        return Collections.unmodifiableSet(this.vertexToIndexMap.keySet());
    }

    @Override
    public Enumerator.OfInt nextVerticesEnumerator(int v) {
        int offset = this.nextOffset[v];
        int nextOffset = v == this.nextOffset.length - 1 ? this.next.length : this.nextOffset[v + 1];
        return new IntArrayEnumerator(this.next, offset, nextOffset);
    }
}

