/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.Arrays;
import org.jhotdraw8.graph.GraphChunk;

public class MultiArrayCsrGraphChunk
implements GraphChunk {
    private static final boolean CLEAR_UNUSED_ELEMENTS = false;
    private static final int CLEAR_VALUE = 99;
    private final int vertexCount;
    private int capacity;
    private int free;
    private int gapIndex;
    private int gapSize;
    private final int[] vertices;
    private final int[] sizes;
    private int[] siblings;
    private int[] arrows;

    public MultiArrayCsrGraphChunk(int vertexCount, int initialArrowCapacity) {
        this.vertexCount = vertexCount;
        this.free = this.gapSize = initialArrowCapacity;
        this.capacity = this.gapSize;
        this.gapIndex = 0;
        this.vertices = new int[vertexCount];
        this.sizes = new int[vertexCount];
        this.siblings = new int[initialArrowCapacity];
        this.arrows = new int[initialArrowCapacity];
    }

    @Override
    public int indexOf(int v, int u) {
        int to;
        int from = this.getSiblingsFromOffset(v);
        int result = Arrays.binarySearch(this.siblings, from, to = from + this.getSiblingCount(v), u);
        return result < 0 ? result + from : result - from;
    }

    @Override
    public int[] getSiblingsArray() {
        return this.siblings;
    }

    @Override
    public int getSiblingCount(int v) {
        int vIndex = v & this.vertexCount - 1;
        return vIndex == 0 ? this.sizes[vIndex] : this.sizes[vIndex] - this.sizes[vIndex - 1];
    }

    @Override
    public int getVertexData(int v) {
        return this.vertices[v & this.vertexCount - 1];
    }

    @Override
    public void setVertexData(int v, int data) {
        this.vertices[v & this.vertexCount - 1] = data;
    }

    @Override
    public int getArrow(int v, int k) {
        return this.arrows[this.getArrowsFromOffset(v) + k];
    }

    @Override
    public int getSiblingsFromOffset(int v) {
        int vIndex = v & this.vertexCount - 1;
        return vIndex == 0 ? 0 : this.sizes[vIndex - 1] + (vIndex <= this.gapIndex ? 0 : this.gapSize);
    }

    int getSiblingsToOffset(int v) {
        int vIndex = v & this.vertexCount - 1;
        return this.sizes[vIndex] + (vIndex <= this.gapIndex ? 0 : this.gapSize);
    }

    @Override
    public int getSibling(int v, int k) {
        return this.siblings[this.getSiblingsFromOffset(v) + k];
    }

    int getArrowsFromOffset(int v) {
        int vIndex = v & this.vertexCount - 1;
        return vIndex == 0 ? 0 : this.sizes[vIndex - 1] + (vIndex <= this.gapIndex ? 0 : this.gapSize);
    }

    int getSiblingsToOffset() {
        return this.capacity - (this.gapIndex == this.vertexCount - 1 ? this.gapSize : 0);
    }

    @Override
    public boolean tryAddArrow(int v, int u, int data, boolean updateIfPresent) {
        int result = this.indexOf(v, u);
        if (result >= 0) {
            if (updateIfPresent) {
                this.setArrowAt(v, result, data);
            }
            return false;
        }
        if (this.free < 1) {
            this.grow();
        }
        int from = this.getSiblingsFromOffset(v);
        int siblingCount = this.getSiblingCount(v);
        int to = siblingCount + from;
        int insertionIndex = ~result;
        int vIndex = v & this.vertexCount - 1;
        if (this.gapIndex < vIndex) {
            this.insertAfterGap(u, data, from, to, insertionIndex);
        } else if (this.gapIndex > vIndex) {
            this.insertBeforeGap(u, data, from, to, insertionIndex);
        } else {
            this.insertAtGap(u, data, from, to, insertionIndex);
        }
        this.gapIndex = vIndex;
        --this.free;
        --this.gapSize;
        int i = vIndex;
        int n = this.vertexCount;
        while (i < n) {
            int n2 = i++;
            this.sizes[n2] = this.sizes[n2] + 1;
        }
        return true;
    }

    void setArrowAt(int v, int index, int data) {
        this.arrows[this.getArrowsFromOffset((int)v) + index] = data;
    }

    @Override
    public boolean tryRemoveArrow(int v, int u) {
        int result = this.indexOf(v, u);
        if (result < 0) {
            return false;
        }
        this.removeArrowAt(v, result);
        return true;
    }

    @Override
    public void removeAllArrows(int v) {
        int vIndex = v & this.vertexCount - 1;
        int size = this.getSiblingCount(vIndex);
        if (size == 0) {
            return;
        }
        int from = this.getSiblingsFromOffset(v);
        if (this.gapIndex > vIndex) {
            gapFrom = this.getSiblingsToOffset(this.gapIndex);
            int to = this.getSiblingsToOffset(v);
            System.arraycopy(this.siblings, to, this.siblings, to + this.gapSize, gapFrom - to);
            System.arraycopy(this.arrows, to, this.arrows, to + this.gapSize, gapFrom - to);
        } else if (this.gapIndex < vIndex) {
            gapFrom = this.getSiblingsToOffset(this.gapIndex);
            System.arraycopy(this.siblings, gapFrom + this.gapSize, this.siblings, gapFrom, from - gapFrom - this.gapSize);
            System.arraycopy(this.arrows, gapFrom + this.gapSize, this.arrows, gapFrom, from - gapFrom - this.gapSize);
            from -= this.gapSize;
        }
        int i = vIndex;
        int n = this.vertexCount;
        while (i < n) {
            int n2 = i++;
            this.sizes[n2] = this.sizes[n2] - size;
        }
        this.gapIndex = vIndex;
        this.gapSize += size;
        this.free += size;
    }

    @Override
    public int removeArrowAt(int v, int removalIndex) {
        int from = this.getSiblingsFromOffset(v);
        int to = this.getSiblingCount(v) + from;
        int vIndex = v & this.vertexCount - 1;
        int u = this.siblings[from + removalIndex];
        if (this.gapIndex < vIndex) {
            this.removeAfterGap(from, to, removalIndex);
        } else if (this.gapIndex > vIndex) {
            this.removeBeforeGap(from, to, removalIndex);
        } else {
            this.removeAtGap(from, to, removalIndex);
        }
        this.gapIndex = vIndex;
        ++this.free;
        ++this.gapSize;
        int i = vIndex;
        int n = this.vertexCount;
        while (i < n) {
            int n2 = i++;
            this.sizes[n2] = this.sizes[n2] - 1;
        }
        return u;
    }

    void grow() {
        int newCapacity = this.capacity * 2;
        if (newCapacity <= this.capacity) {
            throw new OutOfMemoryError("can not grow to newCapacity=" + newCapacity + ", current capacity=" + this.capacity);
        }
        int[] newSiblings = new int[newCapacity];
        int[] newArrows = new int[newCapacity];
        int gapFromOffset = this.getSiblingsToOffset(this.gapIndex);
        int gapToOffset = gapFromOffset + this.gapSize;
        int deltaCapacity = newCapacity - this.capacity;
        System.arraycopy(this.siblings, 0, newSiblings, 0, gapFromOffset);
        System.arraycopy(this.arrows, 0, newArrows, 0, gapFromOffset);
        int length = this.getSiblingsToOffset() - gapToOffset;
        if (length > 0) {
            System.arraycopy(this.siblings, gapToOffset, newSiblings, gapToOffset + deltaCapacity, length);
            System.arraycopy(this.arrows, gapToOffset, newArrows, gapToOffset + deltaCapacity, length);
        }
        this.siblings = newSiblings;
        this.arrows = newArrows;
        this.free += deltaCapacity;
        this.capacity = newCapacity;
        this.gapSize += deltaCapacity;
    }

    void insertAtGap(int u, int data, int from, int to, int insertionIndex) {
        int length = to - from - insertionIndex;
        if (length > 0) {
            System.arraycopy(this.siblings, from + insertionIndex, this.siblings, from + insertionIndex + 1, length);
            System.arraycopy(this.arrows, from + insertionIndex, this.arrows, from + insertionIndex + 1, length);
        }
        this.siblings[from + insertionIndex] = u;
        this.arrows[from + insertionIndex] = data;
    }

    void insertBeforeGap(int u, int data, int from, int to, int insertionIndex) {
        int gapFrom = this.getSiblingsToOffset(this.gapIndex);
        int length = gapFrom - to;
        System.arraycopy(this.siblings, to, this.siblings, to + this.free, length);
        System.arraycopy(this.arrows, to, this.arrows, to + this.free, length);
        length = to - from - insertionIndex;
        System.arraycopy(this.siblings, from + insertionIndex, this.siblings, from + insertionIndex + 1, length);
        System.arraycopy(this.arrows, from + insertionIndex, this.arrows, from + insertionIndex + 1, length);
        this.siblings[from + insertionIndex] = u;
        this.arrows[from + insertionIndex] = data;
    }

    void insertAfterGap(int u, int data, int from, int to, int insertionIndex) {
        int gapFrom = this.getSiblingsToOffset(this.gapIndex);
        int length = from + insertionIndex - gapFrom - this.free;
        if (length > 0) {
            System.arraycopy(this.siblings, gapFrom + this.free, this.siblings, gapFrom, length);
            System.arraycopy(this.arrows, gapFrom + this.free, this.arrows, gapFrom, length);
        }
        this.siblings[from + insertionIndex - this.free] = u;
        this.arrows[from + insertionIndex - this.free] = data;
        length = to - from - insertionIndex;
        System.arraycopy(this.siblings, from + insertionIndex, this.siblings, from + insertionIndex - this.free + 1, length);
        System.arraycopy(this.arrows, from + insertionIndex, this.arrows, from + insertionIndex - this.free + 1, length);
    }

    void removeAtGap(int from, int to, int removalIndex) {
        int length = to - removalIndex - from - 1;
        if (length > 0) {
            System.arraycopy(this.siblings, from + removalIndex + 1, this.siblings, from + removalIndex, length);
            System.arraycopy(this.arrows, from + removalIndex + 1, this.arrows, from + removalIndex, length);
        }
    }

    void removeBeforeGap(int from, int to, int removalIndex) {
        int gapFrom = this.getSiblingsToOffset(this.gapIndex);
        int length = gapFrom - to;
        System.arraycopy(this.siblings, to, this.siblings, to + this.free, length);
        System.arraycopy(this.arrows, to, this.arrows, to + this.free, length);
        length = to - from - removalIndex;
        System.arraycopy(this.siblings, from + removalIndex + 1, this.siblings, from + removalIndex, length);
        System.arraycopy(this.arrows, from + removalIndex + 1, this.arrows, from + removalIndex, length);
    }

    void removeAfterGap(int from, int to, int removalIndex) {
        int gapFrom = this.getSiblingsToOffset(this.gapIndex);
        int length = from + removalIndex - gapFrom - this.gapSize;
        if (length > 0) {
            System.arraycopy(this.siblings, gapFrom + this.free, this.siblings, gapFrom, length);
            System.arraycopy(this.arrows, gapFrom + this.free, this.arrows, gapFrom, length);
        }
        length = to - from - removalIndex - 1;
        System.arraycopy(this.siblings, from + removalIndex + 1, this.siblings, from + removalIndex - this.free, length);
        System.arraycopy(this.arrows, from + removalIndex + 1, this.arrows, from + removalIndex - this.free, length);
    }
}

