/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.collection.enumerator.Enumerator;
import org.jhotdraw8.graph.AbstractDirectedGraphBuilder;
import org.jhotdraw8.graph.AttributedIndexedDirectedGraph;
import org.jhotdraw8.graph.DirectedGraph;
import org.jhotdraw8.graph.MutableDirectedGraph;
import org.jhotdraw8.icollection.facade.SetFacade;
import org.jspecify.annotations.Nullable;

public class SimpleMutableDirectedGraph<V, A>
extends AbstractDirectedGraphBuilder
implements MutableDirectedGraph<V, A>,
AttributedIndexedDirectedGraph<V, A> {
    private static final Object TOMBSTONE_OBJECT = new Object();
    private final Map<V, Integer> vertexMap;
    private final List<V> vertices;
    private final List<Object> arrows;
    private final Function<V, Integer> addVertexIfAbsent;

    public SimpleMutableDirectedGraph() {
        this(16, 16, false);
    }

    public SimpleMutableDirectedGraph(int vertexCapacity, int arrowCapacity) {
        this(vertexCapacity, arrowCapacity, false);
    }

    public SimpleMutableDirectedGraph(int vertexCapacity, int arrowCapacity, boolean identityMap) {
        super(vertexCapacity, arrowCapacity);
        this.vertexMap = identityMap ? new IdentityHashMap(vertexCapacity) : new HashMap(vertexCapacity);
        this.vertices = new ArrayList<V>(vertexCapacity);
        this.arrows = new ArrayList<Object>(arrowCapacity);
        this.addVertexIfAbsent = k -> {
            this.vertices.add(k);
            this.buildAddVertex();
            return this.vertices.size() - 1;
        };
    }

    public SimpleMutableDirectedGraph(DirectedGraph<V, A> graph) {
        this(graph, Function.identity(), (v1, v2, a) -> a);
    }

    public <VV, AA> SimpleMutableDirectedGraph(DirectedGraph<VV, AA> graph, Function<VV, V> vertexMapper, Function3<VV, VV, AA, A> arrowMapper) {
        super(graph.getVertexCount(), graph.getArrowCount());
        int vcount = graph.getVertexCount();
        this.vertexMap = new HashMap<V, Integer>(vcount);
        this.vertices = new ArrayList<V>(vcount);
        this.arrows = new ArrayList<Object>(graph.getArrowCount());
        this.addVertexIfAbsent = k -> {
            this.vertices.add(k);
            this.buildAddVertex();
            return this.vertices.size() - 1;
        };
        for (Object vv : graph.getVertices()) {
            this.addVertex(vertexMapper.apply(vv));
        }
        for (Object vv : graph.getVertices()) {
            int n = graph.getNextCount(vv);
            for (int j = 0; j < n; ++j) {
                Object next = graph.getNext(vv, j);
                this.addArrow(vertexMapper.apply(vv), vertexMapper.apply(next), arrowMapper.apply(vv, next, graph.getNextArrow(vv, j)));
            }
        }
    }

    @Override
    public void addArrow(V va, V vb, @Nullable A arrow) {
        Objects.requireNonNull(va, "va");
        Objects.requireNonNull(vb, "vb");
        int a = this.vertexMap.get(va);
        int b = this.vertexMap.get(vb);
        int arrowIndex = super.buildAddArrow(a, b);
        if (arrowIndex == this.arrows.size()) {
            this.arrows.add(arrow);
        } else {
            this.arrows.set(arrowIndex, arrow);
        }
    }

    @Override
    public void removeArrow(V v, V u, @Nullable A a) {
        int vidx = this.vertexMap.get(v);
        int uidx = this.vertexMap.get(u);
        int index = 0;
        Enumerator.OfInt it = this.nextVerticesEnumerator(vidx);
        while (it.moveNext()) {
            int widx = it.currentAsInt();
            if (uidx == widx && Objects.equals(a, this.getNextArrow(vidx, index))) {
                int indexOfRemovedArrow = this.buildRemoveArrowAt(this.vertexMap.get(v), index);
                this.arrows.set(indexOfRemovedArrow, TOMBSTONE_OBJECT);
                return;
            }
            ++index;
        }
    }

    @Override
    public void removeArrow(V v, V u) {
        Integer vidx = this.vertexMap.get(v);
        int index = 0;
        Enumerator.OfInt it = this.nextVerticesEnumerator(vidx);
        while (it.moveNext()) {
            int uidx = it.currentAsInt();
            if (u.equals(this.vertices.get(uidx))) {
                int indexOfRemovedArrow = this.buildRemoveArrowAt(this.vertexMap.get(v), index);
                this.arrows.set(indexOfRemovedArrow, TOMBSTONE_OBJECT);
                return;
            }
            ++index;
        }
    }

    @Override
    public void removeNext(V v, int k) {
        int indexOfRemovedArrow = this.buildRemoveArrowAt(this.vertexMap.get(v), k);
        this.arrows.set(indexOfRemovedArrow, TOMBSTONE_OBJECT);
    }

    public void addBidiArrow(V va, V vb, A arrow) {
        this.addArrow(va, vb, arrow);
        this.addArrow(vb, va, arrow);
    }

    @Override
    public void addVertex(V v) {
        Objects.requireNonNull(v, "v");
        this.vertexMap.computeIfAbsent((Integer)v, (Function<Integer, Integer>)this.addVertexIfAbsent);
    }

    public void addVertex(V v, int vidx) {
        Objects.requireNonNull(v, "v");
        this.buildInsertVertexAt(vidx);
        this.vertices.add(vidx, v);
        for (Map.Entry<Integer, Integer> entry : this.vertexMap.entrySet()) {
            Integer uidx = entry.getValue();
            if (uidx < vidx) continue;
            entry.setValue(uidx + 1);
        }
        this.vertexMap.put((Integer)v, vidx);
    }

    @Override
    public void removeVertex(V v) {
        Integer vidxBox = this.vertexMap.remove(v);
        if (vidxBox == null) {
            return;
        }
        int vidx = vidxBox;
        for (int i = this.getNextCount((V)vidx) - 1; i >= 0; --i) {
            int n = this.buildRemoveArrowAt(vidx, i);
            this.arrows.set(n, TOMBSTONE_OBJECT);
        }
        int n = this.getVertexCount();
        for (int uidx = 0; uidx < n; ++uidx) {
            for (int i = this.getNextCount((V)uidx) - 1; i >= 0; --i) {
                int next = this.getNextAsInt(uidx, i);
                if (next != vidx) continue;
                int indexOfRemovedArrow = this.buildRemoveArrowAt(uidx, i);
                this.arrows.set(indexOfRemovedArrow, TOMBSTONE_OBJECT);
            }
        }
        this.buildRemoveVertexAfterArrowsHaveBeenRemoved(vidx);
        this.vertices.remove(vidx);
        for (Map.Entry<Integer, Integer> entry : this.vertexMap.entrySet()) {
            Integer uidx = entry.getValue();
            if (uidx <= vidx) continue;
            entry.setValue(uidx - 1);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.vertexMap.clear();
        this.vertices.clear();
        this.arrows.clear();
    }

    @Override
    public A getNextArrow(V v, int index) {
        int arrowId = this.getNextArrowIndex(this.getVertexIndex(v), index);
        Object a = this.arrows.get(arrowId);
        return (A)a;
    }

    @Override
    public V getNext(V v, int i) {
        return this.getVertex(this.getNextAsInt(this.getVertexIndex(v), i));
    }

    @Override
    public int getNextCount(V v) {
        return this.getNextCount((V)this.getVertexIndex(v));
    }

    @Override
    public V getVertex(int vi) {
        if (this.vertices.get(vi) == null) {
            System.err.println("DIrectedGraphBuilder is broken");
        }
        return this.vertices.get(vi);
    }

    @Override
    public int getVertexIndex(V v) {
        Integer index = this.vertexMap.get(v);
        return index;
    }

    @Override
    public A getArrow(int index) {
        int i;
        int vidx = 0;
        int nextCount = this.getNextCount((V)vidx);
        for (i = index; i >= nextCount; i -= nextCount) {
            nextCount = this.getNextCount((V)(++vidx));
        }
        return this.getNextArrow(vidx, i);
    }

    @Override
    public A getNextArrow(int v, int index) {
        int arrowId = this.getNextArrowIndex(v, index);
        return (A)this.arrows.get(arrowId);
    }

    @Override
    public int getNextArrowAsInt(int v, int i) {
        return this.getNextAsInt(v, i);
    }

    @Override
    public Set<V> getVertices() {
        return new SetFacade(this.vertices::iterator, this.vertices::spliterator, this.vertices::size, this.vertices::contains, null, null, null);
    }
}

