/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.algo;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.jhotdraw8.collection.enumerator.Enumerator;
import org.jhotdraw8.collection.enumerator.IntRangeEnumerator;
import org.jhotdraw8.collection.primitive.IntArrayDeque;
import org.jhotdraw8.collection.primitive.IntArrayList;
import org.jhotdraw8.collection.primitive.IntList;
import org.jhotdraw8.graph.IndexedDirectedGraph;

public class IndexedStronglyConnectedComponentsAlgo {
    public List<IntList> findStronglyConnectedComponents(IndexedDirectedGraph graph) {
        return this.findStronglyConnectedComponents(graph.getVertexCount(), graph::nextVerticesEnumerator);
    }

    public List<IntList> findStronglyConnectedComponents(int vertexCount, Function<Integer, Enumerator.OfInt> nextNodeFunction) {
        ArrayList<IntList> sccs = new ArrayList<IntList>(vertexCount);
        int[] lows = new int[vertexCount];
        Arrays.fill(lows, -1);
        int pre = 0;
        IntArrayDeque stack = new IntArrayDeque();
        IntArrayDeque minStack = new IntArrayDeque();
        ArrayDeque<IntRangeEnumerator> enumeratorStack = new ArrayDeque<IntRangeEnumerator>();
        IntRangeEnumerator enumerator = new IntRangeEnumerator(vertexCount);
        while (true) {
            int low;
            int v;
            if (enumerator.moveNext()) {
                v = enumerator.currentAsInt();
                int low2 = lows[v];
                if (low2 == -1) {
                    low2 = pre++;
                    lows[v] = low2;
                    stack.pushAsInt(v);
                    minStack.pushAsInt(low2);
                    enumeratorStack.push(enumerator);
                    enumerator = nextNodeFunction.apply(v);
                    continue;
                }
                if (minStack.isEmpty()) continue;
                minStack.pushAsInt(Math.min(low2, minStack.popAsInt()));
                continue;
            }
            if (enumeratorStack.isEmpty()) break;
            enumerator = (Enumerator.OfInt)enumeratorStack.pop();
            v = enumerator.currentAsInt();
            int min = minStack.popAsInt();
            if (min < (low = lows[v])) {
                lows[v] = low = min;
            } else {
                int w;
                IntArrayList component = new IntArrayList();
                do {
                    w = stack.popAsInt();
                    component.addAsInt(w);
                    lows[w] = vertexCount;
                } while (w != v);
                sccs.add((IntList)component);
            }
            if (minStack.isEmpty()) continue;
            minStack.pushAsInt(Math.min(low, minStack.popAsInt()));
        }
        return sccs;
    }
}

