/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.algo;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.jhotdraw8.collection.enumerator.Enumerator;
import org.jhotdraw8.collection.enumerator.IteratorEnumeratorFacade;
import org.jhotdraw8.collection.primitive.IntArrayDeque;
import org.jhotdraw8.graph.DirectedGraph;

public class StronglyConnectedComponentsAlgo {
    public <V, A> List<List<V>> findStronglyConnectedComponents(DirectedGraph<V, A> graph) {
        return this.findStronglyConnectedComponents(graph.getVertices(), graph::getNextVertices);
    }

    public <V> List<List<V>> findStronglyConnectedComponents(Collection<? extends V> vertices, Function<V, Iterable<? extends V>> nextNodeFunction) {
        ArrayList<List<V>> sccs = new ArrayList<List<V>>();
        HashMap<Object, NodeData> nodeMap = new HashMap<Object, NodeData>();
        int pre = 0;
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        IntArrayDeque minStack = new IntArrayDeque();
        ArrayDeque<IteratorEnumeratorFacade> enumeratorStack = new ArrayDeque<IteratorEnumeratorFacade>();
        IteratorEnumeratorFacade enumerator = new IteratorEnumeratorFacade(vertices.iterator());
        while (true) {
            Object v;
            if (enumerator.moveNext()) {
                v = enumerator.current();
                NodeData vdata = (NodeData)nodeMap.get(v);
                if (vdata == null) {
                    vdata = new NodeData();
                    nodeMap.put(v, vdata);
                    vdata.low = pre++;
                    stack.push(v);
                    minStack.pushAsInt(vdata.low);
                    enumeratorStack.push(enumerator);
                    enumerator = new IteratorEnumeratorFacade(nextNodeFunction.apply(v).iterator());
                    continue;
                }
                if (minStack.isEmpty()) continue;
                minStack.pushAsInt(Math.min(vdata.low, minStack.popAsInt()));
                continue;
            }
            if (enumeratorStack.isEmpty()) break;
            enumerator = (Enumerator)enumeratorStack.pop();
            v = enumerator.current();
            int min = minStack.popAsInt();
            NodeData vdata = (NodeData)nodeMap.get(v);
            if (min < vdata.low) {
                vdata.low = min;
            } else {
                Object w;
                ArrayList component = new ArrayList();
                do {
                    w = stack.pop();
                    component.add(w);
                    NodeData wdata = (NodeData)nodeMap.get(w);
                    wdata.low = vertices.size();
                } while (!w.equals(v));
                sccs.add(component);
            }
            if (minStack.isEmpty()) continue;
            minStack.pushAsInt(Math.min(vdata.low, minStack.popAsInt()));
        }
        return sccs;
    }

    private static class NodeData {
        private int low;

        private NodeData() {
        }
    }
}

