/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.iterator;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;
import org.jhotdraw8.collection.enumerator.AbstractEnumerator;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jspecify.annotations.Nullable;

public class BfsDfsArcSpliterator<V, A>
extends AbstractEnumerator<Arc<V, A>> {
    private final Function<V, Iterable<Arc<V, A>>> nextFunction;
    private final Deque<Arc<V, A>> deque;
    private final AddToSet<Arc<V, A>> visited;
    private final boolean dfs;

    public BfsDfsArcSpliterator(Function<V, Iterable<Arc<V, A>>> nextArcsFunction, V root, boolean dfs) {
        this(nextArcsFunction, root, new HashSet()::add, dfs);
    }

    public BfsDfsArcSpliterator(@Nullable Function<V, Iterable<Arc<V, A>>> nextFunction, @Nullable V root, @Nullable AddToSet<Arc<V, A>> visited, boolean dfs) {
        super(Long.MAX_VALUE, 273);
        this.dfs = dfs;
        Objects.requireNonNull(nextFunction, "nextFunction");
        Objects.requireNonNull(root, "root");
        Objects.requireNonNull(visited, "visited");
        this.nextFunction = nextFunction;
        this.deque = new ArrayDeque<Arc<V, A>>(16);
        this.visited = visited;
        for (Arc<V, A> next : nextFunction.apply(root)) {
            if (!visited.add(next)) continue;
            this.deque.addLast(next);
        }
    }

    public boolean moveNext() {
        Arc<V, A> arc = this.current = this.dfs ? this.deque.pollLast() : this.deque.pollFirst();
        if (this.current == null) {
            return false;
        }
        for (Arc<V, A> next : this.nextFunction.apply(((Arc)this.current).getEnd())) {
            if (!this.visited.add(next)) continue;
            this.deque.addLast(next);
        }
        return true;
    }
}

